/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ldaptive.LdapURL;

public final class LdapURLActivatorService {
    public static final Duration PERIOD = Duration.ofMinutes(5L);
    private static final LdapURLActivatorService INSTANCE = new LdapURLActivatorService();
    private final List<LdapURL> inactiveUrls = new ArrayList<LdapURL>();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
        Thread t = new Thread(r, this.getClass().getSimpleName() + "-" + this.hashCode());
        t.setDaemon(true);
        return t;
    });

    private LdapURLActivatorService() {
        this.executor.scheduleAtFixedRate(this::testInactiveUrls, PERIOD.toMillis(), PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static LdapURLActivatorService getInstance() {
        return INSTANCE;
    }

    public void registerUrl(LdapURL url) {
        this.inactiveUrls.add(url);
    }

    public List<LdapURL> getInactiveUrls() {
        return Collections.unmodifiableList(this.inactiveUrls);
    }

    protected void testInactiveUrls() {
        for (LdapURL url : this.inactiveUrls) {
            if (url.isActive() || !url.getRetryMetadata().getConnectionStrategy().getRetryCondition().test(url)) continue;
            if (url.getRetryMetadata().getConnectionStrategy().getActivateCondition().test(url)) {
                url.getRetryMetadata().getConnectionStrategy().success(url);
                continue;
            }
            url.getRetryMetadata().recordFailure(Instant.now());
        }
        this.inactiveUrls.removeIf(LdapURL::isActive);
    }

    void clear() {
        this.inactiveUrls.clear();
    }
}

