/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.LdapURL;
import org.ldaptive.LdapURLActivatorService;
import org.ldaptive.LdapURLRetryMetadata;
import org.ldaptive.LdapURLSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionStrategy
implements ConnectionStrategy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LdapURLSet ldapURLSet;
    private boolean initialized;
    private Predicate<LdapURL> activateCondition;
    private Predicate<LdapURL> retryCondition = url -> Instant.now().isAfter(url.getRetryMetadata().getFailureTime().plus(LdapURLActivatorService.PERIOD));

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void initialize(String urls, Predicate<LdapURL> condition) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Strategy has already been initialized");
        }
        this.ldapURLSet = new LdapURLSet(this, urls);
        this.activateCondition = condition;
        this.initialized = true;
    }

    @Override
    public void populate(String urls, LdapURLSet urlSet) {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("urls cannot be empty or null");
        }
        if (urls.contains(" ")) {
            urlSet.populate(Stream.of(urls.split(" ")).map(s -> {
                LdapURL url = new LdapURL((String)s);
                url.setRetryMetadata(new LdapURLRetryMetadata(this));
                return url;
            }).collect(Collectors.toList()));
        } else {
            LdapURL url = new LdapURL(urls);
            url.setRetryMetadata(new LdapURLRetryMetadata(this));
            urlSet.populate(Collections.singletonList(url));
        }
    }

    @Override
    public Predicate<LdapURL> getActivateCondition() {
        return this.activateCondition;
    }

    @Override
    public Predicate<LdapURL> getRetryCondition() {
        return this.retryCondition;
    }

    public void setRetryCondition(Predicate<LdapURL> condition) {
        this.retryCondition = condition;
    }

    @Override
    public void success(LdapURL url) {
        url.activate();
        url.getRetryMetadata().recordSuccess(Instant.now());
    }

    @Override
    public void failure(LdapURL url) {
        url.deactivate();
        url.getRetryMetadata().recordFailure(Instant.now());
        LdapURLActivatorService.getInstance().registerUrl(url);
    }

    protected static class DefaultLdapURLIterator
    implements Iterator<LdapURL> {
        private final List<LdapURL> ldapUrls;
        private int i;

        public DefaultLdapURLIterator(List<LdapURL> urls) {
            this.ldapUrls = urls;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.ldapUrls.size();
        }

        @Override
        public LdapURL next() {
            return this.ldapUrls.get(this.i++);
        }
    }
}

