/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.group;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.jami.jams.common.annotations.JsonContent;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.objects.user.Group;
import net.jami.jams.common.objects.user.UserGroupMapping;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.workflows.AddUserToGroupFlow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/admin/group"})
public class GroupServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GroupServlet.class);

    @Override
    @JsonContent
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        List<Object> groups = new ArrayList();
        Group singleGroup = null;
        if (!req.getParameter("groupName").equals("*")) {
            StatementList statementList = new StatementList();
            StatementElement st = new StatementElement("name", "=", req.getParameter("groupName"), "");
            statementList.addStatement(st);
            singleGroup = (Group)Server.dataStore.getGroupDao().getObjects(statementList).get(0);
        } else {
            groups = Server.dataStore.getGroupDao().getObjects(null);
        }
        if (singleGroup != null) {
            Group finalSingleGroup = singleGroup;
            List<UserProfile> profiles = Server.dataStore.getUserProfileDao().getObjects(null).stream().filter(profile -> profile.getGroupMemberships().contains(finalSingleGroup.getName())).collect(Collectors.toList());
            profiles.forEach(profile -> finalSingleGroup.getGroupMembers().add(profile.getUsername()));
            resp.getOutputStream().write(JsonStream.serialize(finalSingleGroup).getBytes());
            resp.setStatus(200);
        }
        if (!groups.isEmpty()) {
            List profiles = Server.dataStore.getUserProfileDao().getObjects(null);
            for (Group group : groups) {
                for (UserProfile p : profiles) {
                    if (!p.getGroupMemberships().contains(group.getName())) continue;
                    group.getGroupMembers().add(p.getUsername());
                }
            }
            resp.getOutputStream().write(JsonStream.serialize(groups).getBytes());
            resp.setStatus(200);
        } else {
            log.info("No existing groups were found.");
            resp.setStatus(200);
        }
    }

    @Override
    @JsonContent
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String name = req.getParameter("groupName");
        String newName = req.getParameter("newName");
        String blueprint = req.getParameter("blueprintName");
        StatementList statementList = new StatementList();
        StatementElement st = new StatementElement("name", "=", name, "");
        statementList.addStatement(st);
        Group targetGroup = (Group)Server.dataStore.getGroupDao().getObjects(statementList).get(0);
        List<UserProfile> profiles = Server.dataStore.getUserProfileDao().getObjects(null).stream().filter(profile -> profile.getGroupMemberships().contains(targetGroup.getName())).collect(Collectors.toList());
        profiles.forEach(profile -> targetGroup.getGroupMembers().add(profile.getUsername()));
        String groupMembers = req.getParameter("groupMembers");
        if (!targetGroup.getGroupMembers().contains(groupMembers)) {
            AddUserToGroupFlow.addUserToGroup(name, req.getParameter("groupMembers"));
        } else {
            statementList = new StatementList();
            st = new StatementElement("username", "=", groupMembers, "");
            statementList.addStatement(st);
            UserProfile targetProfile = (UserProfile)Server.dataStore.getUserProfileDao().getObjects(statementList).get(0);
            UserGroupMapping mapping = (UserGroupMapping)Server.dataStore.getUserGroupMappingsDao().getObjects(statementList).get(0);
            mapping.removeGroup(name);
            StatementList update = new StatementList();
            StatementElement st0 = new StatementElement("groups", "=", mapping.getGroups(), "");
            update.addStatement(st0);
            StatementList constraint = new StatementList();
            StatementElement st1 = new StatementElement("username", "=", mapping.getUsername(), "");
            constraint.addStatement(st1);
            Server.dataStore.getUserGroupMappingsDao().updateObject(update, constraint);
            List groups = targetProfile.getGroupMemberships();
            groups.remove(name);
            Server.dataStore.updateUserProfile(targetProfile);
        }
        StatementList update = new StatementList();
        StatementElement st0 = newName != null ? new StatementElement("name", "=", newName, "") : new StatementElement("name", "=", name, "");
        StatementElement st1 = new StatementElement("blueprint", "=", blueprint, "");
        update.addStatement(st0);
        update.addStatement(st1);
        StatementList constraint = new StatementList();
        StatementElement st2 = new StatementElement("name", "=", name, "");
        constraint.addStatement(st2);
        if (Server.dataStore.getGroupDao().updateObject(update, constraint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "could not update the group's name!");
        }
    }

    @Override
    @JsonContent
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        Group group = new Group();
        group.setName(req.getParameter("name"));
        group.setBlueprint(req.getParameter("blueprintName"));
        group.setGroupMembers(new ArrayList());
        if (Server.dataStore.getGroupDao().storeObject(group)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Could not create a group successfully!");
        }
    }

    @Override
    @JsonContent
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        StatementElement statementElement = new StatementElement("name", "=", req.getParameter("groupName"), "");
        StatementList constraint = new StatementList();
        constraint.addStatement(statementElement);
        if (Server.dataStore.getGroupDao().deleteObject(constraint)) {
            List validProfiles = Server.dataStore.getUserProfileDao().getObjects(null).stream().filter(profile -> profile.getGroupMemberships().remove(req.getParameter("groupName"))).collect(Collectors.toList());
            validProfiles.parallelStream().forEach(profile -> {
                StatementList statementList = new StatementList();
                StatementElement st = new StatementElement("username", "=", profile.getUsername(), "");
                statementList.addStatement(st);
                UserGroupMapping mapping = (UserGroupMapping)Server.dataStore.getUserGroupMappingsDao().getObjects(statementList).get(0);
                mapping.removeGroup(req.getParameter("groupName"));
                StatementList update = new StatementList();
                StatementElement st0 = new StatementElement("groups", "=", mapping.getGroups(), "");
                update.addStatement(st0);
                StatementList constraint2 = new StatementList();
                StatementElement st1 = new StatementElement("username", "=", mapping.getUsername(), "");
                constraint2.addStatement(st1);
                Server.dataStore.getUserGroupMappingsDao().updateObject(update, constraint2);
                Server.dataStore.updateUserProfile((UserProfile)profile);
            });
            resp.setStatus(200);
        } else {
            resp.sendError(500, "Could not delete the group successfully!");
        }
    }
}

