/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.servlets.api.admin.devices;

import com.jsoniter.output.JsonStream;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.responses.DeviceRevocationResponse;
import net.jami.jams.common.objects.user.AccessLevel;
import net.jami.jams.common.serialization.tomcat.TomcatCustomErrorHandler;
import net.jami.jams.server.Server;
import net.jami.jams.server.core.workflows.RevokeDeviceFlow;

@WebServlet(value={"/api/admin/device"})
public class DeviceServlet
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        String deviceId = req.getParameter("deviceId");
        StatementList statementList = new StatementList();
        StatementElement st1 = new StatementElement("owner", "=", username, "AND");
        StatementElement st2 = new StatementElement("deviceId", "=", deviceId, "");
        statementList.addStatement(st1);
        statementList.addStatement(st2);
        resp.getOutputStream().write(JsonStream.serialize(Server.dataStore.getDeviceDao().getObjects(statementList).get(0)).getBytes());
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        String username = req.getParameter("username");
        String deviceId = req.getParameter("deviceId");
        String deviceName = req.getParameter("deviceName");
        StatementList update = new StatementList();
        StatementElement st0 = new StatementElement("deviceName", "=", deviceName, "");
        update.addStatement(st0);
        StatementList constraint = new StatementList();
        StatementElement st1 = new StatementElement("owner", "=", username, "AND");
        StatementElement st2 = new StatementElement("deviceId", "=", deviceId, "");
        update.addStatement(st1);
        update.addStatement(st2);
        if (Server.dataStore.getDeviceDao().updateObject(update, constraint)) {
            resp.setStatus(200);
        } else {
            resp.sendError(500, "could not update the device's information!");
        }
    }

    @Override
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean bl = false;
        AccessLevel accessLevel = (AccessLevel)req.getAttribute("accessLevel");
        if (accessLevel == AccessLevel.valueOf((String)"ADMIN")) {
            bl = true;
        }
        if (!bl) {
            TomcatCustomErrorHandler.sendCustomError((HttpServletResponse)resp, (int)403, (String)"You do not have sufficient permissions to access this resource!");
            return;
        }
        DeviceRevocationResponse devResponse = RevokeDeviceFlow.revokeDevice(req.getParameter("username").toString(), req.getParameter("deviceId"));
        if (devResponse != null) {
            resp.getOutputStream().write(JsonStream.serialize(devResponse).getBytes());
        } else {
            resp.sendError(500, "An exception has occurred while trying to revoke a device!");
        }
    }
}

