/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.server.core.workflows;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jami.jams.common.dao.StatementElement;
import net.jami.jams.common.dao.StatementList;
import net.jami.jams.common.objects.user.UserGroupMapping;
import net.jami.jams.common.objects.user.UserProfile;
import net.jami.jams.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddUserToGroupFlow {
    private static final Logger log = LoggerFactory.getLogger(AddUserToGroupFlow.class);

    public static void addUserToGroup(String groupName, String username) {
        Server.userAuthenticationModule.getAuthSources().forEach((k, v) -> {
            UserProfile profile = v.getUserProfile(username);
            List groupProfiles = v.searchUserProfiles(username, "LOGON_NAME", Optional.empty());
            if (!groupProfiles.isEmpty()) {
                UserGroupMapping mapping = null;
                StatementList statementList = new StatementList();
                statementList.addStatement(new StatementElement("username", "=", username, ""));
                if (Server.dataStore.getUserGroupMappingsDao().getObjects(statementList).isEmpty()) {
                    try {
                        mapping = new UserGroupMapping();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    mapping.setUsername(username);
                    mapping.setGroups("");
                    mapping.addGroup(groupName);
                    Server.dataStore.getUserGroupMappingsDao().storeObject(mapping);
                } else {
                    mapping = (UserGroupMapping)Server.dataStore.getUserGroupMappingsDao().getObjects(statementList).get(0);
                    if (!mapping.getGroups().contains(groupName)) {
                        mapping.addGroup(groupName);
                        String newGroups = mapping.getGroups();
                        StatementList update = new StatementList();
                        StatementElement st0 = new StatementElement("groups", "=", newGroups, "");
                        update.addStatement(st0);
                        StatementList constraint = new StatementList();
                        StatementElement st1 = new StatementElement("username", "=", username, "");
                        constraint.addStatement(st1);
                        Server.dataStore.getUserGroupMappingsDao().updateObject(update, constraint);
                    }
                }
                if (profile != null) {
                    if (profile.getGroupMemberships() == null) {
                        profile.setGroupMemberships(new ArrayList());
                    }
                    if (!profile.getGroupMemberships().contains(groupName)) {
                        profile.getGroupMemberships().add(groupName);
                    }
                    Server.dataStore.updateUserProfile(profile);
                }
            }
        });
    }
}

