/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.nameserver;

import com.jsoniter.JsonIterator;
import com.jsoniter.output.JsonStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.jami.jams.common.jami.NameLookupResponse;
import net.jami.jams.common.jami.NameRegistrationRequest;
import net.jami.jams.common.jami.NameServer;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicNameServer
implements NameServer {
    private static final Logger log = LoggerFactory.getLogger(PublicNameServer.class);
    private final String nameserverURI;

    public PublicNameServer(String nameserverURI) {
        this.nameserverURI = nameserverURI;
    }

    public Integer registerName(String username, NameRegistrationRequest nameRegistrationRequest) {
        try {
            URL url = new URL(this.nameserverURI + "/name/" + username);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.getOutputStream().write(JsonStream.serialize(nameRegistrationRequest).getBytes());
            return con.getResponseCode();
        }
        catch (Exception e) {
            return 500;
        }
    }

    public NameLookupResponse getAddressFromName(String username) {
        try {
            URL url = new URL(this.nameserverURI + "/name/" + username);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (con.getResponseCode() == 200) {
                StringBuilder responseData = new StringBuilder();
                int respSize = Integer.parseInt(con.getHeaderField("Content-Length"));
                for (int currentSize = 0; currentSize < respSize; ++currentSize) {
                    responseData.append((char)con.getInputStream().read());
                }
                log.info("Response received from public nameserver {} ", (Object)responseData.toString());
                return JsonIterator.deserialize(responseData.toString(), NameLookupResponse.class);
            }
            return null;
        }
        catch (Exception e) {
            log.info("An error occurred while querying the public nameserver {} ", (Object)e.toString());
            return null;
        }
    }

    public String getNameFromAddress(String address) {
        try {
            URL url = new URL(this.nameserverURI + "/addr/" + address);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (con.getResponseCode() == 200) {
                StringBuilder responseData = new StringBuilder();
                int respSize = Integer.parseInt(con.getHeaderField("Content-Length"));
                for (int currentSize = 0; currentSize < respSize; ++currentSize) {
                    responseData.append((char)con.getInputStream().read());
                }
                log.info("Response received from public nameserver {} ", (Object)responseData.toString());
                JSONParser parser = new JSONParser();
                JSONObject json = (JSONObject)parser.parse(responseData.toString());
                return json.getAsString("name");
            }
            return null;
        }
        catch (Exception e) {
            log.info("An error occurred while querying the public nameserver {} ", (Object)e.toString());
            return null;
        }
    }

    public String getURI() {
        return this.nameserverURI;
    }
}

