/*
 * Decompiled with CFR 0.152.
 */
package net.jami.jams.ca.workers.csr.builders;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.util.Date;
import net.jami.jams.ca.JamsCA;
import net.jami.jams.ca.workers.csr.utils.CertificateSigner;
import net.jami.jams.ca.workers.csr.utils.ExtensionLibrary;
import net.jami.jams.common.objects.user.User;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserBuilder {
    private static final Logger log = LoggerFactory.getLogger(UserBuilder.class);

    public static User generateUser(User user) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(4096);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(new JcaX509CertificateHolder(JamsCA.CA.getCertificate()).getSubject(), new BigInteger(256, new SecureRandom()), new Date(System.currentTimeMillis() - 43200000L), new Date(System.currentTimeMillis() + JamsCA.userLifetime), new X500Name(user.getX509Fields().getDN()), SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
            user.setPrivateKey(keyPair.getPrivate());
            user.setCertificate(CertificateSigner.signCertificate(JamsCA.CA.getPrivateKey(), builder, ExtensionLibrary.userExtensions));
            return user;
        }
        catch (Exception e) {
            log.error("Could not generate a user certificate: " + e.toString());
            return null;
        }
    }
}

