/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.sql.Date;
import java.time.ZoneOffset;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.ConversionUtils;
import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class JavaLocalDateToSqlDateConversion
extends SimpleConversion {
    @Override
    protected String getToExpression(ConversionContext conversionContext) {
        return "new " + ConversionUtils.sqlDate(conversionContext) + "( <SOURCE>.atStartOfDay( " + ConversionUtils.zoneOffset(conversionContext) + ".UTC ).toInstant().toEpochMilli() )";
    }

    @Override
    protected Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(Date.class), conversionContext.getTypeFactory().getType(ZoneOffset.class));
    }

    @Override
    protected String getFromExpression(ConversionContext conversionContext) {
        return "<SOURCE>.toLocalDate()";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(ZoneOffset.class));
    }
}

