/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.any.NotFoundAny;
import com.jsoniter.output.JsonStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MapWrapperAny
extends Any {
    private final Map val;
    private Map<String, Any> cache;

    public MapWrapperAny(Map val2) {
        this.val = val2;
    }

    @Override
    public ValueType valueType() {
        return ValueType.OBJECT;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        return this.size() != 0;
    }

    @Override
    public int toInt() {
        return this.size();
    }

    @Override
    public long toLong() {
        return this.size();
    }

    @Override
    public float toFloat() {
        return this.size();
    }

    @Override
    public double toDouble() {
        return this.size();
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.size());
    }

    @Override
    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.size());
    }

    @Override
    public String toString() {
        if (this.cache == null) {
            return JsonStream.serialize(this.val);
        }
        this.fillCache();
        return JsonStream.serialize(this.cache);
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        if (this.cache == null) {
            stream.writeVal(this.val);
        } else {
            this.fillCache();
            stream.writeVal(this.cache);
        }
    }

    @Override
    public int size() {
        return this.val.size();
    }

    @Override
    public Any get(Object key) {
        return this.fillCacheUntil(key);
    }

    @Override
    public Any get(Object[] keys, int idx) {
        if (idx == keys.length) {
            return this;
        }
        Object key = keys[idx];
        if (this.isWildcard(key)) {
            this.fillCache();
            HashMap<String, Any> result = new HashMap<String, Any>();
            for (Map.Entry<String, Any> entry : this.cache.entrySet()) {
                Any mapped = entry.getValue().get(keys, idx + 1);
                if (mapped.valueType() == ValueType.INVALID) continue;
                result.put(entry.getKey(), mapped);
            }
            return Any.rewrap(result);
        }
        Any child = this.fillCacheUntil(key);
        if (child == null) {
            return new NotFoundAny(keys, idx, this.object());
        }
        return child.get(keys, idx + 1);
    }

    @Override
    public Any.EntryIterator entries() {
        return new WrapperIterator();
    }

    private Any fillCacheUntil(Object target) {
        Any element;
        if (this.cache == null) {
            this.cache = new HashMap<String, Any>();
        }
        if ((element = this.cache.get(target)) != null) {
            return element;
        }
        Set entries = this.val.entrySet();
        int targetHashcode = target.hashCode();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (this.cache.containsKey(key)) continue;
            element = Any.wrap(entry.getValue());
            this.cache.put(key, element);
            if (targetHashcode != key.hashCode() || !target.equals(key)) continue;
            return element;
        }
        return new NotFoundAny(target, (Object)this.val);
    }

    private void fillCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, Any>();
        }
        Set entries = this.val.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (this.cache.containsKey(key)) continue;
            Any element = Any.wrap(entry.getValue());
            this.cache.put(key, element);
        }
    }

    private class WrapperIterator
    implements Any.EntryIterator {
        private final Iterator<Map.Entry<String, Object>> iter;
        private String key;
        private Any value;

        private WrapperIterator() {
            Set entries = MapWrapperAny.this.val.entrySet();
            this.iter = entries.iterator();
        }

        @Override
        public boolean next() {
            if (MapWrapperAny.this.cache == null) {
                MapWrapperAny.this.cache = new HashMap();
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            Map.Entry<String, Object> entry = this.iter.next();
            this.key = entry.getKey();
            this.value = (Any)MapWrapperAny.this.cache.get(this.key);
            if (this.value == null) {
                this.value = Any.wrap(entry.getValue());
                MapWrapperAny.this.cache.put(this.key, this.value);
            }
            return true;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Any value() {
            return this.value;
        }
    }
}

