/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.any.NotFoundAny;
import com.jsoniter.output.JsonStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ListWrapperAny
extends Any {
    private final List val;
    private List<Any> cache;

    public ListWrapperAny(List val2) {
        this.val = val2;
    }

    @Override
    public ValueType valueType() {
        return ValueType.ARRAY;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        return !this.val.isEmpty();
    }

    @Override
    public int toInt() {
        return this.size();
    }

    @Override
    public long toLong() {
        return this.size();
    }

    @Override
    public float toFloat() {
        return this.size();
    }

    @Override
    public double toDouble() {
        return this.size();
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.size());
    }

    @Override
    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.size());
    }

    @Override
    public String toString() {
        if (this.cache == null) {
            return JsonStream.serialize(this.val);
        }
        this.fillCache();
        return JsonStream.serialize(this.cache);
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        if (this.cache == null) {
            stream.writeVal(this.val);
        } else {
            this.fillCache();
            stream.writeVal(this.cache);
        }
    }

    @Override
    public int size() {
        return this.val.size();
    }

    @Override
    public Any get(int index) {
        return this.fillCacheUntil(index);
    }

    @Override
    public Any get(Object[] keys, int idx) {
        if (idx == keys.length) {
            return this;
        }
        Object key = keys[idx];
        if (this.isWildcard(key)) {
            this.fillCache();
            ArrayList<Any> result = new ArrayList<Any>();
            for (Any element : this.cache) {
                Any mapped = element.get(keys, idx + 1);
                if (mapped.valueType() == ValueType.INVALID) continue;
                result.add(mapped);
            }
            return Any.rewrap(result);
        }
        try {
            return this.fillCacheUntil((Integer)key).get(keys, idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return new NotFoundAny(keys, idx, this.object());
        }
        catch (ClassCastException e) {
            return new NotFoundAny(keys, idx, this.object());
        }
    }

    @Override
    public Iterator<Any> iterator() {
        return new WrapperIterator();
    }

    private void fillCache() {
        if (this.cache == null) {
            this.cache = new ArrayList<Any>();
        }
        if (this.cache.size() == this.val.size()) {
            return;
        }
        for (int i = this.cache.size(); i < this.val.size(); ++i) {
            Any element = Any.wrap(this.val.get(i));
            this.cache.add(element);
        }
    }

    private Any fillCacheUntil(int index) {
        if (this.cache == null) {
            this.cache = new ArrayList<Any>();
        }
        if (index < this.cache.size()) {
            return this.cache.get(index);
        }
        for (int i = this.cache.size(); i < this.val.size(); ++i) {
            Any element = Any.wrap(this.val.get(i));
            this.cache.add(element);
            if (index != i) continue;
            return element;
        }
        return new NotFoundAny(index, (Object)this.val);
    }

    private class WrapperIterator
    implements Iterator<Any> {
        private int index;

        private WrapperIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ListWrapperAny.this.val.size();
        }

        @Override
        public Any next() {
            if (ListWrapperAny.this.cache == null) {
                ListWrapperAny.this.cache = new ArrayList();
            }
            if (this.index == ListWrapperAny.this.cache.size()) {
                ListWrapperAny.this.cache.add(Any.wrap(ListWrapperAny.this.val.get(this.index)));
            }
            return (Any)ListWrapperAny.this.cache.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

