/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.Codegen;
import com.jsoniter.CodegenAccess;
import com.jsoniter.JsonIterator;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Array;

class ReflectionArrayDecoder
implements Decoder {
    private final Class componentType;
    private final Decoder compTypeDecoder;

    public ReflectionArrayDecoder(Class clazz) {
        this.componentType = clazz.getComponentType();
        this.compTypeDecoder = Codegen.getDecoder(TypeLiteral.create(this.componentType).getDecoderCacheKey(), this.componentType);
    }

    @Override
    public Object decode(JsonIterator iter) throws IOException {
        Object newArr;
        CodegenAccess.resetExistingObject(iter);
        if (iter.readNull()) {
            return null;
        }
        if (!CodegenAccess.readArrayStart(iter)) {
            return Array.newInstance(this.componentType, 0);
        }
        Object a1 = this.compTypeDecoder.decode(iter);
        if (CodegenAccess.nextToken(iter) != 44) {
            Object arr = Array.newInstance(this.componentType, 1);
            Array.set(arr, 0, a1);
            return arr;
        }
        Object a2 = this.compTypeDecoder.decode(iter);
        if (CodegenAccess.nextToken(iter) != 44) {
            Object arr = Array.newInstance(this.componentType, 2);
            Array.set(arr, 0, a1);
            Array.set(arr, 1, a2);
            return arr;
        }
        Object a3 = this.compTypeDecoder.decode(iter);
        if (CodegenAccess.nextToken(iter) != 44) {
            Object arr = Array.newInstance(this.componentType, 3);
            Array.set(arr, 0, a1);
            Array.set(arr, 1, a2);
            Array.set(arr, 2, a3);
            return arr;
        }
        Object a4 = this.compTypeDecoder.decode(iter);
        Object arr = Array.newInstance(this.componentType, 8);
        Array.set(arr, 0, a1);
        Array.set(arr, 1, a2);
        Array.set(arr, 2, a3);
        Array.set(arr, 3, a4);
        int i = 4;
        int arrLen = 8;
        while (CodegenAccess.nextToken(iter) == 44) {
            if (i == arrLen) {
                newArr = Array.newInstance(this.componentType, 2 * arrLen);
                System.arraycopy(arr, 0, newArr, 0, arrLen);
                arr = newArr;
                arrLen = 2 * arrLen;
            }
            Array.set(arr, i++, this.compTypeDecoder.decode(iter));
        }
        if (i == arrLen) {
            return arr;
        }
        newArr = Array.newInstance(this.componentType, i);
        System.arraycopy(arr, 0, newArr, 0, i);
        return newArr;
    }
}

