/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.CodegenImplNative;
import com.jsoniter.CodegenImplObjectStrict;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.ConstructorDescriptor;
import com.jsoniter.spi.WrapperDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class CodegenImplObjectHash {
    CodegenImplObjectHash() {
    }

    public static String genObjectUsingHash(ClassDescriptor desc) {
        Class clazz = desc.clazz;
        StringBuilder lines = new StringBuilder();
        CodegenImplObjectHash.append(lines, "java.lang.Object existingObj = com.jsoniter.CodegenAccess.resetExistingObject(iter);");
        CodegenImplObjectHash.append(lines, "byte nextToken = com.jsoniter.CodegenAccess.readByte(iter);");
        CodegenImplObjectHash.append(lines, "if (nextToken != '{') {");
        CodegenImplObjectHash.append(lines, "if (nextToken == 'n') {");
        CodegenImplObjectHash.append(lines, "com.jsoniter.CodegenAccess.skipFixedBytes(iter, 3);");
        CodegenImplObjectHash.append(lines, "return null;");
        CodegenImplObjectHash.append(lines, "} else {");
        CodegenImplObjectHash.append(lines, "nextToken = com.jsoniter.CodegenAccess.nextToken(iter);");
        CodegenImplObjectHash.append(lines, "if (nextToken == 'n') {");
        CodegenImplObjectHash.append(lines, "com.jsoniter.CodegenAccess.skipFixedBytes(iter, 3);");
        CodegenImplObjectHash.append(lines, "return null;");
        CodegenImplObjectHash.append(lines, "}");
        CodegenImplObjectHash.append(lines, "} // end of if null");
        CodegenImplObjectHash.append(lines, "} // end of if {");
        for (Binding binding : desc.ctor.parameters) {
            CodegenImplObjectHash.appendVarDef(lines, binding);
        }
        CodegenImplObjectHash.append(lines, "nextToken = com.jsoniter.CodegenAccess.readByte(iter);");
        CodegenImplObjectHash.append(lines, "if (nextToken != '\"') {");
        CodegenImplObjectHash.append(lines, "if (nextToken == '}') {");
        CodegenImplObjectHash.append(lines, "return {{newInst}};");
        CodegenImplObjectHash.append(lines, "} else {");
        CodegenImplObjectHash.append(lines, "nextToken = com.jsoniter.CodegenAccess.nextToken(iter);");
        CodegenImplObjectHash.append(lines, "if (nextToken == '}') {");
        CodegenImplObjectHash.append(lines, "return {{newInst}};");
        CodegenImplObjectHash.append(lines, "} else {");
        CodegenImplObjectHash.append(lines, "com.jsoniter.CodegenAccess.unreadByte(iter);");
        CodegenImplObjectHash.append(lines, "}");
        CodegenImplObjectHash.append(lines, "} // end of if end");
        CodegenImplObjectHash.append(lines, "} else { com.jsoniter.CodegenAccess.unreadByte(iter); }// end of if not quote");
        for (Binding binding : desc.fields) {
            if (binding.fromNames.length == 0) continue;
            CodegenImplObjectHash.appendVarDef(lines, binding);
        }
        for (Binding binding : desc.setters) {
            CodegenImplObjectHash.appendVarDef(lines, binding);
        }
        for (WrapperDescriptor wrapperDescriptor : desc.bindingTypeWrappers) {
            for (Binding param : wrapperDescriptor.parameters) {
                CodegenImplObjectHash.appendVarDef(lines, param);
            }
        }
        HashSet<Integer> knownHashes = new HashSet<Integer>();
        HashMap<String, Binding> hashMap = new HashMap<String, Binding>();
        for (Binding binding : desc.allDecoderBindings()) {
            for (String fromName : binding.fromNames) {
                hashMap.put(fromName, binding);
            }
        }
        ArrayList fromNames = new ArrayList(hashMap.keySet());
        Collections.sort(fromNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int y;
                int x = CodegenImplObjectHash.calcHash(o1);
                return x < (y = CodegenImplObjectHash.calcHash(o2)) ? -1 : (x == y ? 0 : 1);
            }
        });
        CodegenImplObjectHash.append(lines, "do {");
        CodegenImplObjectHash.append(lines, "switch (com.jsoniter.CodegenAccess.readObjectFieldAsHash(iter)) {");
        for (String fromName : fromNames) {
            int intHash = CodegenImplObjectHash.calcHash(fromName);
            if (intHash == 0) {
                return CodegenImplObjectStrict.genObjectUsingStrict(desc);
            }
            if (knownHashes.contains(intHash)) {
                return CodegenImplObjectStrict.genObjectUsingStrict(desc);
            }
            knownHashes.add(intHash);
            CodegenImplObjectHash.append(lines, "case " + intHash + ": ");
            CodegenImplObjectHash.appendBindingSet(lines, desc, (Binding)hashMap.get(fromName));
            CodegenImplObjectHash.append(lines, "continue;");
        }
        CodegenImplObjectHash.append(lines, "}");
        CodegenImplObjectHash.append(lines, "iter.skip();");
        CodegenImplObjectHash.append(lines, "} while (com.jsoniter.CodegenAccess.nextTokenIsComma(iter));");
        CodegenImplObjectHash.append(lines, CodegenImplNative.getTypeName(clazz) + " obj = {{newInst}};");
        for (Binding field : desc.fields) {
            if (field.fromNames.length == 0) continue;
            CodegenImplObjectHash.append(lines, String.format("obj.%s = _%s_;", field.field.getName(), field.name));
        }
        for (Binding setter : desc.setters) {
            CodegenImplObjectHash.append(lines, String.format("obj.%s(_%s_);", setter.method.getName(), setter.name));
        }
        CodegenImplObjectHash.appendWrappers(desc.bindingTypeWrappers, lines);
        CodegenImplObjectHash.append(lines, "return obj;");
        return lines.toString().replace("{{clazz}}", clazz.getCanonicalName()).replace("{{newInst}}", CodegenImplObjectHash.genNewInstCode(clazz, desc.ctor));
    }

    public static int calcHash(String fromName) {
        long hash = -2128831035L;
        for (byte b : fromName.getBytes()) {
            hash ^= (long)b;
            hash *= 16777619L;
        }
        return (int)hash;
    }

    private static void appendBindingSet(StringBuilder lines, ClassDescriptor desc, Binding binding) {
        CodegenImplObjectHash.append(lines, String.format("_%s_ = %s;", binding.name, CodegenImplNative.genField(binding)));
    }

    static void appendWrappers(List<WrapperDescriptor> wrappers, StringBuilder lines) {
        for (WrapperDescriptor wrapper : wrappers) {
            lines.append("obj.");
            lines.append(wrapper.method.getName());
            CodegenImplObjectHash.appendInvocation(lines, wrapper.parameters);
            lines.append(";\n");
        }
    }

    static void appendVarDef(StringBuilder lines, Binding parameter) {
        String typeName = CodegenImplNative.getTypeName(parameter.valueType);
        CodegenImplObjectHash.append(lines, String.format("%s _%s_ = %s;", typeName, parameter.name, CodegenImplObjectStrict.DEFAULT_VALUES.get(typeName)));
    }

    static String genNewInstCode(Class clazz, ConstructorDescriptor ctor) {
        StringBuilder code = new StringBuilder();
        if (ctor.parameters.isEmpty()) {
            code.append("(existingObj == null ? ");
        }
        if (ctor.objectFactory != null) {
            code.append(String.format("(%s)com.jsoniter.spi.JsoniterSpi.create(%s.class)", clazz.getCanonicalName(), clazz.getCanonicalName()));
        } else if (ctor.staticMethodName == null) {
            code.append(String.format("new %s", clazz.getCanonicalName()));
        } else {
            code.append(String.format("%s.%s", clazz.getCanonicalName(), ctor.staticMethodName));
        }
        List<Binding> params = ctor.parameters;
        if (ctor.objectFactory == null) {
            CodegenImplObjectHash.appendInvocation(code, params);
        }
        if (ctor.parameters.isEmpty()) {
            code.append(String.format(" : (%s)existingObj)", clazz.getCanonicalName()));
        }
        return code.toString();
    }

    private static void appendInvocation(StringBuilder code, List<Binding> params) {
        code.append("(");
        boolean isFirst = true;
        for (Binding ctorParam : params) {
            if (isFirst) {
                isFirst = false;
            } else {
                code.append(",");
            }
            code.append(String.format("_%s_", ctorParam.name));
        }
        code.append(")");
    }

    static void append(StringBuilder lines, String str) {
        lines.append(str);
        lines.append("\n");
    }
}

