// Copyright (c) 2018-2019, The rav1e contributors. All rights reserved
//
// This source code is subject to the terms of the BSD 2 Clause License and
// the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
// was not distributed with this source code in the LICENSE file, you can
// obtain it at www.aomedia.org/license/software. If the Alliance for Open
// Media Patent License 1.0 was not distributed with this source code in the
// PATENTS file, you can obtain it at www.aomedia.org/license/patent.

#![allow(non_upper_case_globals)]
#![allow(dead_code)]
#![allow(non_camel_case_types)]

const MAX_NEIGHBORS: usize = 2;

use crate::transform::*;

#[repr(C)]
pub struct SCAN_ORDER {
  pub scan: &'static [u16],
}

// To stop from having to perform an unnecessary transpose in the forward and
// inverse transforms, the output of the forward transform is transposed in
// relation to how is in the spec. This means that all of our scan orders are
// different from what is found the spec.

#[rustfmt::skip]
static default_scan_4x4 : [u16; 16] = [
  0, 4, 1, 2, 5, 8, 12, 9, 6, 3, 7, 10, 13, 14, 11, 15,
];

#[rustfmt::skip]
static mrow_scan_4x4 : [u16; 16] = [
  0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15,
];

#[rustfmt::skip]
static mcol_scan_4x4 : [u16; 16] = [
  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
];

#[rustfmt::skip]
static default_scan_8x4 : [u16; 32] = [
  0,  1,  4,  2,  5,  8,  3,  6,  9,  12, 7,  10, 13, 16, 11, 14,
  17, 20, 15, 18, 21, 24, 19, 22, 25, 28, 23, 26, 29, 27, 30, 31,
];

#[rustfmt::skip]
static mrow_scan_8x4 : [u16; 32] = [
  0, 4, 8,  12, 16, 20, 24, 28, 1, 5, 9,  13, 17, 21, 25, 29,
  2, 6, 10, 14, 18, 22, 26, 30, 3, 7, 11, 15, 19, 23, 27, 31,
];

#[rustfmt::skip]
static mcol_scan_8x4 : [u16; 32] = [
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
];

#[rustfmt::skip]
static default_scan_4x8 : [u16; 32] = [
  0,  8, 1,  16, 9,  2, 24, 17, 10, 3, 25, 18, 11, 4,  26, 19,
  12, 5, 27, 20, 13, 6, 28, 21, 14, 7, 29, 22, 15, 30, 23, 31,
];

#[rustfmt::skip]
static mrow_scan_4x8 : [u16; 32] = [
  0, 8,  16, 24, 1, 9,  17, 25, 2, 10, 18, 26, 3, 11, 19, 27,
  4, 12, 20, 28, 5, 13, 21, 29, 6, 14, 22, 30, 7, 15, 23, 31,
];

#[rustfmt::skip]
static mcol_scan_4x8 : [u16; 32] = [
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
];

#[rustfmt::skip]
static default_scan_16x4 : [u16; 64] = [
  0,  1,  4,  2,  5,  8,  3,  6,  9,  12, 7,  10, 13, 16, 11, 14,
  17, 20, 15, 18, 21, 24, 19, 22, 25, 28, 23, 26, 29, 32, 27, 30,
  33, 36, 31, 34, 37, 40, 35, 38, 41, 44, 39, 42, 45, 48, 43, 46,
  49, 52, 47, 50, 53, 56, 51, 54, 57, 60, 55, 58, 61, 59, 62, 63,
];

#[rustfmt::skip]
static default_scan_4x16 : [u16; 64] = [
  0,  16, 1,  32, 17, 2,  48, 33, 18, 3,  49, 34, 19, 4,  50, 35,
  20, 5,  51, 36, 21, 6,  52, 37, 22, 7,  53, 38, 23, 8,  54, 39,
  24, 9,  55, 40, 25, 10, 56, 41, 26, 11, 57, 42, 27, 12, 58, 43,
  28, 13, 59, 44, 29, 14, 60, 45, 30, 15, 61, 46, 31, 62, 47, 63,
];

#[rustfmt::skip]
static mcol_scan_16x4 : [u16; 64] = [
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
];

#[rustfmt::skip]
static mcol_scan_4x16 : [u16; 64] = [
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
];

#[rustfmt::skip]
static mrow_scan_16x4 : [u16; 64] = [
  0, 4, 8,  12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60,
  1, 5, 9,  13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61,
  2, 6, 10, 14, 18, 22, 26, 30, 34, 38, 42, 46, 50, 54, 58, 62,
  3, 7, 11, 15, 19, 23, 27, 31, 35, 39, 43, 47, 51, 55, 59, 63,
];

#[rustfmt::skip]
static mrow_scan_4x16 : [u16; 64] = [
  0,  16, 32, 48, 1,  17, 33, 49, 2,  18, 34, 50, 3,  19, 35, 51,
  4,  20, 36, 52, 5,  21, 37, 53, 6,  22, 38, 54, 7,  23, 39, 55,
  8,  24, 40, 56, 9,  25, 41, 57, 10, 26, 42, 58, 11, 27, 43, 59,
  12, 28, 44, 60, 13, 29, 45, 61, 14, 30, 46, 62, 15, 31, 47, 63,
];

#[rustfmt::skip]
static default_scan_32x8 : [u16; 256] = [
  0,   1,   8,   2,   9,   16,  3,   10,  17,  24,  4,   11,  18,  25,  32,
  5,   12,  19,  26,  33,  40,  6,   13,  20,  27,  34,  41,  48,  7,   14,
  21,  28,  35,  42,  49,  56,  15,  22,  29,  36,  43,  50,  57,  64,  23,
  30,  37,  44,  51,  58,  65,  72,  31,  38,  45,  52,  59,  66,  73,  80,
  39,  46,  53,  60,  67,  74,  81,  88,  47,  54,  61,  68,  75,  82,  89,
  96,  55,  62,  69,  76,  83,  90,  97,  104, 63,  70,  77,  84,  91,  98,
  105, 112, 71,  78,  85,  92,  99,  106, 113, 120, 79,  86,  93,  100, 107,
  114, 121, 128, 87,  94,  101, 108, 115, 122, 129, 136, 95,  102, 109, 116,
  123, 130, 137, 144, 103, 110, 117, 124, 131, 138, 145, 152, 111, 118, 125,
  132, 139, 146, 153, 160, 119, 126, 133, 140, 147, 154, 161, 168, 127, 134,
  141, 148, 155, 162, 169, 176, 135, 142, 149, 156, 163, 170, 177, 184, 143,
  150, 157, 164, 171, 178, 185, 192, 151, 158, 165, 172, 179, 186, 193, 200,
  159, 166, 173, 180, 187, 194, 201, 208, 167, 174, 181, 188, 195, 202, 209,
  216, 175, 182, 189, 196, 203, 210, 217, 224, 183, 190, 197, 204, 211, 218,
  225, 232, 191, 198, 205, 212, 219, 226, 233, 240, 199, 206, 213, 220, 227,
  234, 241, 248, 207, 214, 221, 228, 235, 242, 249, 215, 222, 229, 236, 243,
  250, 223, 230, 237, 244, 251, 231, 238, 245, 252, 239, 246, 253, 247, 254,
  255,
];

#[rustfmt::skip]
static default_scan_8x32 : [u16; 256] = [
  0,   32,  1,   64,  33,  2,   96,  65,  34,  3,   128, 97,  66,  35,  4,
  160, 129, 98,  67,  36,  5,   192, 161, 130, 99,  68,  37,  6,   224, 193,
  162, 131, 100, 69,  38,  7,   225, 194, 163, 132, 101, 70,  39,  8,   226,
  195, 164, 133, 102, 71,  40,  9,   227, 196, 165, 134, 103, 72,  41,  10,
  228, 197, 166, 135, 104, 73,  42,  11,  229, 198, 167, 136, 105, 74,  43,
  12,  230, 199, 168, 137, 106, 75,  44,  13,  231, 200, 169, 138, 107, 76,
  45,  14,  232, 201, 170, 139, 108, 77,  46,  15,  233, 202, 171, 140, 109,
  78,  47,  16,  234, 203, 172, 141, 110, 79,  48,  17,  235, 204, 173, 142,
  111, 80,  49,  18,  236, 205, 174, 143, 112, 81,  50,  19,  237, 206, 175,
  144, 113, 82,  51,  20,  238, 207, 176, 145, 114, 83,  52,  21,  239, 208,
  177, 146, 115, 84,  53,  22,  240, 209, 178, 147, 116, 85,  54,  23,  241,
  210, 179, 148, 117, 86,  55,  24,  242, 211, 180, 149, 118, 87,  56,  25,
  243, 212, 181, 150, 119, 88,  57,  26,  244, 213, 182, 151, 120, 89,  58,
  27,  245, 214, 183, 152, 121, 90,  59,  28,  246, 215, 184, 153, 122, 91,
  60,  29,  247, 216, 185, 154, 123, 92,  61,  30,  248, 217, 186, 155, 124,
  93,  62,  31,  249, 218, 187, 156, 125, 94,  63,  250, 219, 188, 157, 126,
  95,  251, 220, 189, 158, 127, 252, 221, 190, 159, 253, 222, 191, 254, 223,
  255,
];

#[rustfmt::skip]
static mcol_scan_32x8 : [u16; 256] = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
];

#[rustfmt::skip]
static mcol_scan_8x32 : [u16; 256] = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
];

#[rustfmt::skip]
static mrow_scan_32x8 : [u16; 256] = [
  0,   8,   16,  24,  32,  40,  48,  56,  64,  72,  80,  88,  96,  104, 112,
  120, 128, 136, 144, 152, 160, 168, 176, 184, 192, 200, 208, 216, 224, 232,
  240, 248, 1,   9,   17,  25,  33,  41,  49,  57,  65,  73,  81,  89,  97,
  105, 113, 121, 129, 137, 145, 153, 161, 169, 177, 185, 193, 201, 209, 217,
  225, 233, 241, 249, 2,   10,  18,  26,  34,  42,  50,  58,  66,  74,  82,
  90,  98,  106, 114, 122, 130, 138, 146, 154, 162, 170, 178, 186, 194, 202,
  210, 218, 226, 234, 242, 250, 3,   11,  19,  27,  35,  43,  51,  59,  67,
  75,  83,  91,  99,  107, 115, 123, 131, 139, 147, 155, 163, 171, 179, 187,
  195, 203, 211, 219, 227, 235, 243, 251, 4,   12,  20,  28,  36,  44,  52,
  60,  68,  76,  84,  92,  100, 108, 116, 124, 132, 140, 148, 156, 164, 172,
  180, 188, 196, 204, 212, 220, 228, 236, 244, 252, 5,   13,  21,  29,  37,
  45,  53,  61,  69,  77,  85,  93,  101, 109, 117, 125, 133, 141, 149, 157,
  165, 173, 181, 189, 197, 205, 213, 221, 229, 237, 245, 253, 6,   14,  22,
  30,  38,  46,  54,  62,  70,  78,  86,  94,  102, 110, 118, 126, 134, 142,
  150, 158, 166, 174, 182, 190, 198, 206, 214, 222, 230, 238, 246, 254, 7,
  15,  23,  31,  39,  47,  55,  63,  71,  79,  87,  95,  103, 111, 119, 127,
  135, 143, 151, 159, 167, 175, 183, 191, 199, 207, 215, 223, 231, 239, 247,
  255,
];

#[rustfmt::skip]
static mrow_scan_8x32 : [u16; 256] = [
  0,  32, 64, 96,  128, 160, 192, 224, 1,  33, 65, 97,  129, 161, 193, 225,
  2,  34, 66, 98,  130, 162, 194, 226, 3,  35, 67, 99,  131, 163, 195, 227,
  4,  36, 68, 100, 132, 164, 196, 228, 5,  37, 69, 101, 133, 165, 197, 229,
  6,  38, 70, 102, 134, 166, 198, 230, 7,  39, 71, 103, 135, 167, 199, 231,
  8,  40, 72, 104, 136, 168, 200, 232, 9,  41, 73, 105, 137, 169, 201, 233,
  10, 42, 74, 106, 138, 170, 202, 234, 11, 43, 75, 107, 139, 171, 203, 235,
  12, 44, 76, 108, 140, 172, 204, 236, 13, 45, 77, 109, 141, 173, 205, 237,
  14, 46, 78, 110, 142, 174, 206, 238, 15, 47, 79, 111, 143, 175, 207, 239,
  16, 48, 80, 112, 144, 176, 208, 240, 17, 49, 81, 113, 145, 177, 209, 241,
  18, 50, 82, 114, 146, 178, 210, 242, 19, 51, 83, 115, 147, 179, 211, 243,
  20, 52, 84, 116, 148, 180, 212, 244, 21, 53, 85, 117, 149, 181, 213, 245,
  22, 54, 86, 118, 150, 182, 214, 246, 23, 55, 87, 119, 151, 183, 215, 247,
  24, 56, 88, 120, 152, 184, 216, 248, 25, 57, 89, 121, 153, 185, 217, 249,
  26, 58, 90, 122, 154, 186, 218, 250, 27, 59, 91, 123, 155, 187, 219, 251,
  28, 60, 92, 124, 156, 188, 220, 252, 29, 61, 93, 125, 157, 189, 221, 253,
  30, 62, 94, 126, 158, 190, 222, 254, 31, 63, 95, 127, 159, 191, 223, 255,
];

#[rustfmt::skip]
static default_scan_8x8 : [u16; 64] = [
  0,  8,  1,  2,  9,  16, 24, 17, 10, 3,  4,  11, 18, 25, 32, 40,
  33, 26, 19, 12, 5,  6,  13, 20, 27, 34, 41, 48, 56, 49, 42, 35,
  28, 21, 14, 7,  15, 22, 29, 36, 43, 50, 57, 58, 51, 44, 37, 30,
  23, 31, 38, 45, 52, 59, 60, 53, 46, 39, 47, 54, 61, 62, 55, 63,
];

#[rustfmt::skip]
static mrow_scan_8x8 : [u16; 64] = [
  0, 8,  16, 24, 32, 40, 48, 56, 1, 9,  17, 25, 33, 41, 49, 57,
  2, 10, 18, 26, 34, 42, 50, 58, 3, 11, 19, 27, 35, 43, 51, 59,
  4, 12, 20, 28, 36, 44, 52, 60, 5, 13, 21, 29, 37, 45, 53, 61,
  6, 14, 22, 30, 38, 46, 54, 62, 7, 15, 23, 31, 39, 47, 55, 63,
];

#[rustfmt::skip]
static mcol_scan_8x8 : [u16; 64] = [
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
];

#[rustfmt::skip]
static default_scan_16x8 : [u16; 128] = [
  0,   1,   8,   2,   9,   16,  3,   10,  17,  24,  4,   11,  18,  25,  32,
  5,   12,  19,  26,  33,  40,  6,   13,  20,  27,  34,  41,  48,  7,   14,
  21,  28,  35,  42,  49,  56,  15,  22,  29,  36,  43,  50,  57,  64,  23,
  30,  37,  44,  51,  58,  65,  72,  31,  38,  45,  52,  59,  66,  73,  80,
  39,  46,  53,  60,  67,  74,  81,  88,  47,  54,  61,  68,  75,  82,  89,
  96,  55,  62,  69,  76,  83,  90,  97,  104, 63,  70,  77,  84,  91,  98,
  105, 112, 71,  78,  85,  92,  99,  106, 113, 120, 79,  86,  93,  100, 107,
  114, 121, 87,  94,  101, 108, 115, 122, 95,  102, 109, 116, 123, 103, 110,
  117, 124, 111, 118, 125, 119, 126, 127,
];

#[rustfmt::skip]
static default_scan_8x16 : [u16; 128] = [
  0,  16,  1,   32, 17,  2,   48,  33,  18, 3,  64,  49,  34,  19,  4,   80,
  65, 50,  35,  20, 5,   96,  81,  66,  51, 36, 21,  6,   112, 97,  82,  67,
  52, 37,  22,  7,  113, 98,  83,  68,  53, 38, 23,  8,   114, 99,  84,  69,
  54, 39,  24,  9,  115, 100, 85,  70,  55, 40, 25,  10,  116, 101, 86,  71,
  56, 41,  26,  11, 117, 102, 87,  72,  57, 42, 27,  12,  118, 103, 88,  73,
  58, 43,  28,  13, 119, 104, 89,  74,  59, 44, 29,  14,  120, 105, 90,  75,
  60, 45,  30,  15, 121, 106, 91,  76,  61, 46, 31,  122, 107, 92,  77,  62,
  47, 123, 108, 93, 78,  63,  124, 109, 94, 79, 125, 110, 95,  126, 111, 127,
];

#[rustfmt::skip]
static mrow_scan_16x8 : [u16; 128] = [
  0, 8,  16, 24, 32, 40, 48, 56, 64, 72, 80, 88, 96,  104, 112, 120,
  1, 9,  17, 25, 33, 41, 49, 57, 65, 73, 81, 89, 97,  105, 113, 121,
  2, 10, 18, 26, 34, 42, 50, 58, 66, 74, 82, 90, 98,  106, 114, 122,
  3, 11, 19, 27, 35, 43, 51, 59, 67, 75, 83, 91, 99,  107, 115, 123,
  4, 12, 20, 28, 36, 44, 52, 60, 68, 76, 84, 92, 100, 108, 116, 124,
  5, 13, 21, 29, 37, 45, 53, 61, 69, 77, 85, 93, 101, 109, 117, 125,
  6, 14, 22, 30, 38, 46, 54, 62, 70, 78, 86, 94, 102, 110, 118, 126,
  7, 15, 23, 31, 39, 47, 55, 63, 71, 79, 87, 95, 103, 111, 119, 127,
];

#[rustfmt::skip]
static mrow_scan_8x16 : [u16; 128] = [
  0,  16, 32, 48, 64, 80, 96,  112, 1,  17, 33, 49, 65, 81, 97,  113,
  2,  18, 34, 50, 66, 82, 98,  114, 3,  19, 35, 51, 67, 83, 99,  115,
  4,  20, 36, 52, 68, 84, 100, 116, 5,  21, 37, 53, 69, 85, 101, 117,
  6,  22, 38, 54, 70, 86, 102, 118, 7,  23, 39, 55, 71, 87, 103, 119,
  8,  24, 40, 56, 72, 88, 104, 120, 9,  25, 41, 57, 73, 89, 105, 121,
  10, 26, 42, 58, 74, 90, 106, 122, 11, 27, 43, 59, 75, 91, 107, 123,
  12, 28, 44, 60, 76, 92, 108, 124, 13, 29, 45, 61, 77, 93, 109, 125,
  14, 30, 46, 62, 78, 94, 110, 126, 15, 31, 47, 63, 79, 95, 111, 127,
];

#[rustfmt::skip]
static mcol_scan_16x8 : [u16; 128] = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
];

#[rustfmt::skip]
static mcol_scan_8x16 : [u16; 128] = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
];

#[rustfmt::skip]
static default_scan_32x16 : [u16; 512] = [
  0,   1,   16,  2,   17,  32,  3,   18,  33,  48,  4,   19,  34,  49,  64,
  5,   20,  35,  50,  65,  80,  6,   21,  36,  51,  66,  81,  96,  7,   22,
  37,  52,  67,  82,  97,  112, 8,   23,  38,  53,  68,  83,  98,  113, 128,
  9,   24,  39,  54,  69,  84,  99,  114, 129, 144, 10,  25,  40,  55,  70,
  85,  100, 115, 130, 145, 160, 11,  26,  41,  56,  71,  86,  101, 116, 131,
  146, 161, 176, 12,  27,  42,  57,  72,  87,  102, 117, 132, 147, 162, 177,
  192, 13,  28,  43,  58,  73,  88,  103, 118, 133, 148, 163, 178, 193, 208,
  14,  29,  44,  59,  74,  89,  104, 119, 134, 149, 164, 179, 194, 209, 224,
  15,  30,  45,  60,  75,  90,  105, 120, 135, 150, 165, 180, 195, 210, 225,
  240, 31,  46,  61,  76,  91,  106, 121, 136, 151, 166, 181, 196, 211, 226,
  241, 256, 47,  62,  77,  92,  107, 122, 137, 152, 167, 182, 197, 212, 227,
  242, 257, 272, 63,  78,  93,  108, 123, 138, 153, 168, 183, 198, 213, 228,
  243, 258, 273, 288, 79,  94,  109, 124, 139, 154, 169, 184, 199, 214, 229,
  244, 259, 274, 289, 304, 95,  110, 125, 140, 155, 170, 185, 200, 215, 230,
  245, 260, 275, 290, 305, 320, 111, 126, 141, 156, 171, 186, 201, 216, 231,
  246, 261, 276, 291, 306, 321, 336, 127, 142, 157, 172, 187, 202, 217, 232,
  247, 262, 277, 292, 307, 322, 337, 352, 143, 158, 173, 188, 203, 218, 233,
  248, 263, 278, 293, 308, 323, 338, 353, 368, 159, 174, 189, 204, 219, 234,
  249, 264, 279, 294, 309, 324, 339, 354, 369, 384, 175, 190, 205, 220, 235,
  250, 265, 280, 295, 310, 325, 340, 355, 370, 385, 400, 191, 206, 221, 236,
  251, 266, 281, 296, 311, 326, 341, 356, 371, 386, 401, 416, 207, 222, 237,
  252, 267, 282, 297, 312, 327, 342, 357, 372, 387, 402, 417, 432, 223, 238,
  253, 268, 283, 298, 313, 328, 343, 358, 373, 388, 403, 418, 433, 448, 239,
  254, 269, 284, 299, 314, 329, 344, 359, 374, 389, 404, 419, 434, 449, 464,
  255, 270, 285, 300, 315, 330, 345, 360, 375, 390, 405, 420, 435, 450, 465,
  480, 271, 286, 301, 316, 331, 346, 361, 376, 391, 406, 421, 436, 451, 466,
  481, 496, 287, 302, 317, 332, 347, 362, 377, 392, 407, 422, 437, 452, 467,
  482, 497, 303, 318, 333, 348, 363, 378, 393, 408, 423, 438, 453, 468, 483,
  498, 319, 334, 349, 364, 379, 394, 409, 424, 439, 454, 469, 484, 499, 335,
  350, 365, 380, 395, 410, 425, 440, 455, 470, 485, 500, 351, 366, 381, 396,
  411, 426, 441, 456, 471, 486, 501, 367, 382, 397, 412, 427, 442, 457, 472,
  487, 502, 383, 398, 413, 428, 443, 458, 473, 488, 503, 399, 414, 429, 444,
  459, 474, 489, 504, 415, 430, 445, 460, 475, 490, 505, 431, 446, 461, 476,
  491, 506, 447, 462, 477, 492, 507, 463, 478, 493, 508, 479, 494, 509, 495,
  510, 511,
];

#[rustfmt::skip]
static default_scan_16x32 : [u16; 512] = [
  0,   32,  1,   64,  33,  2,   96,  65,  34,  3,   128, 97,  66,  35,  4,
  160, 129, 98,  67,  36,  5,   192, 161, 130, 99,  68,  37,  6,   224, 193,
  162, 131, 100, 69,  38,  7,   256, 225, 194, 163, 132, 101, 70,  39,  8,
  288, 257, 226, 195, 164, 133, 102, 71,  40,  9,   320, 289, 258, 227, 196,
  165, 134, 103, 72,  41,  10,  352, 321, 290, 259, 228, 197, 166, 135, 104,
  73,  42,  11,  384, 353, 322, 291, 260, 229, 198, 167, 136, 105, 74,  43,
  12,  416, 385, 354, 323, 292, 261, 230, 199, 168, 137, 106, 75,  44,  13,
  448, 417, 386, 355, 324, 293, 262, 231, 200, 169, 138, 107, 76,  45,  14,
  480, 449, 418, 387, 356, 325, 294, 263, 232, 201, 170, 139, 108, 77,  46,
  15,  481, 450, 419, 388, 357, 326, 295, 264, 233, 202, 171, 140, 109, 78,
  47,  16,  482, 451, 420, 389, 358, 327, 296, 265, 234, 203, 172, 141, 110,
  79,  48,  17,  483, 452, 421, 390, 359, 328, 297, 266, 235, 204, 173, 142,
  111, 80,  49,  18,  484, 453, 422, 391, 360, 329, 298, 267, 236, 205, 174,
  143, 112, 81,  50,  19,  485, 454, 423, 392, 361, 330, 299, 268, 237, 206,
  175, 144, 113, 82,  51,  20,  486, 455, 424, 393, 362, 331, 300, 269, 238,
  207, 176, 145, 114, 83,  52,  21,  487, 456, 425, 394, 363, 332, 301, 270,
  239, 208, 177, 146, 115, 84,  53,  22,  488, 457, 426, 395, 364, 333, 302,
  271, 240, 209, 178, 147, 116, 85,  54,  23,  489, 458, 427, 396, 365, 334,
  303, 272, 241, 210, 179, 148, 117, 86,  55,  24,  490, 459, 428, 397, 366,
  335, 304, 273, 242, 211, 180, 149, 118, 87,  56,  25,  491, 460, 429, 398,
  367, 336, 305, 274, 243, 212, 181, 150, 119, 88,  57,  26,  492, 461, 430,
  399, 368, 337, 306, 275, 244, 213, 182, 151, 120, 89,  58,  27,  493, 462,
  431, 400, 369, 338, 307, 276, 245, 214, 183, 152, 121, 90,  59,  28,  494,
  463, 432, 401, 370, 339, 308, 277, 246, 215, 184, 153, 122, 91,  60,  29,
  495, 464, 433, 402, 371, 340, 309, 278, 247, 216, 185, 154, 123, 92,  61,
  30,  496, 465, 434, 403, 372, 341, 310, 279, 248, 217, 186, 155, 124, 93,
  62,  31,  497, 466, 435, 404, 373, 342, 311, 280, 249, 218, 187, 156, 125,
  94,  63,  498, 467, 436, 405, 374, 343, 312, 281, 250, 219, 188, 157, 126,
  95,  499, 468, 437, 406, 375, 344, 313, 282, 251, 220, 189, 158, 127, 500,
  469, 438, 407, 376, 345, 314, 283, 252, 221, 190, 159, 501, 470, 439, 408,
  377, 346, 315, 284, 253, 222, 191, 502, 471, 440, 409, 378, 347, 316, 285,
  254, 223, 503, 472, 441, 410, 379, 348, 317, 286, 255, 504, 473, 442, 411,
  380, 349, 318, 287, 505, 474, 443, 412, 381, 350, 319, 506, 475, 444, 413,
  382, 351, 507, 476, 445, 414, 383, 508, 477, 446, 415, 509, 478, 447, 510,
  479, 511,
];

#[rustfmt::skip]
static mrow_scan_32x16 : [u16; 512] = [
  0,   16,  32,  48,  64,  80,  96,  112, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 272, 288, 304, 320, 336, 352, 368, 384, 400, 416, 432, 448, 464,
  480, 496, 1,   17,  33,  49,  65,  81,  97,  113, 129, 145, 161, 177, 193,
  209, 225, 241, 257, 273, 289, 305, 321, 337, 353, 369, 385, 401, 417, 433,
  449, 465, 481, 497, 2,   18,  34,  50,  66,  82,  98,  114, 130, 146, 162,
  178, 194, 210, 226, 242, 258, 274, 290, 306, 322, 338, 354, 370, 386, 402,
  418, 434, 450, 466, 482, 498, 3,   19,  35,  51,  67,  83,  99,  115, 131,
  147, 163, 179, 195, 211, 227, 243, 259, 275, 291, 307, 323, 339, 355, 371,
  387, 403, 419, 435, 451, 467, 483, 499, 4,   20,  36,  52,  68,  84,  100,
  116, 132, 148, 164, 180, 196, 212, 228, 244, 260, 276, 292, 308, 324, 340,
  356, 372, 388, 404, 420, 436, 452, 468, 484, 500, 5,   21,  37,  53,  69,
  85,  101, 117, 133, 149, 165, 181, 197, 213, 229, 245, 261, 277, 293, 309,
  325, 341, 357, 373, 389, 405, 421, 437, 453, 469, 485, 501, 6,   22,  38,
  54,  70,  86,  102, 118, 134, 150, 166, 182, 198, 214, 230, 246, 262, 278,
  294, 310, 326, 342, 358, 374, 390, 406, 422, 438, 454, 470, 486, 502, 7,
  23,  39,  55,  71,  87,  103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  263, 279, 295, 311, 327, 343, 359, 375, 391, 407, 423, 439, 455, 471, 487,
  503, 8,   24,  40,  56,  72,  88,  104, 120, 136, 152, 168, 184, 200, 216,
  232, 248, 264, 280, 296, 312, 328, 344, 360, 376, 392, 408, 424, 440, 456,
  472, 488, 504, 9,   25,  41,  57,  73,  89,  105, 121, 137, 153, 169, 185,
  201, 217, 233, 249, 265, 281, 297, 313, 329, 345, 361, 377, 393, 409, 425,
  441, 457, 473, 489, 505, 10,  26,  42,  58,  74,  90,  106, 122, 138, 154,
  170, 186, 202, 218, 234, 250, 266, 282, 298, 314, 330, 346, 362, 378, 394,
  410, 426, 442, 458, 474, 490, 506, 11,  27,  43,  59,  75,  91,  107, 123,
  139, 155, 171, 187, 203, 219, 235, 251, 267, 283, 299, 315, 331, 347, 363,
  379, 395, 411, 427, 443, 459, 475, 491, 507, 12,  28,  44,  60,  76,  92,
  108, 124, 140, 156, 172, 188, 204, 220, 236, 252, 268, 284, 300, 316, 332,
  348, 364, 380, 396, 412, 428, 444, 460, 476, 492, 508, 13,  29,  45,  61,
  77,  93,  109, 125, 141, 157, 173, 189, 205, 221, 237, 253, 269, 285, 301,
  317, 333, 349, 365, 381, 397, 413, 429, 445, 461, 477, 493, 509, 14,  30,
  46,  62,  78,  94,  110, 126, 142, 158, 174, 190, 206, 222, 238, 254, 270,
  286, 302, 318, 334, 350, 366, 382, 398, 414, 430, 446, 462, 478, 494, 510,
  15,  31,  47,  63,  79,  95,  111, 127, 143, 159, 175, 191, 207, 223, 239,
  255, 271, 287, 303, 319, 335, 351, 367, 383, 399, 415, 431, 447, 463, 479,
  495, 511,
];

#[rustfmt::skip]
static mrow_scan_16x32 : [u16; 512] = [
  0,  32, 64, 96,  128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 480,
  1,  33, 65, 97,  129, 161, 193, 225, 257, 289, 321, 353, 385, 417, 449, 481,
  2,  34, 66, 98,  130, 162, 194, 226, 258, 290, 322, 354, 386, 418, 450, 482,
  3,  35, 67, 99,  131, 163, 195, 227, 259, 291, 323, 355, 387, 419, 451, 483,
  4,  36, 68, 100, 132, 164, 196, 228, 260, 292, 324, 356, 388, 420, 452, 484,
  5,  37, 69, 101, 133, 165, 197, 229, 261, 293, 325, 357, 389, 421, 453, 485,
  6,  38, 70, 102, 134, 166, 198, 230, 262, 294, 326, 358, 390, 422, 454, 486,
  7,  39, 71, 103, 135, 167, 199, 231, 263, 295, 327, 359, 391, 423, 455, 487,
  8,  40, 72, 104, 136, 168, 200, 232, 264, 296, 328, 360, 392, 424, 456, 488,
  9,  41, 73, 105, 137, 169, 201, 233, 265, 297, 329, 361, 393, 425, 457, 489,
  10, 42, 74, 106, 138, 170, 202, 234, 266, 298, 330, 362, 394, 426, 458, 490,
  11, 43, 75, 107, 139, 171, 203, 235, 267, 299, 331, 363, 395, 427, 459, 491,
  12, 44, 76, 108, 140, 172, 204, 236, 268, 300, 332, 364, 396, 428, 460, 492,
  13, 45, 77, 109, 141, 173, 205, 237, 269, 301, 333, 365, 397, 429, 461, 493,
  14, 46, 78, 110, 142, 174, 206, 238, 270, 302, 334, 366, 398, 430, 462, 494,
  15, 47, 79, 111, 143, 175, 207, 239, 271, 303, 335, 367, 399, 431, 463, 495,
  16, 48, 80, 112, 144, 176, 208, 240, 272, 304, 336, 368, 400, 432, 464, 496,
  17, 49, 81, 113, 145, 177, 209, 241, 273, 305, 337, 369, 401, 433, 465, 497,
  18, 50, 82, 114, 146, 178, 210, 242, 274, 306, 338, 370, 402, 434, 466, 498,
  19, 51, 83, 115, 147, 179, 211, 243, 275, 307, 339, 371, 403, 435, 467, 499,
  20, 52, 84, 116, 148, 180, 212, 244, 276, 308, 340, 372, 404, 436, 468, 500,
  21, 53, 85, 117, 149, 181, 213, 245, 277, 309, 341, 373, 405, 437, 469, 501,
  22, 54, 86, 118, 150, 182, 214, 246, 278, 310, 342, 374, 406, 438, 470, 502,
  23, 55, 87, 119, 151, 183, 215, 247, 279, 311, 343, 375, 407, 439, 471, 503,
  24, 56, 88, 120, 152, 184, 216, 248, 280, 312, 344, 376, 408, 440, 472, 504,
  25, 57, 89, 121, 153, 185, 217, 249, 281, 313, 345, 377, 409, 441, 473, 505,
  26, 58, 90, 122, 154, 186, 218, 250, 282, 314, 346, 378, 410, 442, 474, 506,
  27, 59, 91, 123, 155, 187, 219, 251, 283, 315, 347, 379, 411, 443, 475, 507,
  28, 60, 92, 124, 156, 188, 220, 252, 284, 316, 348, 380, 412, 444, 476, 508,
  29, 61, 93, 125, 157, 189, 221, 253, 285, 317, 349, 381, 413, 445, 477, 509,
  30, 62, 94, 126, 158, 190, 222, 254, 286, 318, 350, 382, 414, 446, 478, 510,
  31, 63, 95, 127, 159, 191, 223, 255, 287, 319, 351, 383, 415, 447, 479, 511,
];

#[rustfmt::skip]
static mcol_scan_32x16 : [u16; 512] = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
];

#[rustfmt::skip]
static mcol_scan_16x32 : [u16; 512] = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
  270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
  300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
  330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
  360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
  375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389,
  390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
  405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
  420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434,
  435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464,
  465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479,
  480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
  495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509,
  510, 511,
];

#[rustfmt::skip]
static default_scan_16x16 : [u16; 256] = [
  0,   16,  1,   2,   17,  32,  48,  33,  18,  3,   4,   19,  34,  49,  64,
  80,  65,  50,  35,  20,  5,   6,   21,  36,  51,  66,  81,  96,  112, 97,
  82,  67,  52,  37,  22,  7,   8,   23,  38,  53,  68,  83,  98,  113, 128,
  144, 129, 114, 99,  84,  69,  54,  39,  24,  9,   10,  25,  40,  55,  70,
  85,  100, 115, 130, 145, 160, 176, 161, 146, 131, 116, 101, 86,  71,  56,
  41,  26,  11,  12,  27,  42,  57,  72,  87,  102, 117, 132, 147, 162, 177,
  192, 208, 193, 178, 163, 148, 133, 118, 103, 88,  73,  58,  43,  28,  13,
  14,  29,  44,  59,  74,  89,  104, 119, 134, 149, 164, 179, 194, 209, 224,
  240, 225, 210, 195, 180, 165, 150, 135, 120, 105, 90,  75,  60,  45,  30,
  15,  31,  46,  61,  76,  91,  106, 121, 136, 151, 166, 181, 196, 211, 226,
  241, 242, 227, 212, 197, 182, 167, 152, 137, 122, 107, 92,  77,  62,  47,
  63,  78,  93,  108, 123, 138, 153, 168, 183, 198, 213, 228, 243, 244, 229,
  214, 199, 184, 169, 154, 139, 124, 109, 94,  79,  95,  110, 125, 140, 155,
  170, 185, 200, 215, 230, 245, 246, 231, 216, 201, 186, 171, 156, 141, 126,
  111, 127, 142, 157, 172, 187, 202, 217, 232, 247, 248, 233, 218, 203, 188,
  173, 158, 143, 159, 174, 189, 204, 219, 234, 249, 250, 235, 220, 205, 190,
  175, 191, 206, 221, 236, 251, 252, 237, 222, 207, 223, 238, 253, 254, 239,
  255,
];

#[rustfmt::skip]
static mrow_scan_16x16 : [u16; 256] = [
  0,  16, 32, 48, 64, 80, 96,  112, 128, 144, 160, 176, 192, 208, 224, 240,
  1,  17, 33, 49, 65, 81, 97,  113, 129, 145, 161, 177, 193, 209, 225, 241,
  2,  18, 34, 50, 66, 82, 98,  114, 130, 146, 162, 178, 194, 210, 226, 242,
  3,  19, 35, 51, 67, 83, 99,  115, 131, 147, 163, 179, 195, 211, 227, 243,
  4,  20, 36, 52, 68, 84, 100, 116, 132, 148, 164, 180, 196, 212, 228, 244,
  5,  21, 37, 53, 69, 85, 101, 117, 133, 149, 165, 181, 197, 213, 229, 245,
  6,  22, 38, 54, 70, 86, 102, 118, 134, 150, 166, 182, 198, 214, 230, 246,
  7,  23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247,
  8,  24, 40, 56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216, 232, 248,
  9,  25, 41, 57, 73, 89, 105, 121, 137, 153, 169, 185, 201, 217, 233, 249,
  10, 26, 42, 58, 74, 90, 106, 122, 138, 154, 170, 186, 202, 218, 234, 250,
  11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251,
  12, 28, 44, 60, 76, 92, 108, 124, 140, 156, 172, 188, 204, 220, 236, 252,
  13, 29, 45, 61, 77, 93, 109, 125, 141, 157, 173, 189, 205, 221, 237, 253,
  14, 30, 46, 62, 78, 94, 110, 126, 142, 158, 174, 190, 206, 222, 238, 254,
  15, 31, 47, 63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255,
];

#[rustfmt::skip]
static mcol_scan_16x16 : [u16; 256] = [
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,
  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
  90,  91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
  105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
  135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
  150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
  165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
  180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
  195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
  210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
  225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
  255,
];

#[rustfmt::skip]
static mrow_scan_32x32 : [u16; 1024] = [
  0,   32,   64,  96,   128, 160,  192, 224,  256, 288,  320, 352,  384, 416,
  448, 480,  512, 544,  576, 608,  640, 672,  704, 736,  768, 800,  832, 864,
  896, 928,  960, 992,  1,   33,   65,  97,   129, 161,  193, 225,  257, 289,
  321, 353,  385, 417,  449, 481,  513, 545,  577, 609,  641, 673,  705, 737,
  769, 801,  833, 865,  897, 929,  961, 993,  2,   34,   66,  98,   130, 162,
  194, 226,  258, 290,  322, 354,  386, 418,  450, 482,  514, 546,  578, 610,
  642, 674,  706, 738,  770, 802,  834, 866,  898, 930,  962, 994,  3,   35,
  67,  99,   131, 163,  195, 227,  259, 291,  323, 355,  387, 419,  451, 483,
  515, 547,  579, 611,  643, 675,  707, 739,  771, 803,  835, 867,  899, 931,
  963, 995,  4,   36,   68,  100,  132, 164,  196, 228,  260, 292,  324, 356,
  388, 420,  452, 484,  516, 548,  580, 612,  644, 676,  708, 740,  772, 804,
  836, 868,  900, 932,  964, 996,  5,   37,   69,  101,  133, 165,  197, 229,
  261, 293,  325, 357,  389, 421,  453, 485,  517, 549,  581, 613,  645, 677,
  709, 741,  773, 805,  837, 869,  901, 933,  965, 997,  6,   38,   70,  102,
  134, 166,  198, 230,  262, 294,  326, 358,  390, 422,  454, 486,  518, 550,
  582, 614,  646, 678,  710, 742,  774, 806,  838, 870,  902, 934,  966, 998,
  7,   39,   71,  103,  135, 167,  199, 231,  263, 295,  327, 359,  391, 423,
  455, 487,  519, 551,  583, 615,  647, 679,  711, 743,  775, 807,  839, 871,
  903, 935,  967, 999,  8,   40,   72,  104,  136, 168,  200, 232,  264, 296,
  328, 360,  392, 424,  456, 488,  520, 552,  584, 616,  648, 680,  712, 744,
  776, 808,  840, 872,  904, 936,  968, 1000, 9,   41,   73,  105,  137, 169,
  201, 233,  265, 297,  329, 361,  393, 425,  457, 489,  521, 553,  585, 617,
  649, 681,  713, 745,  777, 809,  841, 873,  905, 937,  969, 1001, 10,  42,
  74,  106,  138, 170,  202, 234,  266, 298,  330, 362,  394, 426,  458, 490,
  522, 554,  586, 618,  650, 682,  714, 746,  778, 810,  842, 874,  906, 938,
  970, 1002, 11,  43,   75,  107,  139, 171,  203, 235,  267, 299,  331, 363,
  395, 427,  459, 491,  523, 555,  587, 619,  651, 683,  715, 747,  779, 811,
  843, 875,  907, 939,  971, 1003, 12,  44,   76,  108,  140, 172,  204, 236,
  268, 300,  332, 364,  396, 428,  460, 492,  524, 556,  588, 620,  652, 684,
  716, 748,  780, 812,  844, 876,  908, 940,  972, 1004, 13,  45,   77,  109,
  141, 173,  205, 237,  269, 301,  333, 365,  397, 429,  461, 493,  525, 557,
  589, 621,  653, 685,  717, 749,  781, 813,  845, 877,  909, 941,  973, 1005,
  14,  46,   78,  110,  142, 174,  206, 238,  270, 302,  334, 366,  398, 430,
  462, 494,  526, 558,  590, 622,  654, 686,  718, 750,  782, 814,  846, 878,
  910, 942,  974, 1006, 15,  47,   79,  111,  143, 175,  207, 239,  271, 303,
  335, 367,  399, 431,  463, 495,  527, 559,  591, 623,  655, 687,  719, 751,
  783, 815,  847, 879,  911, 943,  975, 1007, 16,  48,   80,  112,  144, 176,
  208, 240,  272, 304,  336, 368,  400, 432,  464, 496,  528, 560,  592, 624,
  656, 688,  720, 752,  784, 816,  848, 880,  912, 944,  976, 1008, 17,  49,
  81,  113,  145, 177,  209, 241,  273, 305,  337, 369,  401, 433,  465, 497,
  529, 561,  593, 625,  657, 689,  721, 753,  785, 817,  849, 881,  913, 945,
  977, 1009, 18,  50,   82,  114,  146, 178,  210, 242,  274, 306,  338, 370,
  402, 434,  466, 498,  530, 562,  594, 626,  658, 690,  722, 754,  786, 818,
  850, 882,  914, 946,  978, 1010, 19,  51,   83,  115,  147, 179,  211, 243,
  275, 307,  339, 371,  403, 435,  467, 499,  531, 563,  595, 627,  659, 691,
  723, 755,  787, 819,  851, 883,  915, 947,  979, 1011, 20,  52,   84,  116,
  148, 180,  212, 244,  276, 308,  340, 372,  404, 436,  468, 500,  532, 564,
  596, 628,  660, 692,  724, 756,  788, 820,  852, 884,  916, 948,  980, 1012,
  21,  53,   85,  117,  149, 181,  213, 245,  277, 309,  341, 373,  405, 437,
  469, 501,  533, 565,  597, 629,  661, 693,  725, 757,  789, 821,  853, 885,
  917, 949,  981, 1013, 22,  54,   86,  118,  150, 182,  214, 246,  278, 310,
  342, 374,  406, 438,  470, 502,  534, 566,  598, 630,  662, 694,  726, 758,
  790, 822,  854, 886,  918, 950,  982, 1014, 23,  55,   87,  119,  151, 183,
  215, 247,  279, 311,  343, 375,  407, 439,  471, 503,  535, 567,  599, 631,
  663, 695,  727, 759,  791, 823,  855, 887,  919, 951,  983, 1015, 24,  56,
  88,  120,  152, 184,  216, 248,  280, 312,  344, 376,  408, 440,  472, 504,
  536, 568,  600, 632,  664, 696,  728, 760,  792, 824,  856, 888,  920, 952,
  984, 1016, 25,  57,   89,  121,  153, 185,  217, 249,  281, 313,  345, 377,
  409, 441,  473, 505,  537, 569,  601, 633,  665, 697,  729, 761,  793, 825,
  857, 889,  921, 953,  985, 1017, 26,  58,   90,  122,  154, 186,  218, 250,
  282, 314,  346, 378,  410, 442,  474, 506,  538, 570,  602, 634,  666, 698,
  730, 762,  794, 826,  858, 890,  922, 954,  986, 1018, 27,  59,   91,  123,
  155, 187,  219, 251,  283, 315,  347, 379,  411, 443,  475, 507,  539, 571,
  603, 635,  667, 699,  731, 763,  795, 827,  859, 891,  923, 955,  987, 1019,
  28,  60,   92,  124,  156, 188,  220, 252,  284, 316,  348, 380,  412, 444,
  476, 508,  540, 572,  604, 636,  668, 700,  732, 764,  796, 828,  860, 892,
  924, 956,  988, 1020, 29,  61,   93,  125,  157, 189,  221, 253,  285, 317,
  349, 381,  413, 445,  477, 509,  541, 573,  605, 637,  669, 701,  733, 765,
  797, 829,  861, 893,  925, 957,  989, 1021, 30,  62,   94,  126,  158, 190,
  222, 254,  286, 318,  350, 382,  414, 446,  478, 510,  542, 574,  606, 638,
  670, 702,  734, 766,  798, 830,  862, 894,  926, 958,  990, 1022, 31,  63,
  95,  127,  159, 191,  223, 255,  287, 319,  351, 383,  415, 447,  479, 511,
  543, 575,  607, 639,  671, 703,  735, 767,  799, 831,  863, 895,  927, 959,
  991, 1023,
];

#[rustfmt::skip]
static mcol_scan_32x32 : [u16; 1024] = [
  0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,
  13,   14,   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,
  26,   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
  39,   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
  52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
  65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
  78,   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
  91,   92,   93,   94,   95,   96,   97,   98,   99,   100,  101,  102,  103,
  104,  105,  106,  107,  108,  109,  110,  111,  112,  113,  114,  115,  116,
  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,
  143,  144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,
  156,  157,  158,  159,  160,  161,  162,  163,  164,  165,  166,  167,  168,
  169,  170,  171,  172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
  182,  183,  184,  185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
  195,  196,  197,  198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
  208,  209,  210,  211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
  234,  235,  236,  237,  238,  239,  240,  241,  242,  243,  244,  245,  246,
  247,  248,  249,  250,  251,  252,  253,  254,  255,  256,  257,  258,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,  309,  310,  311,
  312,  313,  314,  315,  316,  317,  318,  319,  320,  321,  322,  323,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,  336,  337,
  338,  339,  340,  341,  342,  343,  344,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,  360,  361,  362,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,  378,  379,  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,  414,  415,
  416,  417,  418,  419,  420,  421,  422,  423,  424,  425,  426,  427,  428,
  429,  430,  431,  432,  433,  434,  435,  436,  437,  438,  439,  440,  441,
  442,  443,  444,  445,  446,  447,  448,  449,  450,  451,  452,  453,  454,
  455,  456,  457,  458,  459,  460,  461,  462,  463,  464,  465,  466,  467,
  468,  469,  470,  471,  472,  473,  474,  475,  476,  477,  478,  479,  480,
  481,  482,  483,  484,  485,  486,  487,  488,  489,  490,  491,  492,  493,
  494,  495,  496,  497,  498,  499,  500,  501,  502,  503,  504,  505,  506,
  507,  508,  509,  510,  511,  512,  513,  514,  515,  516,  517,  518,  519,
  520,  521,  522,  523,  524,  525,  526,  527,  528,  529,  530,  531,  532,
  533,  534,  535,  536,  537,  538,  539,  540,  541,  542,  543,  544,  545,
  546,  547,  548,  549,  550,  551,  552,  553,  554,  555,  556,  557,  558,
  559,  560,  561,  562,  563,  564,  565,  566,  567,  568,  569,  570,  571,
  572,  573,  574,  575,  576,  577,  578,  579,  580,  581,  582,  583,  584,
  585,  586,  587,  588,  589,  590,  591,  592,  593,  594,  595,  596,  597,
  598,  599,  600,  601,  602,  603,  604,  605,  606,  607,  608,  609,  610,
  611,  612,  613,  614,  615,  616,  617,  618,  619,  620,  621,  622,  623,
  624,  625,  626,  627,  628,  629,  630,  631,  632,  633,  634,  635,  636,
  637,  638,  639,  640,  641,  642,  643,  644,  645,  646,  647,  648,  649,
  650,  651,  652,  653,  654,  655,  656,  657,  658,  659,  660,  661,  662,
  663,  664,  665,  666,  667,  668,  669,  670,  671,  672,  673,  674,  675,
  676,  677,  678,  679,  680,  681,  682,  683,  684,  685,  686,  687,  688,
  689,  690,  691,  692,  693,  694,  695,  696,  697,  698,  699,  700,  701,
  702,  703,  704,  705,  706,  707,  708,  709,  710,  711,  712,  713,  714,
  715,  716,  717,  718,  719,  720,  721,  722,  723,  724,  725,  726,  727,
  728,  729,  730,  731,  732,  733,  734,  735,  736,  737,  738,  739,  740,
  741,  742,  743,  744,  745,  746,  747,  748,  749,  750,  751,  752,  753,
  754,  755,  756,  757,  758,  759,  760,  761,  762,  763,  764,  765,  766,
  767,  768,  769,  770,  771,  772,  773,  774,  775,  776,  777,  778,  779,
  780,  781,  782,  783,  784,  785,  786,  787,  788,  789,  790,  791,  792,
  793,  794,  795,  796,  797,  798,  799,  800,  801,  802,  803,  804,  805,
  806,  807,  808,  809,  810,  811,  812,  813,  814,  815,  816,  817,  818,
  819,  820,  821,  822,  823,  824,  825,  826,  827,  828,  829,  830,  831,
  832,  833,  834,  835,  836,  837,  838,  839,  840,  841,  842,  843,  844,
  845,  846,  847,  848,  849,  850,  851,  852,  853,  854,  855,  856,  857,
  858,  859,  860,  861,  862,  863,  864,  865,  866,  867,  868,  869,  870,
  871,  872,  873,  874,  875,  876,  877,  878,  879,  880,  881,  882,  883,
  884,  885,  886,  887,  888,  889,  890,  891,  892,  893,  894,  895,  896,
  897,  898,  899,  900,  901,  902,  903,  904,  905,  906,  907,  908,  909,
  910,  911,  912,  913,  914,  915,  916,  917,  918,  919,  920,  921,  922,
  923,  924,  925,  926,  927,  928,  929,  930,  931,  932,  933,  934,  935,
  936,  937,  938,  939,  940,  941,  942,  943,  944,  945,  946,  947,  948,
  949,  950,  951,  952,  953,  954,  955,  956,  957,  958,  959,  960,  961,
  962,  963,  964,  965,  966,  967,  968,  969,  970,  971,  972,  973,  974,
  975,  976,  977,  978,  979,  980,  981,  982,  983,  984,  985,  986,  987,
  988,  989,  990,  991,  992,  993,  994,  995,  996,  997,  998,  999,  1000,
  1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013,
  1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023,
];

#[rustfmt::skip]
static default_scan_32x32 : [u16; 1024] = [
  0,    32,   1,    2,    33,   64,  96,   65,   34,   3,    4,    35,  66,
  97,   128,  160,  129,  98,   67,  36,   5,    6,    37,   68,   99,  130,
  161,  192,  224,  193,  162,  131, 100,  69,   38,   7,    8,    39,  70,
  101,  132,  163,  194,  225,  256, 288,  257,  226,  195,  164,  133, 102,
  71,   40,   9,    10,   41,   72,  103,  134,  165,  196,  227,  258, 289,
  320,  352,  321,  290,  259,  228, 197,  166,  135,  104,  73,   42,  11,
  12,   43,   74,   105,  136,  167, 198,  229,  260,  291,  322,  353, 384,
  416,  385,  354,  323,  292,  261, 230,  199,  168,  137,  106,  75,  44,
  13,   14,   45,   76,   107,  138, 169,  200,  231,  262,  293,  324, 355,
  386,  417,  448,  480,  449,  418, 387,  356,  325,  294,  263,  232, 201,
  170,  139,  108,  77,   46,   15,  16,   47,   78,   109,  140,  171, 202,
  233,  264,  295,  326,  357,  388, 419,  450,  481,  512,  544,  513, 482,
  451,  420,  389,  358,  327,  296, 265,  234,  203,  172,  141,  110, 79,
  48,   17,   18,   49,   80,   111, 142,  173,  204,  235,  266,  297, 328,
  359,  390,  421,  452,  483,  514, 545,  576,  608,  577,  546,  515, 484,
  453,  422,  391,  360,  329,  298, 267,  236,  205,  174,  143,  112, 81,
  50,   19,   20,   51,   82,   113, 144,  175,  206,  237,  268,  299, 330,
  361,  392,  423,  454,  485,  516, 547,  578,  609,  640,  672,  641, 610,
  579,  548,  517,  486,  455,  424, 393,  362,  331,  300,  269,  238, 207,
  176,  145,  114,  83,   52,   21,  22,   53,   84,   115,  146,  177, 208,
  239,  270,  301,  332,  363,  394, 425,  456,  487,  518,  549,  580, 611,
  642,  673,  704,  736,  705,  674, 643,  612,  581,  550,  519,  488, 457,
  426,  395,  364,  333,  302,  271, 240,  209,  178,  147,  116,  85,  54,
  23,   24,   55,   86,   117,  148, 179,  210,  241,  272,  303,  334, 365,
  396,  427,  458,  489,  520,  551, 582,  613,  644,  675,  706,  737, 768,
  800,  769,  738,  707,  676,  645, 614,  583,  552,  521,  490,  459, 428,
  397,  366,  335,  304,  273,  242, 211,  180,  149,  118,  87,   56,  25,
  26,   57,   88,   119,  150,  181, 212,  243,  274,  305,  336,  367, 398,
  429,  460,  491,  522,  553,  584, 615,  646,  677,  708,  739,  770, 801,
  832,  864,  833,  802,  771,  740, 709,  678,  647,  616,  585,  554, 523,
  492,  461,  430,  399,  368,  337, 306,  275,  244,  213,  182,  151, 120,
  89,   58,   27,   28,   59,   90,  121,  152,  183,  214,  245,  276, 307,
  338,  369,  400,  431,  462,  493, 524,  555,  586,  617,  648,  679, 710,
  741,  772,  803,  834,  865,  896, 928,  897,  866,  835,  804,  773, 742,
  711,  680,  649,  618,  587,  556, 525,  494,  463,  432,  401,  370, 339,
  308,  277,  246,  215,  184,  153, 122,  91,   60,   29,   30,   61,  92,
  123,  154,  185,  216,  247,  278, 309,  340,  371,  402,  433,  464, 495,
  526,  557,  588,  619,  650,  681, 712,  743,  774,  805,  836,  867, 898,
  929,  960,  992,  961,  930,  899, 868,  837,  806,  775,  744,  713, 682,
  651,  620,  589,  558,  527,  496, 465,  434,  403,  372,  341,  310, 279,
  248,  217,  186,  155,  124,  93,  62,   31,   63,   94,   125,  156, 187,
  218,  249,  280,  311,  342,  373, 404,  435,  466,  497,  528,  559, 590,
  621,  652,  683,  714,  745,  776, 807,  838,  869,  900,  931,  962, 993,
  994,  963,  932,  901,  870,  839, 808,  777,  746,  715,  684,  653, 622,
  591,  560,  529,  498,  467,  436, 405,  374,  343,  312,  281,  250, 219,
  188,  157,  126,  95,   127,  158, 189,  220,  251,  282,  313,  344, 375,
  406,  437,  468,  499,  530,  561, 592,  623,  654,  685,  716,  747, 778,
  809,  840,  871,  902,  933,  964, 995,  996,  965,  934,  903,  872, 841,
  810,  779,  748,  717,  686,  655, 624,  593,  562,  531,  500,  469, 438,
  407,  376,  345,  314,  283,  252, 221,  190,  159,  191,  222,  253, 284,
  315,  346,  377,  408,  439,  470, 501,  532,  563,  594,  625,  656, 687,
  718,  749,  780,  811,  842,  873, 904,  935,  966,  997,  998,  967, 936,
  905,  874,  843,  812,  781,  750, 719,  688,  657,  626,  595,  564, 533,
  502,  471,  440,  409,  378,  347, 316,  285,  254,  223,  255,  286, 317,
  348,  379,  410,  441,  472,  503, 534,  565,  596,  627,  658,  689, 720,
  751,  782,  813,  844,  875,  906, 937,  968,  999,  1000, 969,  938, 907,
  876,  845,  814,  783,  752,  721, 690,  659,  628,  597,  566,  535, 504,
  473,  442,  411,  380,  349,  318, 287,  319,  350,  381,  412,  443, 474,
  505,  536,  567,  598,  629,  660, 691,  722,  753,  784,  815,  846, 877,
  908,  939,  970,  1001, 1002, 971, 940,  909,  878,  847,  816,  785, 754,
  723,  692,  661,  630,  599,  568, 537,  506,  475,  444,  413,  382, 351,
  383,  414,  445,  476,  507,  538, 569,  600,  631,  662,  693,  724, 755,
  786,  817,  848,  879,  910,  941, 972,  1003, 1004, 973,  942,  911, 880,
  849,  818,  787,  756,  725,  694, 663,  632,  601,  570,  539,  508, 477,
  446,  415,  447,  478,  509,  540, 571,  602,  633,  664,  695,  726, 757,
  788,  819,  850,  881,  912,  943, 974,  1005, 1006, 975,  944,  913, 882,
  851,  820,  789,  758,  727,  696, 665,  634,  603,  572,  541,  510, 479,
  511,  542,  573,  604,  635,  666, 697,  728,  759,  790,  821,  852, 883,
  914,  945,  976,  1007, 1008, 977, 946,  915,  884,  853,  822,  791, 760,
  729,  698,  667,  636,  605,  574, 543,  575,  606,  637,  668,  699, 730,
  761,  792,  823,  854,  885,  916, 947,  978,  1009, 1010, 979,  948, 917,
  886,  855,  824,  793,  762,  731, 700,  669,  638,  607,  639,  670, 701,
  732,  763,  794,  825,  856,  887, 918,  949,  980,  1011, 1012, 981, 950,
  919,  888,  857,  826,  795,  764, 733,  702,  671,  703,  734,  765, 796,
  827,  858,  889,  920,  951,  982, 1013, 1014, 983,  952,  921,  890, 859,
  828,  797,  766,  735,  767,  798, 829,  860,  891,  922,  953,  984, 1015,
  1016, 985,  954,  923,  892,  861, 830,  799,  831,  862,  893,  924, 955,
  986,  1017, 1018, 987,  956,  925, 894,  863,  895,  926,  957,  988, 1019,
  1020, 989,  958,  927,  959,  990, 1021, 1022, 991,  1023,
];

#[rustfmt::skip]
pub static av1_scan_orders: [[SCAN_ORDER; TX_TYPES]; TxSize::TX_SIZES_ALL] = [
	[
		// TX_4X4
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &default_scan_4x4 },
		SCAN_ORDER { scan: &mrow_scan_4x4 },
		SCAN_ORDER { scan: &mcol_scan_4x4 },
		SCAN_ORDER { scan: &mrow_scan_4x4 },
		SCAN_ORDER { scan: &mcol_scan_4x4 },
		SCAN_ORDER { scan: &mrow_scan_4x4 },
		SCAN_ORDER { scan: &mcol_scan_4x4 },
	],
	[
		// TX_8X8
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &default_scan_8x8 },
		SCAN_ORDER { scan: &mrow_scan_8x8 },
		SCAN_ORDER { scan: &mcol_scan_8x8 },
		SCAN_ORDER { scan: &mrow_scan_8x8 },
		SCAN_ORDER { scan: &mcol_scan_8x8 },
		SCAN_ORDER { scan: &mrow_scan_8x8 },
		SCAN_ORDER { scan: &mcol_scan_8x8 },
	],
	[
		// TX_16X16
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &default_scan_16x16 },
		SCAN_ORDER { scan: &mrow_scan_16x16 },
		SCAN_ORDER { scan: &mcol_scan_16x16 },
		SCAN_ORDER { scan: &mrow_scan_16x16 },
		SCAN_ORDER { scan: &mcol_scan_16x16 },
		SCAN_ORDER { scan: &mrow_scan_16x16 },
		SCAN_ORDER { scan: &mcol_scan_16x16 },
	],
	[
		// TX_32X32
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
	],
	[
		// TX_64X64
		// Half of the coefficients of tx64 at higher frequencies are set to
		// zeros. So tx32's scan order is used.
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
	],
	[
		// TX_4X8
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &default_scan_4x8 },
		SCAN_ORDER { scan: &mrow_scan_4x8 },
		SCAN_ORDER { scan: &mcol_scan_4x8 },
		SCAN_ORDER { scan: &mrow_scan_4x8 },
		SCAN_ORDER { scan: &mcol_scan_4x8 },
		SCAN_ORDER { scan: &mrow_scan_4x8 },
		SCAN_ORDER { scan: &mcol_scan_4x8 },
	],
	[
		// TX_8X4
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &default_scan_8x4 },
		SCAN_ORDER { scan: &mrow_scan_8x4 },
		SCAN_ORDER { scan: &mcol_scan_8x4 },
		SCAN_ORDER { scan: &mrow_scan_8x4 },
		SCAN_ORDER { scan: &mcol_scan_8x4 },
		SCAN_ORDER { scan: &mrow_scan_8x4 },
		SCAN_ORDER { scan: &mcol_scan_8x4 },
	],
	[
		// TX_8X16
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &default_scan_8x16 },
		SCAN_ORDER { scan: &mrow_scan_8x16 },
		SCAN_ORDER { scan: &mcol_scan_8x16 },
		SCAN_ORDER { scan: &mrow_scan_8x16 },
		SCAN_ORDER { scan: &mcol_scan_8x16 },
		SCAN_ORDER { scan: &mrow_scan_8x16 },
		SCAN_ORDER { scan: &mcol_scan_8x16 },
	],
	[
		// TX_16X8
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &default_scan_16x8 },
		SCAN_ORDER { scan: &mrow_scan_16x8 },
		SCAN_ORDER { scan: &mcol_scan_16x8 },
		SCAN_ORDER { scan: &mrow_scan_16x8 },
		SCAN_ORDER { scan: &mcol_scan_16x8 },
		SCAN_ORDER { scan: &mrow_scan_16x8 },
		SCAN_ORDER { scan: &mcol_scan_16x8 },
	],
	[
		// TX_16X32
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &mrow_scan_16x32 },
		SCAN_ORDER { scan: &mcol_scan_16x32 },
		SCAN_ORDER { scan: &mrow_scan_16x32 },
		SCAN_ORDER { scan: &mcol_scan_16x32 },
		SCAN_ORDER { scan: &mrow_scan_16x32 },
		SCAN_ORDER { scan: &mcol_scan_16x32 },
	],
	[
		// TX_32X16
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &mrow_scan_32x16 },
		SCAN_ORDER { scan: &mcol_scan_32x16 },
		SCAN_ORDER { scan: &mrow_scan_32x16 },
		SCAN_ORDER { scan: &mcol_scan_32x16 },
		SCAN_ORDER { scan: &mrow_scan_32x16 },
		SCAN_ORDER { scan: &mcol_scan_32x16 },
	],
	[
		// TX_32X64
		// Half of the coefficients of tx64 at higher frequencies are set to
		// zeros. So tx32's scan order is used.
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
	],
	[
		// TX_64X32
		// Half of the coefficients of tx64 at higher frequencies are set to
		// zeros. So tx32's scan order is used.
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &default_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
		SCAN_ORDER { scan: &mrow_scan_32x32 },
		SCAN_ORDER { scan: &mcol_scan_32x32 },
	],
	[
		// TX_4X16
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &default_scan_4x16 },
		SCAN_ORDER { scan: &mrow_scan_4x16 },
		SCAN_ORDER { scan: &mcol_scan_4x16 },
		SCAN_ORDER { scan: &mrow_scan_4x16 },
		SCAN_ORDER { scan: &mcol_scan_4x16 },
		SCAN_ORDER { scan: &mrow_scan_4x16 },
		SCAN_ORDER { scan: &mcol_scan_4x16 },
	],
	[
		// TX_16X4
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &default_scan_16x4 },
		SCAN_ORDER { scan: &mrow_scan_16x4 },
		SCAN_ORDER { scan: &mcol_scan_16x4 },
		SCAN_ORDER { scan: &mrow_scan_16x4 },
		SCAN_ORDER { scan: &mcol_scan_16x4 },
		SCAN_ORDER { scan: &mrow_scan_16x4 },
		SCAN_ORDER { scan: &mcol_scan_16x4 },
	],
	[
		// TX_8X32
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &default_scan_8x32 },
		SCAN_ORDER { scan: &mrow_scan_8x32 },
		SCAN_ORDER { scan: &mcol_scan_8x32 },
		SCAN_ORDER { scan: &mrow_scan_8x32 },
		SCAN_ORDER { scan: &mcol_scan_8x32 },
		SCAN_ORDER { scan: &mrow_scan_8x32 },
		SCAN_ORDER { scan: &mcol_scan_8x32 },
	],
	[
		// TX_32X8
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &default_scan_32x8 },
		SCAN_ORDER { scan: &mrow_scan_32x8 },
		SCAN_ORDER { scan: &mcol_scan_32x8 },
		SCAN_ORDER { scan: &mrow_scan_32x8 },
		SCAN_ORDER { scan: &mcol_scan_32x8 },
		SCAN_ORDER { scan: &mrow_scan_32x8 },
		SCAN_ORDER { scan: &mcol_scan_32x8 },
	],
	[
		// TX_16X64
		// Half of the coefficients of tx64 at higher frequencies are set to
		// zeros. So tx32's scan order is used.
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &default_scan_16x32 },
		SCAN_ORDER { scan: &mrow_scan_16x32 },
		SCAN_ORDER { scan: &mcol_scan_16x32 },
		SCAN_ORDER { scan: &mrow_scan_16x32 },
		SCAN_ORDER { scan: &mcol_scan_16x32 },
		SCAN_ORDER { scan: &mrow_scan_16x32 },
		SCAN_ORDER { scan: &mcol_scan_16x32 },
	],
	[
		// TX_64X16
		// Half of the coefficients of tx64 at higher frequencies are set to
		// zeros. So tx32's scan order is used.
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &default_scan_32x16 },
		SCAN_ORDER { scan: &mrow_scan_32x16 },
		SCAN_ORDER { scan: &mcol_scan_32x16 },
		SCAN_ORDER { scan: &mrow_scan_32x16 },
		SCAN_ORDER { scan: &mcol_scan_32x16 },
		SCAN_ORDER { scan: &mrow_scan_32x16 },
		SCAN_ORDER { scan: &mcol_scan_32x16 },
	],
];
