# sdl2 cmake project-config input for ./configure scripts

set(prefix "/gnu/store/5lqn6ag3xlh6bgbfy4npwfly1l2dm433-sdl2-2.0.12") 
set(exec_prefix "${prefix}")
set(libdir "${exec_prefix}/lib")
set(SDL2_PREFIX "/gnu/store/5lqn6ag3xlh6bgbfy4npwfly1l2dm433-sdl2-2.0.12")
set(SDL2_EXEC_PREFIX "/gnu/store/5lqn6ag3xlh6bgbfy4npwfly1l2dm433-sdl2-2.0.12")
set(SDL2_LIBDIR "${exec_prefix}/lib")
set(SDL2_INCLUDE_DIRS "${prefix}/include/SDL2")
set(SDL2_LIBRARIES "-L${SDL2_LIBDIR} -Wl,-rpath,${libdir} -Wl,--enable-new-dtags -lSDL2")
string(STRIP "${SDL2_LIBRARIES}" SDL2_LIBRARIES)

if(NOT TARGET SDL2::SDL2)
  # Remove -lSDL2 as that is handled by CMake, note the space at the end so it does not replace e.g. -lSDL2main
  # This may require "libdir" beeing set (from above)
  string(REPLACE "-lSDL2 " "" SDL2_EXTRA_LINK_FLAGS "-Wl,-rpath,${libdir} -Wl,--enable-new-dtags -lSDL2 ")
  string(STRIP "${SDL2_EXTRA_LINK_FLAGS}" SDL2_EXTRA_LINK_FLAGS)
  string(REPLACE "-lSDL2 " "" SDL2_EXTRA_LINK_FLAGS_STATIC "-Wl,-rpath,${libdir} -Wl,--enable-new-dtags -lSDL2  -Wl,--no-undefined -lm -ldl  -lasound -lm -ldl -lpthread -L/gnu/store/y5h5gj17j9slgghmhka7vlhfgkpkjjyk-pulseaudio-14.0/lib -lpulse-simple -lpulse  -lX11 -lXext -lXcursor -lXrandr -lXxf86vm -L/gnu/store/kx58xc3hxa9b0mp1hl7pzz43bl7gh18h-libdrm-2.4.103/lib -ldrm -L/gnu/store/14qgm67plbh8d3m6lc87b9j6s9296vwn-mesa-20.2.4/lib -lgbm -L/gnu/store/g46s3l52b1rd1y8vllykdd0y9nzyl2bh-libxkbcommon-1.0.3/lib -L/gnu/store/qwxfy2jyhq2744s4ljcqk3hwcpsf93aq-wayland-1.18.0/lib -lwayland-egl -lwayland-client -lwayland-cursor -lxkbcommon -lpthread -lrt ")
  string(STRIP "${SDL2_EXTRA_LINK_FLAGS_STATIC}" SDL2_EXTRA_LINK_FLAGS_STATIC)

  add_library(SDL2::SDL2 SHARED IMPORTED)
  set_target_properties(SDL2::SDL2 PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${prefix}/include/SDL2"
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${exec_prefix}/lib/libSDL2.so"
    INTERFACE_LINK_LIBRARIES "${SDL2_EXTRA_LINK_FLAGS}")

  add_library(SDL2::SDL2-static STATIC IMPORTED)
  set_target_properties(SDL2::SDL2-static PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${prefix}/include/SDL2"
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${exec_prefix}/lib/libSDL2.a"
    INTERFACE_LINK_LIBRARIES "${SDL2_EXTRA_LINK_FLAGS_STATIC}")

  add_library(SDL2::SDL2main STATIC IMPORTED)
  set_target_properties(SDL2::SDL2main PROPERTIES
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${exec_prefix}/lib/libSDL2main.a")
endif()
