
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was LibRingClientConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

INCLUDE(GNUInstallDirs)

SET(LIB_RING_CLIENT_INCLUDE_DIR /gnu/store/jrdr0pkmh568hsdplfmddzppqzn577pq-jami-libclient-20211223.2.37be4c3/include/libringclient)

STRING(REPLACE "${CMAKE_LIBRARY_ARCHITECTURE}" "" SANE_LIBRARY_PATH "${CMAKE_INSTALL_FULL_LIBDIR}" )

# First, always set the dynamic path
SET(CMAKE_FIND_LIBRARY_SUFFIXES ".dylib;.so;.dll")
SET(LIB_RING_CLIENT_LIBRARY_NAME "ringclient")

FIND_LIBRARY(LIB_RING_CLIENT_LIBRARY_DYNAMIC NAMES ringclient
            PATHS ${RING_BUILD_DIR}/.libs
            PATHS /gnu/store/jrdr0pkmh568hsdplfmddzppqzn577pq-jami-libclient-20211223.2.37be4c3/lib
            PATHS ${CMAKE_INSTALL_PREFIX}/libexec )

#if ENABLE_STATIC is set, default to the static version
IF(DEFINED ${ENABLE_STATIC} OR ${ENABLE_STATIC} MATCHES true)
   SET(CMAKE_FIND_LIBRARY_SUFFIXES ".a;.la;.lib")
   SET(LIB_RING_CLIENT_LIBRARY_NAME "ringclient_static")

   FIND_LIBRARY(LIB_RING_CLIENT_LIBRARY_STATIC NAMES ringclient_static
             PATHS ${RING_BUILD_DIR}/.libs
             PATHS /gnu/store/jrdr0pkmh568hsdplfmddzppqzn577pq-jami-libclient-20211223.2.37be4c3/lib
             PATHS ${CMAKE_INSTALL_PREFIX}/libexec )
ENDIF()


FIND_LIBRARY(LIB_RING_CLIENT_LIBRARY NAMES ${LIB_RING_CLIENT_LIBRARY_NAME}
             PATHS ${RING_BUILD_DIR}/.libs
             PATHS /gnu/store/jrdr0pkmh568hsdplfmddzppqzn577pq-jami-libclient-20211223.2.37be4c3/lib
             PATHS ${CMAKE_INSTALL_PREFIX}/libexec )


# Set the usual CMake library variables. This is required for some other official
# cmake macros to work
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LIB_RING_CLIENT
    FOUND_VAR
        LIB_RING_CLIENT_FOUND
    REQUIRED_VARS
        LIB_RING_CLIENT_LIBRARY
        LIB_RING_CLIENT_INCLUDE_DIR
    VERSION_VAR
        1.0.0
)
