#pragma once
/**************************************************************************
* Copyright (C) 2016 by Savoir-faire Linux                                *
* Author: Jger Nicolas <nicolas.jager@savoirfairelinux.com>              *
* Author: Traczyk Andreas <andreas.traczyk@savoirfairelinux.com>          *
*                                                                         *
* This program is free software; you can redistribute it and/or modify    *
* it under the terms of the GNU General Public License as published by    *
* the Free Software Foundation; either version 3 of the License, or       *
* (at your option) any later version.                                     *
*                                                                         *
* This program is distributed in the hope that it will be useful,         *
* but WITHOUT ANY WARRANTY; without even the implied warranty of          *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
* GNU General Public License for more details.                            *
*                                                                         *
* You should have received a copy of the GNU General Public License       *
* along with this program.  If not, see <http://www.gnu.org/licenses/>.   *
**************************************************************************/
using namespace Platform::Collections;

namespace RingClientUWP
{
/* delegate */
delegate void CallRecieved(Call^ call);
delegate void CallStatusUpdated(Call^ call);
delegate void CallStarted();
delegate void CallEnded();

namespace ViewModel {
public ref class CallsViewModel sealed
{
internal:
    /* singleton */
    static property CallsViewModel^ instance
    {
        CallsViewModel^ get()
        {
            static CallsViewModel^ instance_ = ref new CallsViewModel();
            return instance_;
        }
    }

    /* properties */
    property Vector<String^>^ _callIdList
    {
        Vector<String^>^ get()
        {
            return callIdsList_;
        }
    }

    /* events */
    event CallRecieved^ callRecieved;
    event CallStatusUpdated^ callStatusUpdated;
    event CallStarted^ callStarted;
    event CallEnded^ callEnded;

private:
    CallsViewModel(); // singleton
    Vector<String^>^ callIdsList_;

};
}
}
