﻿/**************************************************************************
* Copyright (C) 2016 by Savoir-faire Linux                                *
* Author: Jäger Nicolas <nicolas.jager@savoirfairelinux.com>              *
*                                                                         *
* This program is free software; you can redistribute it and/or modify    *
* it under the terms of the GNU General Public License as published by    *
* the Free Software Foundation; either version 3 of the License, or       *
* (at your option) any later version.                                     *
*                                                                         *
* This program is distributed in the hope that it will be useful,         *
* but WITHOUT ANY WARRANTY; without even the implied warranty of          *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
* GNU General Public License for more details.                            *
*                                                                         *
* You should have received a copy of the GNU General Public License       *
* along with this program.  If not, see <http://www.gnu.org/licenses/>.   *
**************************************************************************/
#pragma once

#include "MessageTextPage.g.h"

namespace RingClientUWP
{
delegate void CloseMessageTextPage();

namespace Views
{

public ref class BubbleBackground sealed : IValueConverter {
public:
    virtual Object^ Convert(Object^ value, Windows::UI::Xaml::Interop::TypeName targetType, Object^ parameter, String^ language);
    virtual Object^ ConvertBack(Object^ value, Windows::UI::Xaml::Interop::TypeName  targetType, Object^ parameter, String^ language);
    BubbleBackground();
};

public ref class BubbleHorizontalAlignement sealed : IValueConverter {
public:
    virtual Object^ Convert(Object^ value, Windows::UI::Xaml::Interop::TypeName targetType, Object^ parameter, String^ language);
    virtual Object^ ConvertBack(Object^ value, Windows::UI::Xaml::Interop::TypeName  targetType, Object^ parameter, String^ language);
    BubbleHorizontalAlignement();
};

public ref class MessageTextPage sealed
{
public:
    MessageTextPage();
    void updatePageContent();
    void scrollDown();

internal:
    event CloseMessageTextPage^ closeMessageTextPage;

private:
    void _sendBtn__Click(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e);
    void _messageTextBox__KeyDown(Platform::Object^ sender, Windows::UI::Xaml::Input::KeyRoutedEventArgs^ e);
    void sendMessage();
    void OnincomingMessage(Platform::String ^callId, Platform::String ^payload);
    void OnSelectionChanged(Platform::Object ^sender, Windows::UI::Xaml::Controls::SelectionChangedEventArgs ^e);

    void _deleteContact__Click(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e);
    void _clearConversation__Click(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e);
    void _audioCall__Click(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e);
    void _videoCall__Click(Platform::Object^ sender, Windows::UI::Xaml::RoutedEventArgs^ e);
};
}
}
