/*
 * Copyright (c) 2018 Sergey Lavrushkin
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file
 * Default cnn weights for x2 upsampling with srcnn filter.
 */

#ifndef AVFILTER_DNN_SRCNN_H
#define AVFILTER_DNN_SRCNN_H

static const float conv1_kernel[] = {
    -0.08866338f,     0.055409566f,     0.037196506f,     -0.11961404f,
    -0.12341991f,     0.29963422f,      -0.0911817f,      -0.00013613555f,
    -0.049023595f,    0.038421184f,     -0.077267796f,    0.027273094f,
    0.4576209f,       0.023581645f,     -0.20363852f,     -0.07738442f,
    0.07288404f,      0.06679897f,      -0.07315085f,     0.2665306f,
    0.07836371f,      -0.28985283f,     -0.5069129f,      0.04466513f,
    -0.06246859f,     -0.024424827f,    -0.02907293f,     -0.16884787f,
    0.20686236f,      -0.25367007f,     -0.384997f,       -0.12601902f,
    0.72578824f,      0.09588378f,      -0.044872783f,    -0.011251596f,
    -0.029558526f,    0.2211706f,       -0.38453165f,     -0.053509537f,
    0.109559156f,     0.37257388f,      -0.28968045f,     -0.10883619f,
    0.1962879f,       0.09746793f,      -0.005647097f,    -0.13035884f,
    0.6254252f,       0.19104235f,      -0.011692332f,    -0.2706789f,
    -0.030754156f,    0.029875506f,     0.01680875f,      -0.18317908f,
    -0.1601607f,      0.35982913f,      -0.18890111f,     -0.2234334f,
    -0.11111768f,     0.32211426f,      -0.18514074f,     -0.066470124f,
    0.18005541f,      -0.035659794f,    -0.25352174f,     -0.1837048f,
    0.28395423f,      0.0030237234f,    0.24072711f,      -0.14355472f,
    0.047418743f,     -0.032212373f,    -0.08801338f,     0.2959175f,
    0.04108741f,      -0.10354422f,     -0.11681117f,     -0.010267493f,
    0.023703521f,     -0.043954458f,    0.095338844f,     0.122337975f,
    -0.05211482f,     0.068812296f,     0.05764868f,      0.086866505f,
    -0.12001238f,     0.023536388f,     -0.022270674f,    -0.06377912f,
    0.010644146f,     -0.27824146f,     -0.23719865f,     -0.21418367f,
    -0.096650206f,    0.10458535f,      0.06599419f,      -0.031174282f,
    -0.034653533f,    0.022143817f,     -0.24322355f,     -0.089235984f,
    -0.027248107f,    -0.09314897f,     -0.037409738f,    0.07819665f,
    0.12521376f,      0.11189836f,      0.34981978f,      0.24303557f,
    0.21350804f,      0.37120733f,      0.12192775f,      -0.15492134f,
    0.018840319f,     -0.08351074f,     -0.3054998f,      -0.114621654f,
    -0.11833595f,     -0.3502763f,      -0.0077491426f,   -0.051849455f,
    -0.14423956f,     -0.040475942f,    0.18357797f,      0.16708122f,
    0.07486253f,      0.17892863f,      0.12331069f,      0.16825254f,
    -0.040668704f,    0.12498869f,      0.12445469f,      -0.08529795f,
    -0.23087382f,     -0.242645f,       -0.0033642692f,   -0.019013511f,
    0.007406716f,     -0.0976248f,      0.09727376f,      -0.1430845f,
    0.20924512f,      0.04731563f,      0.17839451f,      0.2014277f,
    -0.21384318f,     -0.16858183f,     0.07769212f,      0.114782944f,
    0.0022495266f,    -0.095246606f,    -0.11904185f,     -0.119040586f,
    0.119354986f,     0.040786922f,     -0.07873279f,     0.19328512f,
    -0.06008545f,     -0.03619225f,     -0.03508937f,     -0.021296037f,
    0.04467616f,      0.035148017f,     0.047732554f,     -0.036008984f,
    -0.09819481f,     -0.07464613f,     0.16331302f,      0.05766148f,
    -0.060683597f,    0.023710888f,     0.040778793f,     0.01952822f,
    -0.047095288f,    -0.0026468062f,   0.013081373f,     -0.048433363f,
    -0.05547124f,     -0.007511544f,    -0.0018498366f,   0.0063248295f,
    0.08334494f,      -0.03534594f,     -0.058733407f,    -0.11714734f,
    -0.0496851f,      -0.010657697f,    0.08840381f,      0.068287104f,
    0.020970112f,     0.2620501f,       0.11938151f,      0.042141f,
    -0.064056866f,    -0.04790669f,     0.054825947f,     0.07402177f,
    0.21512434f,      0.25780582f,      0.4271634f,       0.18216214f,
    0.12531154f,      0.103901714f,     -0.0104828905f,   -0.07587306f,
    -0.01289812f,     0.100657016f,     0.073730744f,     0.1594899f,
    -0.08611099f,     0.0066837906f,    0.107562296f,     -0.10216449f,
    -0.121009395f,    0.00951384f,      0.04604567f,      0.067058936f,
    0.21903297f,      0.026905395f,     0.0053238617f,    0.00067650457f,
    -0.042836767f,    -0.025259271f,    -0.009707702f,    -0.0009789661f,
    0.043257646f,     0.088092126f,     0.018156063f,     -0.012795507f,
    -0.10799489f,     0.044633016f,     0.13564141f,      0.033341955f,
    -0.12862708f,     -0.13122201f,     -0.009230303f,    -0.019398134f,
    -0.005852208f,    -0.05510853f,     -0.039392535f,    0.036042538f,
    -0.017754223f,    0.012287495f,     0.08819248f,      -0.04256459f,
    -0.08412625f,     0.003404226f,     0.095139764f,     -0.01955163f,
    -0.09674753f,     0.18024282f,      -0.08090512f,     -0.24444069f,
    0.006856921f,     0.1304172f,       0.025669439f,     -0.23943077f,
    0.044755235f,     -0.016099237f,    -0.18014333f,     -0.119650446f,
    0.15631895f,      0.23565492f,      -0.016446924f,    0.088609904f,
    0.030303521f,     0.037084505f,     0.20704922f,      -0.30848193f,
    0.2985248f,       0.51717925f,      0.008160744f,     -0.3112909f,
    -0.12307852f,     0.23214605f,      -0.034601245f,    -0.053407326f,
    0.10225691f,      0.21641655f,      -0.006494026f,    -0.2507584f,
    -0.20448849f,     0.050536312f,     0.12135548f,      -0.24142836f,
    -0.28441224f,     0.33926067f,      -0.18576817f,     -0.49420735f,
    -0.097031295f,    0.0031086628f,    0.15142952f,      -0.08352979f,
    0.11525617f,      0.1575496f,       0.11142445f,      0.0034580992f,
    -0.17606017f,     0.16817984f,      0.09105344f,      0.039175604f,
    -0.09479037f,     0.056350756f,     0.02523156f,      -0.2455007f,
    0.063366f,        0.16318576f,      0.21757606f,      -0.10586289f,
    -0.08236702f,     0.06969914f,      -0.024705412f,    -0.053974763f,
    0.17869812f,      -0.027807202f,    -0.19675265f,     -0.1037345f,
    0.008513543f,     0.13250032f,      -0.045926444f,    -0.0030838586f,
    -0.040477958f,    0.049372006f,     -0.1366689f,      0.13786657f,
    -0.13875751f,     0.29655218f,      0.17230958f,      -0.13066995f,
    -0.048650246f,    0.04459606f,      -0.03141404f,     0.031236706f,
    0.14699893f,      -0.4883143f,      -0.44782618f,     -0.32052815f,
    0.22293234f,      0.11625721f,      0.030552648f,     -0.13195507f,
    -0.0958492f,      0.070505545f,     -0.14855938f,     0.10478757f,
    -0.16068053f,     -0.12290131f,     -0.13379076f,     0.024233105f,
    0.23596089f,      -0.021006849f,    0.1890502f,       0.5085715f,
    0.63729393f,      0.21577123f,      0.011278441f,     0.18822116f,
    -0.1545927f,      -0.040722325f,    -0.103782505f,    -0.20680243f,
    -0.0048381016f,   -0.08054019f,     -0.20550838f,     -0.16877042f,
    -0.13454553f,     0.24716504f,      -0.055626824f,    0.26783165f,
    -0.060780562f,    -0.30375552f,     -0.16147833f,     0.13623716f,
    0.2936753f,       0.047969237f,     -0.030661728f,    -0.3058367f,
    -0.08003057f,     0.10655708f,      -0.018742286f,    0.03587923f,
    -0.025629207f,    -0.11310985f,     -0.14455995f,     0.040501814f,
    0.281208f,        -0.05849621f,     0.09595922f,      -0.004120929f,
    0.14832601f,      0.05187895f,      -0.02497972f,     0.12018023f,
    -0.059710164f,    -0.027000621f,    -0.15200919f,     0.17205532f,
    -0.10738909f,     -0.042039443f,    -0.051565733f,    0.04735837f,
    -0.020336714f,    0.07923563f,      0.019853497f,     0.048436765f,
    -0.002480322f,    -0.030445646f,    0.043048497f,     -0.020503692f,
    -0.066097535f,    0.120975174f,     0.007324902f,     -0.12224785f,
    -0.05323218f,     -0.057645664f,    -0.02026738f,     -0.024209453f,
    -0.0054551987f,   0.009971959f,     0.023965936f,     -0.00814846f,
    -0.005118968f,    0.021225877f,     -0.007966008f,    0.08807613f,
    0.014100072f,     -0.025872009f,    -0.077255875f,    0.03290955f,
    0.034313247f,     0.09776207f,      0.13437991f,      0.05204649f,
    0.23554459f,      0.18288168f,      0.09693129f,      -0.050400723f,
    -0.04832229f,     -0.09905002f,     -0.0074814707f,   0.19846895f,
    0.14758876f,      0.23091012f,      0.13733757f,      0.13091283f,
    0.092882596f,     -0.05274213f,     -0.17166649f,     -0.04306709f,
    0.14391254f,      0.038292434f,     0.087384045f,     -0.029237974f,
    0.063960664f,     0.12762053f,      -0.028018195f,    -0.12651931f,
    0.024751775f,     0.105892144f,     0.09887335f,      0.24562614f,
    0.12530468f,      0.061612073f,     -0.02412554f,     0.007247811f,
    -0.047855668f,    0.013432898f,     0.03482811f,      0.077229805f,
    0.10088468f,      0.044684406f,     -0.020415774f,    -0.15163109f,
    -0.003470435f,    0.122444995f,     0.03920309f,      -0.06930789f,
    -0.015424877f,    -0.016137347f,    -0.045813974f,    0.013485563f,
    0.024088666f,     0.016876703f,     0.12519507f,      -0.04165464f,
    0.03898311f,      -0.22598723f,     -0.09394079f,     0.19191247f,
    0.02938326f,      0.10377474f,      -0.24925913f,     -0.043930937f,
    -0.36712214f,     0.31546825f,      0.36849597f,      0.035715375f,
    -0.22950608f,     -0.32223397f,     0.11626888f,      0.3696772f,
    0.07823025f,      -0.033942547f,    -0.16880909f,     -0.10228094f,
    0.106198385f,     0.1882109f,       0.2380294f,       -0.3408791f,
    -0.07126304f,     0.061694082f,     0.43413436f,      0.018764552f,
    -0.51686966f,     -0.18586229f,     0.023195839f,     0.41148797f,
    -0.16325277f,     -0.046247307f,    -0.24675505f,     -0.24047938f,
    0.5096768f,       -0.11603347f,     -0.16423485f,     -0.41469073f,
    0.031696033f,     0.28646103f,      -0.04983063f,     0.28279418f,
    -0.5298738f,      0.44763f,         0.38769612f,      0.10861405f,
    -0.45158744f,     -0.28046185f,     0.25342128f,      -0.0061804154f,
    0.06170508f,      -0.420829f,       -0.30815917f,     0.30253378f,
    0.42957127f,      0.21554874f,      0.13188276f,      -0.20662707f,
    -0.040692847f,    0.12084224f,      0.5464517f,       -0.07281342f,
    -0.3835149f,      -0.27153537f,     -0.075712286f,    0.18072815f,
    -0.0997861f,      -0.01804055f,     -0.06959384f,     -0.3904227f,
    0.31299376f,      0.034528203f,     0.02515312f,      0.10656317f,
    -0.11172981f,     0.03748367f,      0.047296297f,     0.096831344f,
    -0.049026966f,    -0.03762363f,     0.10789167f,      -8.2200495e-06f,
    -0.1436379f,      -0.16596809f,     -0.08668889f,     0.18112758f,
    0.18681282f,      -0.031499103f,    0.046268225f,     0.18094164f,
    0.13341115f,      -0.008029769f,    -0.012183527f,    0.017653124f,
    -0.14602351f,     0.026090171f,     -0.028547902f,    0.0288749f,
    0.050831404f,     0.02064963f,      -0.08328215f,     -0.023062726f,
    0.0100690285f,    -0.12333137f,     0.05370744f,      -0.032471668f,
    -0.039362177f,    -0.088298194f,    -0.1376573f,      -0.11359868f,
    0.013083261f,     0.022561146f,     0.13207185f,      0.13661605f,
    0.04625131f,      0.058866706f,     0.0007978741f,    -0.012749897f,
    -0.010349061f,    0.07410106f,      0.07395954f,      0.18698151f,
    -0.04733249f,     0.04808804f,      0.08305503f,      0.030247696f,
    0.066441774f,     0.01284118f,      0.03576447f,      0.021402419f,
    0.06981247f,      -0.257638f,       -0.04209354f,     0.0068166372f,
    0.05338363f,      0.08177036f,      0.051337954f,     0.112714246f,
    0.017543655f,     0.07357459f,      -0.08409542f,     -0.03438184f,
    0.00063496234f,   0.10339711f,      0.034956418f,     -0.05212417f,
    -0.012170638f,    -0.069774695f,    0.07710031f,      0.19582804f,
    -0.11509156f,     -0.06393624f,     0.06701605f,      0.034070633f,
    0.023426907f,     -0.012323208f,    -0.0040504327f,   0.07350231f,
    -0.050630633f,    0.08542391f,      -0.067134544f,    -0.018519955f,
    -0.33999467f,     0.059590742f,     0.021070233f,     0.021752946f,
    -0.06753665f,     0.010389532f,     -0.11542703f,     -0.002727718f,
    0.109868094f,     0.2609012f,       0.15581563f,      -0.10301734f,
    0.017184122f,     0.038743876f,     0.10182109f,      -0.04267549f,
    -0.05238019f,     0.14567997f,      0.22389087f,      0.018040285f,
    -0.12593505f,     0.10430044f,      -0.03315733f,     -0.14966941f,
    0.16408929f,      -0.059988324f,    -0.015550675f,    -0.4687278f,
    0.008157095f,     0.011156036f,     -0.0006008691f,   0.00054899044f,
    -0.2431062f,      0.32610914f,      0.21652724f,      -0.22604592f,
    -0.91680276f,     -0.17663948f,     0.21353388f,      0.32204127f,
    -0.22002497f,     0.0037586878f,    0.029378487f,     0.051968988f,
    0.0074237757f,    -0.3208966f,      -0.15943418f,     -0.086690426f,
    0.17428546f,      -0.20170446f,     0.1177336f,       -0.09072964f,
    -0.1874367f,      0.1142301f,       0.19110383f,      0.04378007f,
    -0.019695848f,    0.03457418f,      0.10652895f,      -0.0077469912f,
    0.05716716f,      -0.07428691f,     0.1068072f,       0.23509608f,
    0.11014974f,      0.0052975365f,    -0.09246116f,     0.08342938f,
    -0.057548903f,    0.038700644f,     0.042864017f,     0.0042763776f,
    -0.28811076f,     -0.012603708f,    0.02950247f,      0.06630267f,
    -0.04321223f,     -0.04078223f,     -0.12889281f,     0.0037809012f,
    -0.04499083f,     -0.17399508f,     -0.08897207f,     -0.07621183f,
    -0.13595383f,     0.14221118f,      0.14240193f,      -0.029453754f,
    0.13097179f,      0.11728502f,      0.056849636f,     0.10260997f,
    0.13640848f,      0.06682252f,      0.04153318f,      -0.061906256f,
    -0.034821812f,    0.13024269f,      0.0877932f,       -0.009105867f,
    -0.084568165f,    -0.021619637f,    -0.050305564f,    -0.056489184f,
    -0.07594376f,     0.0947521f,       0.19542919f,      0.13114998f,
    0.011391324f,     -0.14203785f,     -0.05326744f,     -0.05350463f,
    0.03762699f,      -0.116486855f,    0.07287168f,      0.15281938f,
    0.120734006f,     0.120670766f,     -0.005608264f,    0.04571988f,
    0.024191812f,     0.04859131f,      -0.17068271f,     -0.05672881f,
    -0.012579148f,    -0.092275545f,    0.02230174f,      0.00049325003f,
    0.009508128f,     0.0031514226f,    -0.008896675f,    -0.05413659f,
    0.04761623f,      0.061746318f,     0.024428768f,     0.12186183f,
    0.091696575f,     0.04700263f,      -0.0075267525f,   0.01986404f,
    -0.014247048f,    0.0007475072f,    0.00031564324f,   0.047637384f,
    0.06383069f,      0.0032782517f,    -0.015528253f,    -0.094334565f,
    -0.008774848f,    0.114924446f,     -0.08672237f,     -0.13945794f,
    -0.11357707f,     -0.06397918f,     0.005938075f,     0.03685227f,
    0.0073830513f,    0.017816478f,     0.12231902f,      -0.13325934f,
    0.025870023f,     0.10824726f,      0.10331027f,      0.25639644f,
    -0.05961012f,     -0.10638878f,     0.0039590984f,    -0.1181265f,
    -0.04782482f,     0.1282174f,       -0.044032667f,    -0.2635486f,
    0.09152621f,      0.19478914f,      0.20143566f,      -0.06887999f,
    0.094949685f,     0.00086271897f,   0.11727813f,      -0.106873214f,
    -0.42762023f,     -0.22730431f,     -0.24313688f,     -0.06356537f,
    -0.05558194f,     0.032844584f,     -0.14488743f,     -0.06454714f,
    0.03559339f,      0.16276287f,      0.43327114f,      -0.035259817f,
    0.07995441f,      0.32160333f,      -0.027879553f,    0.069242865f,
    -0.027636014f,    -0.07363066f,     0.002821522f,     0.19947574f,
    -0.32169384f,     -0.2148716f,      -0.02213955f,     0.04032602f,
    0.17997573f,      0.10570091f,      0.06988003f,      -0.039484616f,
    -0.012861415f,    -0.1395959f,      0.05889321f,      -0.028116813f,
    -0.10384295f,     -0.14942081f,     -0.15001269f,     0.0046144384f,
    -0.09650319f,     -0.030123489f,    0.07189779f,      0.150204f,
    0.008814078f,     0.035910066f,     0.021772446f,     0.0057694535f,
    0.094028726f,     0.015208455f,     0.09444975f,      0.027698299f,
    -0.067443125f,    -0.076761544f,    0.014581596f,     -0.0036740561f,
    0.06329378f,      -0.054385025f,    -0.05358858f,     0.028128311f,
    -0.09020408f,     0.069442004f,     0.014859441f,     -0.0051601524f,
    0.013758934f,     0.062362246f,     0.10193951f,      0.053054996f,
    -0.23131405f,     -0.22592732f,     0.034349527f,     0.1306911f,
    -0.105051294f,    0.05535679f,      -0.026555436f,    -0.01622189f,
    -0.06733753f,     0.29508868f,      0.24902128f,      -0.045863412f,
    -0.13178392f,     -0.0017491007f,   -0.10163252f,     -0.19645393f,
    -0.21069992f,     -0.36476517f,     0.14708625f,      0.1371015f,
    -0.030172884f,    0.0417268f,       0.23463379f,      0.12248606f,
    0.1609971f,       0.28750896f,      0.06577457f,      -0.04996803f,
    -0.1670369f,      -0.11296174f,     0.032325566f,     -0.1946847f,
    -0.19403425f,     -0.138909f,       0.28837493f,      0.1756209f,
    0.058868773f,     -0.15678346f,     -0.20327216f,     0.25534904f,
    -0.038206924f,    0.10567138f,      -0.05586522f,     0.04803805f,
    0.037080843f,     0.3200386f,       0.10980628f,      -0.15385062f,
    0.02880763f,      0.15568581f,      0.17938006f,      -0.07448219f,
    -0.28561842f,     -0.35392216f,     -0.023577707f,    -0.033707f,
    0.010182503f,     0.0145983165f,    0.043775484f,     -0.13170591f,
    -0.03999235f,     0.03889957f,      -0.09751184f,     -0.052088927f,
    0.010670154f,     0.05313429f,      -0.0034348546f,   -0.1760906f,
    0.06542654f,      0.108333714f,     0.12016133f,      0.20534334f,
    0.02289868f,      -0.005226183f,    -0.04157602f,     -0.0174927f,
    0.04755033f,      0.028359868f,     -0.099690236f,    0.053056244f,
    0.06712003f,      -0.024950854f,    0.096332975f,     0.12241448f,
    0.06672052f,      -0.14968997f,     0.006965478f,     -0.010117425f,
    0.11532666f,      0.07065546f,      -0.059816815f,    0.056025293f,
    0.11349499f,      -0.07753042f,     0.0063369446f,    0.11751655f,
    0.026646622f,     0.056598563f,     0.023606442f,     -0.10963785f,
    -0.042333852f,    0.061614495f,     0.005725273f,     0.026712202f,
    0.011555864f,     -0.13339062f,     -0.12263333f,     -0.053668566f,
    -0.093832694f,    -0.025312075f,    0.040834136f,     0.11758151f,
    0.068973154f,     0.09025384f,      -0.048477206f,    -0.0442859f,
    -0.009945096f,    -0.081491515f,    -0.015064211f,    0.008549756f,
    0.059294533f,     0.08121352f,      0.1862254f,       0.024635188f,
    0.05900023f,      0.06015001f,      -0.048190203f,    0.056722432f,
    0.008928966f,     -0.045349732f,    0.031576462f,     0.07381211f,
    -0.101853915f,    0.0071175774f,    0.065901496f,     0.033646476f,
    0.14542401f,      0.040063225f,     -0.019146165f,    0.04167646f,
    0.011365608f,     -0.09844156f,     -0.013422103f,    -0.032459687f,
    -0.08080594f,     -0.0064284275f,   -0.057439506f,    -0.080713354f,
    -0.073422015f,    -0.043172568f,    0.05168831f,      0.18833208f,
    0.037167333f,     -0.10183737f,     -0.032890514f,    0.0048192614f,
    -0.027331548f,    0.11519626f,      -0.10764797f,     -0.030568555f,
    -0.020863555f,    -0.079977386f,    -0.120523565f,    -0.058285322f,
    -0.14723009f,     -0.06770515f,     -0.015620629f,    0.015726376f,
    0.14131089f,      0.11010552f,      0.048104443f,     0.075433314f,
    0.0912747f,       0.08718889f,      0.23427182f,      -0.14150192f,
    -0.009130682f,    -0.03805909f,     0.017746095f,     0.12451276f,
    0.100404136f,     -0.023616508f,    -0.07792383f,     -0.046339437f,
    0.08530189f,      0.13883007f,      -0.06484226f,     -0.057417613f,
    -0.0055942344f,   -0.048822958f,    0.020849438f,     0.11939212f,
    0.036201835f,     0.013776281f,     -0.052864313f,    -0.122572504f,
    -0.031724475f,    -0.15581031f,     -0.3350363f,      -0.17516199f,
    0.055541296f,     -0.06866166f,     0.051852006f,     0.010789181f,
    0.091042385f,     0.24157585f,      0.14322907f,      -0.061515134f,
    0.035073213f,     0.21045916f,      -0.013173309f,    -0.027040262f,
    -0.08000552f,     -0.046120286f,    0.029197183f,     -0.012629073f,
    -0.10132585f,     -0.017108483f,    0.11031835f,      -0.0014046419f,
    0.06428525f,      0.025128264f,     -0.012446816f,    -0.004635911f,
    -0.10815041f,     -0.22872593f,     -0.050878406f,    0.079038456f,
    0.007435937f,     -0.026907602f,    0.030150397f,     -0.0032097425f,
    -0.007098188f,    -0.022753686f,    -0.11266213f,     0.08625404f,
    0.11682f,         -0.113119945f,    0.16389656f,      0.08308251f,
    0.04414798f,      0.08042957f,      0.06370082f,      -0.10228356f,
    -0.10279214f,     -0.114535056f,    -0.13203175f,     -0.18760122f,
    -0.2638652f,      -0.0045001656f,   0.06932094f,      0.12449022f,
    0.14221719f,      0.3287882f,       0.34202385f,      0.08183268f,
    0.21325354f,      -0.22493534f,     -0.12725762f,     0.09147706f,
    0.12901255f,      -0.030734122f,    -0.27371204f,     -0.10408978f,
    0.14720973f,      0.10748198f,      -0.15999617f,     -0.050099745f,
    -0.087015405f,    -0.2068928f,      0.071161255f,     -0.23476274f,
    -0.26232046f,     -0.013499018f,    0.025579002f,     -0.20041595f,
    0.20189898f,      0.09299933f,      -0.112808794f,    0.3926468f,
    0.07530068f,      -0.1266297f,      0.067624144f,     0.15581152f,
    -0.18859749f,     0.1387742f,       -0.019523712f,    -0.097933404f,
    0.18235981f,      -0.16306429f,     -0.08839341f,     0.11948713f,
    -0.059917364f,    -0.14886321f,     0.09461962f,      -0.08510956f,
    -0.1396606f,      0.24795464f,      0.11794982f,      0.05069331f,
    -0.01211499f,     0.044572905f,     -0.04815959f,     0.18828984f,
    0.19097438f,      -0.28103575f,     -0.09559923f,     -0.024672048f,
    -0.08950752f,     -0.13805328f,     0.0033542095f,    -0.056686185f,
    -0.0882191f,      -0.0643803f,      0.061702255f,     0.20625977f,
    -0.1312813f,      0.13963045f,      0.028703267f,     -0.043307148f,
    0.04782818f,      0.02259783f,      0.028202934f,     0.11306529f,
    0.046207666f,     0.033250716f,     0.013018331f,     -0.030188587f,
    -0.09428549f,     0.0083047375f,    -0.012987429f,    -0.014564705f,
    -0.01775816f,     -0.08705758f,     -0.00728948f,     0.03306054f,
    -0.07457553f,     -0.045349747f,    0.09827588f,      0.011266577f,
    0.014672775f,     0.08231432f,      -0.035962153f,    -0.06713401f,
    -0.059379876f,    0.013066738f,     0.0018231334f,    0.062104795f,
    -0.022566145f,    -0.016408412f,    0.22817095f,      0.10552603f,
    -0.0029259105f,   -0.07945609f,     -0.03885507f,     0.04577802f,
    0.042213928f,     0.06688313f,      0.15467569f,      0.31194326f,
    0.12416515f,      0.07539508f,      0.05988782f,      0.03964969f,
    -0.050274324f,    0.008425816f,     -0.016213499f,    0.038200848f,
    0.09047191f,      -0.12545325f,     -0.015551999f,    0.05305446f,
    -0.040371228f,    -0.04612181f,     0.023092406f,     -0.06815006f,
    0.019335538f,     0.14722861f,      -0.034557853f,    -0.00979706f,
    0.008686223f,     -0.022849966f,    -0.032456208f,    0.0055913217f,
    -0.040950026f,    0.013277397f,     0.06872589f,      -0.008198447f,
    -0.0033175326f,   -0.021463187f,    0.02498839f,      -0.10292976f,
    0.058409244f,     -0.014231771f,    -0.009959504f,    0.051610235f,
    -0.034096178f,    0.008187869f,     0.0473137f,       0.048039116f,
    0.08029708f,      -0.040511582f,    0.04360192f,      0.058650926f,
    -0.16222054f,     -0.024287313f,    0.08362858f,      0.06500931f,
    -0.05659391f,     -0.26240957f,     0.13464408f,      -0.18771033f,
    0.115500644f,     0.16735835f,      0.11418536f,      0.042084884f,
    -0.28944123f,     0.19866064f,      0.1005324f,       0.34987235f,
    -0.067719065f,    0.071370974f,     0.16644107f,      -0.13974255f,
    0.027255967f,     0.087808f,        -0.043968193f,    -0.043444134f,
    -0.15180604f,     0.061978534f,     0.017747758f,     -0.03478431f,
    -0.4419927f,      -0.18068086f,     0.3019534f,       -0.16370183f,
    0.102701865f,     0.045449734f,     0.22482808f,      -0.12152138f,
    0.010336582f,     -0.01738337f,     0.055105288f,     0.17041063f,
    -0.042338647f,    -0.19112332f,     0.03816298f,      -0.046139482f,
    -0.4952857f,      -0.053064033f,    0.18114856f,      0.046867907f,
    -0.20611686f,     0.05648867f,      0.12168501f,      0.028137347f,
    0.059462287f,     -0.14465803f,     0.096850656f,     0.07187638f,
    0.18015277f,      -0.04393239f,     -0.05857812f,     -0.024302706f,
    -0.22155425f,     0.12393767f,      0.25892124f,      0.1899091f,
    -0.27774405f,     -0.09749725f,     0.095212705f,     0.08916869f,
    0.0026095544f,    0.11813537f,      -0.009317749f,    -0.22345436f,
    -0.049469028f,    0.06460579f,      0.06491654f,      -0.039918967f,
    -0.06013341f,     -0.0022389349f,   0.075655766f,     -0.07352778f,
    0.065104336f,     -0.123692974f,    0.014344852f,     0.032086864f,
    0.098316625f,     0.030373802f,     0.061919935f,     -0.013876724f,
    -0.1507151f,      0.03463516f,      0.047679137f,     0.13710123f,
    -0.0939533f,      -0.06332149f,     -0.08442048f,     -0.0893595f,
    0.01231802f,      0.07064413f,      0.142181f,        0.11146872f,
    0.24141559f,      -0.20935582f,     -0.16613059f,     -0.015605927f,
    0.019988716f,     0.067589335f,     -0.071916856f,    -0.012369817f,
    -0.10486599f,     0.1758254f,       -0.12994747f,     -0.04703458f,
    0.15262653f,      0.07538525f,      0.117247656f,     -0.19104752f,
    -0.014827147f,    -0.22970618f,     0.116267174f,     -0.019031005f,
    -0.041880254f,    0.06078922f,      -0.028908819f,    0.046996616f,
    -0.2693546f,      0.18767853f,      -0.14111796f,     0.2596699f,
    0.106781445f,     -0.18526307f,     -0.019005788f,    0.097458936f,
    -0.055909533f,    -0.08272333f,     0.31723425f,      -0.06583877f,
    0.09415222f,      -0.07164924f,     -0.069666326f,    0.026628084f,
    -0.1994942f,      -0.024620663f,    0.2131185f,       0.27181304f,
    0.016480023f,     -0.13939704f,     -0.34433267f,     0.0015986569f,
    0.0038846422f,    0.051192448f,     0.16911222f,      -0.2610857f,
    -0.07406745f,     -0.029053759f,    0.134585f,        0.11526892f,
    -0.03541361f,     0.056526754f,     0.0021767209f,    -0.0005761379f,
    0.00053732615f,   0.00019933497f,   0.0013520612f,    0.00075393013f,
    -0.00013426547f,  -0.0011657949f,   0.0012583841f,    0.0005933881f,
    -0.0017465304f,   -0.00148401f,     0.00039302f,      -0.00046452755f,
    -0.001687875f,    0.0002233775f,    -0.0010295593f,   -0.0009793324f,
    -0.00064591167f,  -0.002123567f,    -0.0003201432f,   -0.0012910896f,
    0.00028557915f,   2.8073684e-05f,   -7.394276e-05f,   -5.3465526e-05f,
    -0.00032978097f,  -0.0003956406f,   -0.00086094596f,  0.0014557735f,
    0.0010776157f,    0.0011523488f,    0.0002128259f,    -0.0011867908f,
    -0.00076821604f,  -0.0003217654f,   -5.279079e-05f,   0.00013192534f,
    -0.001012051f,    8.375828e-05f,    -0.00084518874f,  -0.00048461664f,
    0.0008424f,       0.00021478746f,   -0.00050686183f,  -0.0020821916f,
    -0.0006638174f,   -0.00088668586f,  -0.0006656063f,   0.00026315945f,
    0.00061285595f,   -0.0025304651f,   0.001500496f,     0.0004355564f,
    -0.0018750376f,   0.00027806574f,   0.00079155416f,   0.00090569095f,
    -7.5554264e-05f,  -8.375365e-05f,   0.0005546159f,    0.0028697362f,
    -0.0006116627f,   0.00037985286f,   -0.0023933311f,   0.00070501457f,
    0.00024751015f,   -0.0005008446f,   0.0007629976f,    -0.00047074357f,
    0.0019536067f,    -0.00038732955f,  -0.00015744158f,  -0.0015861616f,
    -0.0007085212f,   0.0003875632f,    -0.00160213f,     -0.0005903083f,
    0.00042594975f,   -0.00037768186f,  -0.0018262226f,   -0.054790907f,
    0.2536485f,       -0.27960002f,     0.10039357f,      -0.121576376f,
    0.20832302f,      0.18832406f,      0.05801611f,      -0.19121705f,
    0.07001335f,      0.011789658f,     -0.1497596f,      0.32273632f,
    -0.44360176f,     -0.17157759f,     -0.13726442f,     -0.30719328f,
    0.3887871f,       -0.1556761f,      0.17874531f,      -0.19251512f,
    0.19171362f,      -0.014789952f,    0.25968435f,      -0.03754927f,
    -0.28481236f,     0.041025605f,     -0.19286713f,     0.42374134f,
    -0.14859319f,     -0.024421748f,    0.2129438f,       0.6637655f,
    0.011664158f,     -0.20433177f,     0.00049039285f,   -0.10848186f,
    0.2089244f,       -0.14281906f,     -0.3483708f,      -0.5034168f,
    0.37560794f,      0.11458431f,      -0.4429203f,      0.05628497f,
    0.079709746f,     -0.023797868f,    0.10833027f,      0.18675034f,
    -0.20897903f,     0.044153582f,     0.2563679f,       -0.10854593f,
    0.14499803f,      0.03994301f,      -0.04328295f,     -0.20615563f,
    0.092253454f,     0.08605579f,      -0.21106604f,     -0.0736636f,
    0.05395741f,      -0.047547996f,    -0.12710959f,     0.25294298f,
    -0.09454375f,     0.025951438f,     0.07715667f,      0.17352186f,
    0.044705767f,     -0.0611999f,      -0.039735083f,    0.010745589f,
    0.023101542f,     -0.060947835f,    0.048681073f,     -0.20067468f,
    0.086466976f,     0.03963541f,      -0.13203776f,     0.0869461f,
    -0.09722302f,     0.032106955f,     -0.07559206f,     -0.0124253165f,
    0.09689221f,      -0.07424143f,     -0.02391237f,     0.04545597f,
    -0.08255463f,     -0.13820241f,     0.054376055f,     -0.028118603f,
    -0.019561796f,    -0.04275551f,     -0.095187284f,    0.064970225f,
    0.15782668f,      -0.068125695f,    -0.031783927f,    0.14993486f,
    0.018872647f,     0.047461137f,     0.058277708f,     -0.039790988f,
    -0.010545186f,    0.038829897f,     0.041085605f,     -0.017792938f,
    0.04831158f,      -0.06487991f,     -0.016816694f,    0.1503911f,
    0.008327034f,     -0.05022227f,     -0.047379978f,    0.013194894f,
    0.08495985f,      0.03979637f,      0.0049327346f,    0.16051397f,
    0.3089985f,       0.13151097f,      0.050496068f,     0.018629987f,
    0.06326597f,      -0.0008310661f,   0.02927656f,      -0.07300392f,
    0.03156459f,      0.096043974f,     -0.0706514f,      -0.019091435f,
    -0.022223644f,    -0.09892618f,     0.024223592f,     0.09269453f,
    -0.07475303f,     -0.016138878f,    0.076574035f,     -0.056035426f,
    -0.0070103724f,   0.05675641f,      -0.018174194f,    0.073987655f,
    0.09504812f,      -0.06857248f,     -0.0899029f,      -0.030557651f,
    -0.061947085f,    0.0022132886f,    0.08159051f,      0.051683888f,
    0.02038358f,      0.17409997f,      -0.0038788863f,   -0.07470913f,
    0.03962652f,      -0.030469412f,    -0.009616252f,    0.01862818f,
    -0.044701952f,    0.0011134855f,    -0.0011197625f,   0.0002804801f,
    0.00045874488f,   6.9484006e-05f,   -0.0012169213f,   0.00019439003f,
    0.0005519872f,    0.0007525513f,    -0.0009165411f,   -0.00074358686f,
    -0.0005027623f,   0.0012707291f,    -0.00040014647f,  0.0018891592f,
    0.00087336556f,   -0.00057214504f,  -0.0006271543f,   0.00052031f,
    0.0013993481f,    -0.0016474541f,   0.000677348f,     -0.0014390672f,
    -5.6369918e-05f,  0.00069650233f,   -0.0009332018f,   -0.002358838f,
    0.00067800976f,   -0.0021587773f,   0.000637111f,     -0.0008876072f,
    -0.00034927446f,  -0.00098505f,     0.0009845953f,    -0.0015154257f,
    -0.00014025078f,  0.0026105847f,    -0.0006298609f,   -0.0005694305f,
    0.0013559039f,    0.0014920343f,    -0.0013540749f,   2.8062161e-06f,
    0.00048254072f,   -0.00041581306f,  -0.00073693966f,  -0.0017634213f,
    0.00017263011f,   0.0009360493f,    0.0001821643f,    0.00020680428f,
    0.001989387f,     -0.000585554f,    -0.0011269997f,   -0.0002170442f,
    -0.0015882561f,   -0.00067836273f,  0.0014362454f,    -0.00090271415f,
    -0.0023117824f,   -0.0011867601f,   -0.0014500887f,   0.00023469517f,
    -0.00021923856f,  -0.00018788982f,  0.00048025214f,   0.0013267971f,
    -0.0009545549f,   0.0009784999f,    0.00047593046f,   -0.0006459071f,
    0.00066396483f,   0.0013779453f,    0.00168998f,      -0.0011343491f,
    -0.0014891978f,   -0.00058992166f,  -0.00070529594f,  -0.00080349395f,
    -0.0008974295f,   -0.0005873893f,   0.0019979496f,    0.0003886484f,
    -0.0010013188f,   0.0010642366f,    0.0007615703f,    0.000533127f,
    4.9322476e-05f,   -0.00049245195f,  -0.0005492162f,   -0.00095388753f,
    -0.0008067274f,   -0.0022148157f,   0.0006371724f,    -0.0007776755f,
    0.00013404866f,   -0.0007302353f,   3.6587633e-05f,   0.00068779994f,
    0.00028875936f,   -0.00021337946f,  -0.0018511259f,   -0.00015201858f,
    0.0002033753f,    -0.0008148921f,   -0.0012771746f,   7.2780516e-05f,
    0.0018562817f,    -0.00057950796f,  0.0021367199f,    0.00037966063f,
    -0.000254603f,    -0.00028426346f,  -0.000371127f,    8.817699e-05f,
    -0.001391056f,    -0.00087404327f,  -0.001334397f,    -0.00019509759f,
    -0.00012777129f,  0.0003881153f,    -0.0003140563f,   -0.00037136348f,
    -0.0019521547f,   0.0013454709f,    -0.0020607116f,   0.0021320782f,
    -0.0007246606f,   -0.0012057368f,   0.00048415357f,   0.0012451521f,
    0.0009222452f,    0.00042793743f,   -6.942075e-05f,   -0.00076833164f,
    -0.00013122457f,  -8.655225e-05f,   -8.890397e-06f,   0.00077058247f,
    -0.0006850814f,   0.0010243412f,    8.7393004e-05f,   -0.0013965679f,
    0.00061120006f,   0.00092403084f,   -0.0014342878f,   -0.00021028139f,
    0.0008153089f,    -0.0007925854f,   -0.00010381962f,  -0.0007340258f,
    -0.0012590338f,   -0.0001811065f,   -0.0017119716f,   -0.00044205767f,
    -4.5664274e-05f,  -0.00017785138f,  0.00028572648f,   -0.0008472528f,
    0.0012532157f,    0.0001405022f,    0.0015475287f,    -0.0010427615f,
    0.0007475834f,    0.002989371f,     0.0010094214f,    0.0012139933f,
    -0.0031357629f,   -0.0017270489f,   0.00022000611f,   -0.0017372133f,
    0.000635557f,     0.0015863387f,    0.0034089885f,    0.0012360273f,
    0.0023517278f,    -0.0013123326f,   0.00042639006f,   -0.002985161f,
    -0.0020501846f,   -0.0021869428f,   -0.0028350544f,   0.0015414306f,
    0.0020203644f,    0.0009336156f,    -0.00011486181f,  -0.0031627323f,
    -0.00041218285f,  -0.00212091f,     -0.0005692229f,   -0.0002835402f,
    0.0010228734f,    0.0023090749f,    0.0011307383f,    0.0007596202f,
    -0.0016434324f,   -0.002710241f,    -0.0015361955f,   -0.0022551275f,
    -0.00071403885f,  -1.4683435e-05f,  0.00099015f,      0.00094385166f,
    0.0011072074f,    -0.00010429093f,  -0.0009952072f,   -0.001003728f,
    -0.0029726578f,   -0.00089290243f,  -3.9986477e-05f,  0.00073888263f,
    0.0006245547f,    -1.1670942e-05f,  -0.0009585866f,   0.00022638247f,
    -0.00017370297f,  -3.6713667e-05f,  0.00051665056f,   0.0007188159f,
    -0.0013193438f,   2.457478e-05f,    -0.0004365152f,   -0.00043979753f,
    -0.000799337f,    -0.0005081442f,   -0.0033734094f,   -0.0010377391f,
    0.0003677813f,    0.00204177f,      -0.0007499931f,   -0.0006235298f,
    1.9584979e-05f,   0.00052948383f,   0.0019362327f,    -0.0032374156f,
    -0.002286586f,    0.0002092861f,    0.00032419479f,   -0.00051699847f,
    0.0011239422f,    0.00023473604f,   0.00065074244f,   0.0005158172f,
    0.00085872476f,   0.0007473339f,    -0.00025841637f,  -0.0013165824f,
    0.00043007763f,   -9.040193e-05f,   0.00117882f,      -0.00025176193f,
    0.00037236002f,   8.98326e-05f,     -0.00051327696f,  -1.6655695e-05f,
    0.00046613967f,   -0.00024955007f,  -0.0005246943f,   0.00063046877f,
    -0.00091849617f,  -0.0014047521f,   0.00019007974f,   -0.0011629502f,
    -0.001543919f,    0.00013563165f,   0.00062939536f,   -0.00055179815f,
    0.00043078605f,   -0.0013739519f,   -5.2912976e-05f,  -0.001253981f,
    -0.0010593991f,   -0.0009878211f,   -0.002223652f,    0.00082960684f,
    -0.0016500353f,   -1.0490934e-05f,  0.0002843562f,    -0.000980898f,
    -0.00025905028f,  0.0019392731f,    0.0008278421f,    -0.000564647f,
    -0.000806072f,    -0.00030645757f,  -0.0009889213f,   0.00044436316f,
    -0.0004204357f,   -0.0026952897f,   0.0010895334f,    -0.000115619725f,
    0.0005394463f,    -0.00058080023f,  -0.00073179917f,  -0.00069320755f,
    -0.0025039052f,   0.00049944944f,   0.002409348f,     0.00011227243f,
    0.000549059f,     0.0010854867f,    0.00010402601f,   0.00086772174f,
    0.0012150339f,    -0.0012397676f,   0.0005078148f,    0.001242832f,
    0.00022203839f,   0.00046932965f,   0.0008965279f,    0.00094699423f,
    -0.0002011579f,   0.00027077112f,   -0.0018706031f,   0.00048456813f,
    -0.0016372034f,   0.00026659315f,   -2.5258643e-05f,  -0.0007849052f,
    -5.2908374e-05f,  0.00039768845f,   -0.00029644524f,  -0.00097564963f,
    -0.0014156109f,   0.0003856482f,    -0.0012126049f,   -0.0009042629f,
    3.3609296e-05f,   -0.0018874987f,   -0.00015334875f,  -0.0018861304f,
    0.0017776829f,    0.00016214025f,   0.00023579506f,   8.009989e-05f,
    0.0013927384f,    4.347561e-05f,    0.0011868074f,    0.00084080047f,
    -0.002049166f,    -0.00014228756f,  -0.00064346107f,  0.0016842157f,
    -0.0012946603f,   0.00047094646f,   -0.00044661094f,  -0.00092887116f,
    0.00017953408f,   -0.0014245819f,   -0.0007556356f,   0.0016061862f,
    -0.0005091766f,   -0.00045300095f,  -0.0005541218f,   0.0013322398f,
    0.0020650444f,    -0.001100328f,    -0.00054487365f,  0.0023095596f,
    -0.0003353828f,   -0.0018162044f,   0.0003593528f,    -0.00090357044f,
    -0.0021022279f,   0.00013052044f,   0.0005287351f,    -0.0010279424f,
    -0.0017553223f,   -0.0020967717f,   0.0013198802f,    0.0006331317f,
    0.0009742425f,    -0.0010674269f,   0.0007410092f,    -0.0011616928f,
    -0.0010435464f,   -0.0003143471f,   -8.537544e-05f,   -0.0010591731f,
    0.00044851692f,   3.4783563e-05f,   4.1907777e-05f,   0.0017519649f,
    -0.0014920301f,   0.00069290755f,   0.00014945838f,   -0.00073776604f,
    -0.00092335936f,  -0.0018209881f,   -0.0011583733f,   -0.0020634104f,
    -0.00029677327f,  0.00028264197f,   0.0003014251f,    -0.0006948531f,
    -0.00020492024f,  -0.0003761192f,   0.00095228007f,   -0.00020505433f,
    -0.00018598374f,  0.0002603781f,    0.00035215178f,   -0.00344407f,
    -0.0018377675f,   2.3874636e-06f,   0.0006360554f,    -0.00097108574f,
    -7.977831e-06f,   -0.001699639f,    -0.0024402179f,   -0.0001274188f,
    0.000587065f,     -0.00089721655f,  -0.00043765662f,  -0.00080474146f,
    7.705861e-05f,    9.641e-05f,       -0.0012318946f,   0.002631073f,
    -0.00041180712f,  -0.00072095485f,  -0.0011394982f,   0.00056929403f,
    -0.00045051955f,  -0.00025276365f,  0.0014583075f,    -0.00055182504f,
    -0.001150962f,    -0.0008050539f,   -0.0014693359f,   -0.0019164368f,
    0.00058400567f,   0.000865913f,     4.3042586e-05f,   0.0016309094f,
    -0.0017815963f,   -0.0015453101f,   0.0006758601f,    0.0017389064f,
    -8.210347e-05f,   -6.2855164e-05f,  0.00074299565f,   0.00015477145f,
    -0.0006847583f,   -0.0008278151f,   0.0002104934f,    -0.00074400235f,
    -0.001622142f,    -5.5592427e-05f,  0.00027263156f,   0.00014730646f,
    0.0009805592f,    -0.0005271365f,   0.0003343402f,    -0.0012365932f,
    0.0024696994f,    0.00024832657f,   -0.0007031608f,   -0.0007623663f,
    0.0002486954f,    -0.0012470919f,   -0.00042475422f,  -0.00083854585f,
    -0.00032578266f,  0.00068401266f,   -0.00036420574f,  0.00016933643f,
    -0.0014108269f,   0.00086130213f,   -2.7615646e-05f,  0.0009708671f,
    -0.000617518f,    0.0007720505f,    -0.00018883792f,  0.0010553147f,
    0.00023790986f,   0.00042052192f,   0.0010172834f,    -0.0005163013f,
    0.00017585824f,   -0.00084564916f,  -2.4885056e-05f,  -0.0032960866f,
    -0.0011469047f,   -9.369684e-05f,   -0.0014493244f,   -0.096231505f,
    0.104847424f,     -0.063151374f,    0.039818924f,     -0.0014363163f,
    -0.15151703f,     0.03972434f,      0.053064365f,     -0.07438028f,
    0.013472522f,     -0.030749837f,    0.026671296f,     -0.10884711f,
    0.12398511f,      0.24107839f,      -0.067726016f,    -0.06766591f,
    0.15236033f,      0.13828368f,      -0.09877053f,     -0.040509146f,
    0.21814708f,      -0.008984212f,    -0.2285983f,      -0.020129912f,
    0.14800674f,      -0.252105f,       -0.0051658633f,   -0.071010314f,
    -0.06273973f,     0.1772273f,       -0.067051575f,    -0.31079158f,
    0.10386946f,      0.42850062f,      -0.009981996f,    -0.08810594f,
    0.22323324f,      0.17002425f,      -0.242571f,       -0.23249017f,
    0.14487782f,      -0.011191469f,    -0.33017063f,     -0.09063249f,
    -0.14185572f,     0.041417982f,     -0.04946373f,     -0.36716077f,
    0.067282766f,     0.6863768f,       0.40520087f,      -0.2974955f,
    0.107406385f,     0.33181104f,      -0.050702058f,    -0.18288808f,
    0.08517965f,      0.26716778f,      0.11542658f,      -0.06862573f,
    -0.24572831f,     0.16060846f,      -0.28891355f,     -0.054239046f,
    0.1738381f,       0.36030352f,      -0.18709353f,     -0.32287633f,
    -0.17500734f,     -0.19725677f,     0.019927936f,     0.13906233f,
    0.015304188f,     -0.040367726f,    -0.17014822f,     -0.12203854f,
    0.22162852f,      0.003546524f,     -0.056758963f,    0.13977973f,
    -0.0009995913f,   -0.0018199908f,   -3.204034e-05f,   0.0010188516f,
    0.002281759f,     0.0005225749f,    -0.0007992828f,   -1.5113362e-05f,
    0.0004997087f,    -0.0011138568f,   5.365775e-05f,    -0.00059946964f,
    -0.00037660386f,  9.2674636e-05f,   -0.00016172814f,  -0.00077144546f,
    -0.0011691151f,   -0.00063464383f,  -0.0009605013f,   0.0005671676f,
    -0.00040419766f,  0.00074659556f,   0.0007372795f,    -0.0002457469f,
    -0.0020088898f,   0.00079984305f,   0.00017297892f,   0.00011949692f,
    0.0020308874f,    -0.0012711267f,   0.001740016f,     -0.0009765626f,
    -0.0012424976f,   -0.0011190899f,   0.0006954757f,    -0.0008800528f,
    0.0007153828f,    7.409717e-05f,    -0.0007912391f,   0.00077131245f,
    0.0010325011f,    0.0013992479f,    -0.0017962775f,   -0.0007862639f,
    7.117007e-05f,    -0.0012064576f,   0.0013150177f,    -5.595728e-05f,
    -0.00051608216f,  5.7979163e-05f,   -0.00068400113f,  0.0006929344f,
    -0.0006910475f,   -0.00031766464f,  0.0005550744f,    -0.00051067636f,
    -0.00090974034f,  -0.0003868043f,   -0.0005443727f,   -0.0003146364f,
    0.00019219621f,   -0.0007658776f,   0.00071428966f,   0.00065835356f,
    -0.0003880191f,   0.00032448387f,   -0.00019720595f,  0.0005076672f,
    -0.0004144108f,   0.00032692487f,   0.00016967565f,   0.00044187738f,
    -0.00072831125f,  -0.0014942107f,   0.00012876459f,   0.000205441f,
    -0.0016892614f,   0.0007097276f,    0.0010939199f,    -0.00060686853f,
    -0.0010073768f,   -0.0012665025f,   0.016754199f,     0.26304856f,
    0.13983741f,      -0.113880195f,    -0.10658132f,     -0.06519941f,
    0.07726432f,      0.017944798f,     0.0069109127f,    -0.07727133f,
    -0.24356148f,     -0.30491588f,     0.0015241295f,    0.196912f,
    -0.11370118f,     -0.2005274f,      0.055013888f,     0.021108065f,
    0.11378796f,      0.1282255f,       -0.12032645f,     -0.08205732f,
    0.18633963f,      0.080315396f,     0.039802875f,     0.1026429f,
    -0.06908309f,     -0.067398965f,    0.0150765665f,    0.060801167f,
    -0.02570681f,     -0.09290606f,     -0.17364827f,     -0.044257075f,
    -0.13037622f,     0.11020896f,      0.020617492f,     -0.1715934f,
    0.13234134f,      0.3949457f,       0.22673208f,      -0.13186288f,
    0.074322745f,     0.22734343f,      -0.043330006f,    0.05337625f,
    -0.106625415f,    -0.08419435f,     -0.013403807f,    -0.08028655f,
    -0.28355646f,     -0.07103693f,     -0.023827288f,    -0.046279274f,
    0.043517627f,     0.06323342f,      0.0146683995f,    -0.07495369f,
    -0.1231776f,      -0.0063520228f,   0.28992406f,      -0.10756435f,
    0.04353008f,      -0.05982633f,     -0.10739218f,     0.11630451f,
    0.020550797f,     -0.16120344f,     0.01764646f,      0.2959385f,
    -0.07455079f,     -0.060867433f,    0.062209602f,     -0.07078735f,
    0.14284056f,      0.016841857f,     0.0082178265f,    0.15606606f,
    0.014022826f,     -0.17542233f,     -0.0015402404f,   0.00025565238f,
    -0.00067233754f,  0.00044707538f,   -9.546261e-05f,   -3.5591096e-05f,
    0.0011325387f,    -0.00026728175f,  -0.0018261182f,   0.0014168688f,
    3.492621e-05f,    0.000110634f,     0.00025745798f,   -0.00025572276f,
    -0.002036772f,    -8.944633e-05f,   -0.0012297307f,   0.00079575815f,
    -0.0012314687f,   0.0010770675f,    -0.0005917697f,   -0.0021297608f,
    -0.0003117171f,   0.001082791f,     0.0002682326f,    -0.0011721514f,
    0.0002586199f,    -0.002996355f,    0.0020981964f,    0.000717333f,
    0.0018209401f,    -0.001795169f,    0.000189011f,     0.00057388167f,
    -0.0011677952f,   -0.0008625764f,   -0.002416106f,    0.00042315052f,
    -0.0017523717f,   0.0010439404f,    -5.785029e-05f,   -0.0013305781f,
    0.00028503395f,   -0.00041883f,     8.289177e-05f,    0.00061704183f,
    0.0006563258f,    0.0001156717f,    -0.000114269875f, 0.0010820205f,
    0.0016165241f,    0.00018961821f,   0.0019755263f,    -0.0015524613f,
    -0.0017105497f,   0.0011875539f,    -0.0002842131f,   -0.0014970755f,
    -0.00050152966f,  -0.00070495857f,  -0.00067681534f,  8.989969e-05f,
    -0.00017749393f,  -0.0013356967f,   -0.0010257022f,   0.00025018034f,
    0.0016102698f,    0.00075776514f,   -0.000938084f,    -0.00034315226f,
    0.00015070832f,   -0.001430824f,    -0.00055653014f,  -0.00075340556f,
    2.647792e-05f,    -6.8593154e-06f,  0.00040427776f,   -0.00093589263f,
    -0.00047378137f,  -0.0008457186f,   5.3760417e-05f,   -0.15451224f,
    0.19095458f,      0.20473194f,      0.026090022f,     0.09018351f,
    -0.03866923f,     -0.2947197f,      0.11171706f,      0.12668751f,
    -0.08547264f,     -0.11372413f,     -0.45456392f,     -0.16958763f,
    0.08168758f,      0.38936618f,      0.3428003f,       -0.33089024f,
    -0.1778607f,      0.062101018f,     0.17865935f,      -0.10510438f,
    -0.06503064f,     -0.24637133f,     -0.22606316f,     0.19956805f,
    0.20032804f,      0.091040626f,     0.2066051f,       0.029972387f,
    0.21238667f,      0.3268944f,       -0.13860951f,     -0.27889463f,
    -0.30921814f,     -0.00034688276f,  -0.14993234f,     -0.06072603f,
    -0.21059197f,     -0.044425827f,    0.09012394f,      -0.22182731f,
    -0.07031315f,     -0.051646624f,    0.11668866f,      0.04449345f,
    -0.022964412f,    0.13738543f,      -0.1268226f,      0.20749593f,
    0.5986675f,       0.44717783f,      0.12741205f,      -0.06192498f,
    -0.069916755f,    -0.040256307f,    0.09093724f,      -0.16429462f,
    -0.16906933f,     0.07666179f,      -0.15648046f,     -0.1333154f,
    -0.016347619f,    0.047096144f,     0.034295507f,     -0.083561204f,
    0.16966856f,      -0.0669508f,      -0.17493396f,     -0.2484899f,
    0.016458018f,     0.13108166f,      0.02897117f,      -0.04448649f,
    -0.018285748f,    0.11338124f,      -0.110785924f,    0.09166978f,
    0.17844494f,      -0.03845814f,     0.024416048f,     -0.028454373f,
    0.0648932f,       0.03015817f,      0.06663703f,      0.01555638f,
    -0.008408942f,    -0.010150862f,    -0.04535889f,     -0.071089506f,
    0.0089017935f,    0.03836471f,      0.008252308f,     0.057061534f,
    0.02177751f,      0.021049228f,     0.039813843f,     0.019147387f,
    -0.016650844f,    -0.0001233825f,   -0.05576664f,     -0.008446863f,
    0.008782738f,     -0.012964258f,    0.03062039f,      0.01987045f,
    -0.014466973f,    -0.054479945f,    0.008349284f,     -0.04714462f,
    0.036334384f,     0.020698098f,     -0.0063914903f,   0.093982875f,
    0.036466327f,     -0.016738135f,    -0.0662639f,      -0.021750694f,
    -0.02035997f,     0.0033441465f,    0.014848345f,     0.024313975f,
    0.13401915f,      0.047886606f,     0.0052725878f,    -0.005566222f,
    -0.011406347f,    0.010810547f,     -0.008090125f,    -0.021758836f,
    -0.052334014f,    0.017572219f,     -0.031520873f,    0.005230196f,
    0.045618445f,     -0.025735915f,    0.092209905f,     0.056659717f,
    0.033203486f,     0.0097129345f,    0.034622952f,     -0.020982016f,
    -0.0028616781f,   0.0023921072f,    -0.050432783f,    0.10869601f,
    0.02977902f,      0.047894828f,     0.07702137f,      0.049371872f,
    0.004437381f,     0.026964117f,     -0.020770194f,    -0.031368338f,
    -0.0027126474f,   -0.051467244f,    0.0021101509f,    0.04871847f,
    0.050533365f,     0.056156278f,     0.12524974f,      0.08561249f,
    0.010004138f,     0.048813064f,     -0.040069226f,    -0.02489537f,
    0.10931528f,      0.026437178f,     -0.18237269f,     0.06956561f,
    0.046132937f,     0.06295172f,      -0.0011143249f,   -0.12401521f,
    -0.07959514f,     -0.0856738f,      0.29110083f,      0.07841301f,
    -0.15799834f,     -0.18638828f,     0.008791344f,     -0.0057859845f,
    0.3117456f,       0.17794767f,      -0.19377553f,     0.10011559f,
    0.09263832f,      0.22075343f,      -0.1329936f,      0.021534152f,
    -0.25834543f,     0.07808666f,      -0.24750242f,     -0.4627849f,
    0.090576276f,     0.056545373f,     0.28242812f,      -0.21025048f,
    0.09985244f,      0.028137872f,     0.13125561f,      0.29870033f,
    -0.17317332f,     0.0654257f,       -0.029810926f,    0.114518985f,
    0.12770537f,      0.06928875f,      0.0840546f,       -0.28732312f,
    0.13365082f,      -0.045149498f,    -0.16095977f,     -0.43042094f,
    -0.08290921f,     0.30299392f,      -0.23473845f,     0.12784703f,
    0.04043154f,      0.054106656f,     0.23238303f,      0.18373284f,
    -0.25010836f,     -0.055614866f,    0.117932945f,     -0.18257892f,
    -0.1893115f,      -0.01187562f,     -0.15526539f,     -0.114405565f,
    0.12402391f,      0.15735427f,      -0.0077724657f,   0.06703274f,
    0.18275802f,      0.120895356f,     -0.07851406f,     0.11984455f,
    0.03476141f,      -0.048246842f,    -0.10134965f,     -0.123041905f,
    0.05240076f,      -0.055737115f,    -0.16772988f,     0.11109595f,
    -0.010658841f,    -0.1918969f,      -0.056384567f,    0.05707361f,
    -0.112511635f,    -0.054105755f,    0.039645508f,     0.28675842f,
    -0.06264916f,     0.18962608f,      0.11861972f,      0.054832295f,
    0.13196602f,      0.06443878f,      0.12913924f,      -0.033468783f,
    -0.09380506f,     -0.39508915f,     -0.045497686f,    -0.05251621f,
    0.079533115f,     -0.0980559f,      -0.14163537f,     -0.12616393f,
    0.030344693f,     0.045076687f,     0.3311438f,       0.27322668f,
    -0.20558588f,     0.00787129f,      0.026922174f,     0.21212669f,
    0.006659271f,     0.07345736f,      -0.22250953f,     0.012361195f,
    -0.23675753f,     -0.3587865f,      -0.051800575f,    -0.28915828f,
    -0.11290645f,     0.14510258f,      -0.22573742f,     0.2253471f,
    0.17198265f,      0.103293695f,     0.48186585f,      0.65362656f,
    0.13932094f,      -0.12812263f,     0.2918586f,       -0.011542456f,
    -0.056727126f,    -0.24614257f,     -0.25707218f,     0.13793144f,
    -0.13671821f,     -0.029103154f,    -0.009799653f,    -0.2007678f,
    -0.015641231f,    -0.11022096f,     0.15645686f,      -0.122900136f,
    -0.07961051f,     -0.36028215f,     0.044074144f,     0.23830715f,
    -0.04626669f,     0.19480437f,      0.07021072f,      0.0115125915f,
    -0.014199886f,    0.10593896f,      -0.115548626f,    0.07183085f,
    -0.15567504f,     -0.015137304f,    -0.07752346f,     -0.0010569588f,
    -0.00011932791f,  -0.0011503884f,   0.0010949814f,    -0.0004188964f,
    0.00066117104f,   0.00068706094f,   -0.00047927108f,  0.0007725628f,
    -0.00013302245f,  -0.00022430284f,  -0.0011843696f,   -0.0016817375f,
    0.0008879866f,    -0.0007197566f,   -0.0026471221f,   -0.00035948743f,
    -0.0006840709f,   -0.000479323f,    -0.0003340373f,   -0.00018967413f,
    -0.0019072172f,   0.0022352175f,    -0.0017468531f,   6.825732e-05f,
    0.00010220736f,   -0.0016980439f,   -0.0011177853f,   -0.00035529124f,
    -0.00017950012f,  0.001997568f,     0.0007199863f,    0.0019489218f,
    -0.0014096436f,   -0.00018343085f,  -0.0011374281f,   -0.00012807928f,
    -0.0007536894f,   -0.00018412877f,  -0.0004588939f,   0.00011560072f,
    0.0005447587f,    0.0010002337f,    -0.00035392452f,  0.0011272527f,
    -0.0010926933f,   -0.00033766948f,  0.00040509773f,   0.0014269508f,
    -0.0005572892f,   -0.0008279935f,   0.0011004119f,    0.00060566544f,
    0.00034190633f,   0.0007174558f,    0.001560462f,     -0.00029264583f,
    -0.00012326946f,  -0.00052696164f,  -1.481618e-05f,   -0.000662047f,
    -0.00077355205f,  -0.0006492136f,   -0.00086103426f,  0.0018013717f,
    0.00064414524f,   -0.000443558f,    -0.000899292f,    -0.00024224863f,
    0.0010501363f,    -0.0011598471f,   -0.00065701053f,  0.0011456088f,
    0.00048621694f,   -0.0018411156f,   -0.0013611651f,   -0.00026907714f,
    -0.000564056f,    -0.0013652503f,   -1.7089094e-05f,  -3.3554003e-05f,
    -0.21049039f,     0.12132132f,      0.029365696f,     -0.117138445f,
    -0.027834794f,    -0.054204922f,    0.03897714f,      0.16722542f,
    0.11553542f,      0.16737561f,      0.05393429f,      -0.014358943f,
    0.051431034f,     0.087548435f,     -0.029643053f,    -0.008091828f,
    -0.042589437f,    -0.24425545f,     -0.19025211f,     0.13267463f,
    0.07090611f,      -0.12849692f,     -0.114979744f,    -0.14561316f,
    -0.062827356f,    0.037712615f,     -0.030533005f,    0.002242583f,
    0.080746576f,     0.05704525f,      -0.07564389f,     0.015597454f,
    0.15354526f,      0.096324906f,     0.14457925f,      0.09841959f,
    0.13968202f,      -0.11876171f,     -0.1822698f,      0.022941625f,
    0.095030665f,     -0.03277857f,     -0.21077323f,     -0.0021120594f,
    -0.0381466f,      0.010349348f,     -0.0073541575f,   -0.07239491f,
    0.10508517f,      0.18381675f,      -0.048366293f,    -0.18059269f,
    0.12591232f,      0.10520373f,      0.034999773f,     0.18793611f,
    -0.047916353f,    -0.33946872f,     -0.2302447f,      -0.02846822f,
    0.054626998f,     0.0032924155f,    -0.14790957f,     -0.0417905f,
    0.087065674f,     0.020350123f,     -0.04749697f,     -0.07303875f,
    -0.036168f,       0.09759104f,      0.075103365f,     0.13184534f,
    -0.06964279f,     0.086619474f,     0.08370255f,      0.16909434f,
    0.050515123f,     -0.124340795f,    -0.020950507f,    0.049961697f,
    -0.09553867f,     0.09808866f,      -0.0421742f,      0.11261221f,
    -0.09793189f,     -0.009376952f,    0.10382681f,      -0.31479898f,
    0.041666184f,     -0.007494061f,    0.0051753805f,    -0.44516096f,
    0.07864353f,      0.35873914f,      -0.003262946f,    0.1490227f,
    0.22528133f,      0.06613347f,      -0.0052773887f,   0.084566765f,
    -0.09523081f,     0.029389927f,     0.040525492f,     -0.23032792f,
    -0.11449329f,     0.1439979f,       0.25970817f,      -0.069264844f,
    0.1986545f,       -0.20608409f,     -0.168584f,       0.08890512f,
    0.044428054f,     -0.3010995f,      -0.4741572f,      0.14445134f,
    -0.2126029f,      0.21730554f,      -0.39368203f,     0.16686215f,
    0.4914481f,       0.25179303f,      0.020509616f,     -0.064097025f,
    0.25522953f,      0.10250973f,      -0.028641317f,    -0.50983363f,
    0.20008643f,      -0.014031358f,    -0.24628593f,     -0.03655812f,
    0.04390503f,      -0.24576335f,     -0.046158556f,    0.01860714f,
    0.00041071457f,   0.25003466f,      -0.23970988f,     -0.048644755f,
    0.063399225f,     0.19723774f,      0.1495488f,       0.057878304f,
    -0.09056226f,     0.19932805f,      0.1678529f,       -0.14021966f,
    0.18159927f,      -0.16833806f,     -0.18337807f,     0.004240003f,
    -0.16899087f,     0.07772572f,      -0.300228f,       0.09108153f,
    -0.058463488f,    0.10295788f,      -0.023347486f,    0.08548327f,
    -0.06645601f,     0.156894f,        -0.013950671f,    0.14006302f,
    0.103626534f,     0.057480488f,     -0.035415344f,    -0.14677656f,
    -0.0029044042f,   -0.038839202f,    0.052474126f,     -0.06640617f,
    -0.020092648f,    -0.46386313f,     -0.30315164f,     0.14792289f,
    0.14735998f,      0.10991435f,      0.054948963f,     -0.11660436f,
    0.1001769f,       0.1322821f,       0.16288564f,      0.2755964f,
    0.2845847f,       0.25922486f,      0.123903506f,     -0.22476986f,
    0.117865324f,     -0.132201f,       0.019541752f,     0.18495215f,
    -0.29292935f,     -0.5955058f,      -0.6024949f,      -0.18879005f,
    -0.10200956f,     0.026657283f,     0.016031597f,     0.20258607f,
    0.25504315f,      0.108170435f,     0.27418202f,      -0.003829843f,
    0.101490594f,     0.14858447f,      -0.09560363f,     -0.1466663f,
    -0.31975532f,     -0.47320247f,     -0.17723802f,     0.21804087f,
    0.19206536f,      0.21338885f,      0.0029941255f,    0.12964514f,
    0.13641602f,      0.023268448f,     -0.10686002f,     0.21463102f,
    0.03751311f,      -0.14985856f,     -0.04363645f,     -0.1407964f,
    0.08981011f,      -0.19653164f,     0.21892318f,      0.31636363f,
    0.4429552f,       -0.06580222f,     -0.20929275f,     -0.067167304f,
    -0.011130502f,    -0.060498368f,    0.17359021f,      -0.11022381f,
    -0.26505905f,     -0.17634818f,     -0.08740303f,     0.2281432f,
    0.11242004f,      0.011583977f,     -0.036959086f,    -0.08051258f,
    0.03413045f,      0.020185938f,     0.032503646f,     -0.05675345f,
    -0.22755021f,     0.014012614f,     0.15816405f,      -0.0946519f,
    0.10396259f,      0.05335276f,      -0.06670496f,     0.021227216f,
    0.31650817f,      -0.019803531f,    -0.0975885f,      0.0751855f,
    -0.10593144f,     -0.075981125f,    0.17637503f,      0.024622338f,
    -0.061207455f,    0.15002695f,      -0.16977781f,     -0.023900222f,
    0.10342928f,      0.056688108f,     -0.16326775f,     0.084767215f,
    -0.17347369f,     -0.22374482f,     -0.02916521f,     -0.109666474f,
    0.1251722f,       -0.11273764f,     0.102705985f,     -0.08524307f,
    0.49501407f,      -0.03410574f,     -0.40578488f,     -0.09272392f,
    -0.18247631f,     0.17320168f,      0.13147478f,      -0.0038696087f,
    -0.035700124f,    0.701622f,        0.20242898f,      -0.38785088f,
    0.11948064f,      -0.16032521f,     -0.144174f,       0.11564136f,
    -0.2669928f,      -0.21926832f,     0.35552096f,      0.059543382f,
    -0.19952008f,     0.10670266f,      -0.023357881f,    0.009611001f,
    0.042931113f,     -0.057917032f,    -0.3258998f,      0.06420989f,
    -0.11756125f,     0.05695319f,      0.06770617f,      -0.048781503f,
    0.1706744f,       -0.0103712f,      0.12521602f,      0.0456654f,
    0.3343424f,       -0.114806935f,    -0.1974372f,      0.150496f,
    -0.13802375f,     -0.07210364f,     0.030029353f,     -0.037062917f,
    0.039393786f,     -0.23628199f,     0.03345371f,      -0.013991202f,
    -0.050544783f,    -0.015119356f,    -0.026974915f,    0.014346917f,
    0.08018133f,      0.22023629f,      0.06720942f,      0.015866054f,
    0.11437361f,      0.032059792f,     -0.017130418f,    -0.010584226f,
    -0.28184482f,     -0.118456855f,    -0.18145181f,     0.045499895f,
    0.06611193f,      0.25537384f,      0.1269979f,       0.07849577f,
    0.1941643f,       -0.011851524f,    0.17919172f,      -0.16963504f,
    -0.115479596f,    -0.19320947f,     -0.22658744f,     -0.14010993f,
    -0.043412987f,    0.04825629f,      -0.020221386f,    -0.025581691f,
    0.09596209f,      0.07362938f,      0.023214526f,     -0.11330754f,
    0.07633958f,      0.093354434f,     0.05787236f,      0.11146388f,
    0.10320734f,      0.09972688f,      0.03044343f,      0.10441127f,
    -0.036306515f,    -0.024392854f,    -0.12362377f,     -0.18422562f,
    -0.15097342f,     -0.20117345f,     0.120268635f,     -0.025150498f,
    0.14299181f,      0.05642174f,      0.029503888f,     0.14781424f,
    0.07158077f,      0.05634389f,      -0.018330285f,    -0.16933647f,
    -0.23443997f,     -0.017875906f,    -0.0064813443f,   -0.034399465f,
    0.16573407f,      0.07892756f,      0.09992555f,      -0.0115564875f,
    0.16742346f,      -0.06860155f,     -0.03065809f,     0.07158921f,
    -0.005626906f,    -0.09347712f,     -0.06864652f,     0.07023963f,
    -0.07934594f,     -0.00064287265f,  0.0004883317f,    0.00035403259f,
    0.00081151654f,   0.0006571127f,    0.00041666787f,   -0.00086038234f,
    0.0001900719f,    -0.0007043907f,   0.0008286831f,    -0.0013949849f,
    -0.0006009202f,   -0.00082067883f,  -0.0005576505f,   -0.00040472447f,
    -0.00027313447f,  -0.00028334445f,  0.0013878887f,    0.00023154487f,
    0.0010704207f,    -0.0006509282f,   0.00012547745f,   -0.00030320548f,
    0.0007429635f,    0.00058653275f,   0.00051762315f,   -0.000753791f,
    -0.0018874444f,   -0.0008026677f,   0.0008491868f,    0.0018599306f,
    -0.0011441383f,   0.0005058693f,    0.0018451298f,    -0.0024096803f,
    0.0003023534f,    1.6437096e-05f,   -0.0016029753f,   0.0006561075f,
    0.00024549794f,   -0.00028882222f,  -0.0004160699f,   -0.000981461f,
    -0.00066136953f,  0.00081262295f,   -0.00016825306f,  -0.00044055213f,
    -0.000825726f,    0.00014283165f,   0.0013927987f,    -0.0006570022f,
    -0.001200485f,    0.00011597235f,   -4.0973333e-05f,  -0.0006579493f,
    -0.001788819f,    -0.00034246634f,  0.000116274765f,  -0.0015090851f,
    -6.259273e-05f,   0.0011954504f,    0.00033649427f,   0.000612969f,
    0.0008567074f,    0.0007649982f,    0.00078546803f,   -0.0013632898f,
    0.0006838894f,    0.0019097343f,    0.00086293544f,   -0.0006856461f,
    0.000775416f,     -0.0010888644f,   0.0014632919f,    -0.0020133106f,
    0.0001631458f,    -0.0010324733f,   0.00033582706f,   -0.00038609616f,
    -0.00049237773f,  -0.0016131643f,   -0.00044564228f,  0.0010814889f,
    0.0005628558f,    -0.00044855007f,  -0.0004132992f,   0.0004335811f,
    0.0006361533f,    0.00072106736f,   -0.0005090286f,   -0.001974272f,
    0.0011092027f,    -0.0002474093f,   0.0007939984f,    0.0010134715f,
    0.00046002874f,   -0.00085181196f,  -0.0008610775f,   0.00046291473f,
    0.00037765264f,   -0.0012405084f,   -0.0013560753f,   -0.0015983192f,
    -0.002760405f,    -0.00088564435f,  -0.0021812522f,   0.0005053703f,
    -0.0006051689f,   -0.00041868823f,  -0.001890453f,    0.0008870303f,
    0.0011944085f,    0.0012414085f,    -0.0012548141f,   -0.0009206035f,
    0.0006136148f,    -0.00044330812f,  0.00060655986f,   0.00038990565f,
    -0.0012466159f,   0.0008100385f,    -6.510643e-05f,   -0.0009399617f,
    0.00051372754f,   -0.001236492f,    -4.0653405e-05f,  -0.0009114352f,
    0.00063949305f,   0.00019928912f,   -0.0014466722f,   -0.0013846796f,
    0.00056179665f,   0.0025162317f,    -3.009584e-06f,   0.00081460644f,
    0.0019322566f,    -0.0006341897f,   -0.00018798155f,  -0.0003901624f,
    0.00051888626f,   0.0018493204f,    0.0004188966f,    -0.00066171214f,
    -0.00044925578f,  0.00061351113f,   0.0007421412f,    -0.0005494406f,
    -0.0006980114f,   -0.00076419977f,  -2.5958909e-05f,  0.00029733207f,
    0.0014494009f,    -0.00034491604f,  -0.00037503743f,  0.0016391781f,
    -0.001431672f,    -0.000295798f,    -0.0016166728f,   -0.00080178876f,
    -0.0015348978f,   0.0005996476f,    -0.0016865015f,   -0.00037824307f,
    -0.00095704757f,  -0.0011277267f,   0.0018043336f,    -0.001219336f,
    -0.0002596147f,   -0.00051346025f,  0.0004996839f,    -0.0011389672f,
    -0.0002948046f,   0.001517528f,     -0.0007555887f,   0.0009787779f,
    -0.00032182763f,  0.00033165747f,   0.00043391399f,   -0.0019948366f,
    0.00017164096f,   -0.00019136845f,  -0.0013574235f,   0.00031628073f,
    0.0010474605f,    -0.0010326545f,   0.0010362851f,    -0.00071564753f,
    -0.0012617541f,   0.00073116226f,   0.00055482687f,   0.0010243836f,
    -0.00015997686f,  -0.000373712f,    0.0010334982f,    -0.001157394f,
    -0.00091143546f,  -0.00015830636f,  -0.00037357458f,  -7.8790516e-05f,
    -0.0011626767f,   -3.2057e-05f,     0.0011860981f,    -0.00091545214f,
    -0.001557901f,    -0.00066129596f,  5.9015576e-05f,   8.9238834e-05f,
    0.00097328826f,   0.00032397645f,   0.00041627957f,   0.0009620821f,
    -5.044361e-05f,   -0.0008907018f,   -0.00074318715f,  9.633139e-05f,
    0.00024185509f,   0.00052249595f,   -0.00066322944f,  -0.0008217195f,
    -0.0005752367f,   0.00031895252f,   0.0002101064f,    0.00084127893f,
    -0.00063628185f,  -0.0014072611f,   0.00012794735f,   -0.0010524755f,
    0.00041546058f,   0.00048592497f,   -0.00087857206f,  -0.00011088412f,
    -1.29386935e-05f, -0.00050557463f,  0.00022229699f,   -4.7033518e-05f,
    -0.00023998097f,  0.0007468517f,    -0.0005776739f,   0.00073984714f,
    -0.00020299216f,  3.6905283e-05f,   1.2206624e-05f,   0.00027368235f,
    -0.03736849f,     0.043655276f,     0.061554603f,     -0.17161728f,
    -0.0010409214f,   -0.04572901f,     0.044170175f,     0.07768265f,
    -0.020297185f,    -0.036445905f,    0.056331147f,     -0.05258964f,
    -0.063965976f,    0.193136f,        -0.039137438f,    -0.021271653f,
    -0.07504606f,     -0.055963337f,    0.06264857f,      0.01632038f,
    0.1331129f,       -0.023342447f,    0.26079944f,      0.13220032f,
    -0.012500042f,    0.041588824f,     0.16334477f,      -0.13021895f,
    -0.07849556f,     -0.022617966f,    -0.32796267f,     -0.2588888f,
    -0.2079939f,      -0.12068225f,     -0.11035465f,     -0.12220874f,
    -0.030918978f,    0.33149955f,      0.1955451f,       0.046737976f,
    0.1616291f,       0.038881477f,     0.2579796f,       0.14620492f,
    0.0076228026f,    -0.10936262f,     -0.16709317f,     -0.29867414f,
    -0.31482562f,     -0.17730217f,     -0.2736353f,      -0.09459452f,
    0.0045729894f,    -0.090381406f,    0.24828805f,      0.004442172f,
    0.29559934f,      0.26263443f,      -0.021756025f,    -0.10917024f,
    -0.019598924f,    0.21142554f,      -0.016222991f,    -0.04402847f,
    -0.31911346f,     0.050834578f,     0.44276458f,      0.34853658f,
    0.030037722f,     -0.12291555f,     -0.06384014f,     0.045270987f,
    0.08414128f,      0.14136493f,      -0.23514254f,     -0.107297614f,
    0.08654502f,      -0.11958474f,     0.091832384f,     0.0128784f,
    -0.017050486f,    -0.0060391547f,   0.03949546f,      -0.011575731f,
    0.0062798574f,    -0.15892781f,     -0.13559674f,     -0.031758286f,
    0.23796052f,      -0.10436321f,     -0.052519165f,    0.06477516f,
    -0.12236673f,     0.10019575f,      0.2222731f,       0.12823653f,
    -0.17412245f,     -0.11293517f,     0.12766454f,      0.037720874f,
    0.10460034f,      -0.01052339f,     -0.0848405f,      -0.08106663f,
    0.016814621f,     0.14951833f,      0.21620816f,      -0.14440823f,
    0.008106019f,     -0.057047836f,    0.08020182f,      0.027755845f,
    -0.1661386f,      -0.31643152f,     -0.09622112f,     0.19705041f,
    -0.092362866f,    0.028923651f,     0.122155145f,     -0.17038926f,
    -0.06258074f,     0.23277837f,      -0.030292595f,    -0.103712775f,
    0.112776004f,     0.05529457f,      -0.2534861f,      0.31957844f,
    -0.2287681f,      -0.28525746f,     0.19749993f,      0.123943835f,
    0.024949646f,     0.059626125f,     -0.18689886f,     -0.10024784f,
    0.2824374f,       0.053822625f,     -0.047656838f,    -0.0764089f,
    -0.025940718f,    0.051651545f,     0.21320137f,      0.099894024f,
    0.04011468f,      -0.16568087f,     -0.026336377f,    0.2999737f,
    0.0108983f,       -0.019212415f,    -0.22076754f,     -0.1856473f,
    -0.06696342f,     -0.008030825f,    0.14637136f,      -0.12054267f,
    -0.034751505f,    -0.12024424f,     -0.0060537476f,   0.0726387f,
    0.22074611f,      -0.044489127f,    0.0006250827f,    0.00025321785f,
    -0.0006213008f,   -0.0015586045f,   0.00019673651f,   4.099249e-05f,
    0.0005109728f,    -0.0008180269f,   0.00060004264f,   0.0013118486f,
    0.00022630002f,   0.0014094106f,    0.00019255077f,   0.0014892209f,
    -0.0014964301f,   0.00027126196f,   -0.00038198454f,  0.00041936408f,
    -0.0012490005f,   -0.0012642618f,   -0.0004584482f,   -0.0011733782f,
    -4.5619516e-05f,  -0.00053911447f,  0.0002757501f,    -0.00065656286f,
    -0.0008967101f,   -0.00032052514f,  0.00022494931f,   0.0011180717f,
    -0.00020910664f,  -0.00043916245f,  0.00027699192f,   -0.00033785257f,
    -0.0014030056f,   -0.00067595165f,  0.00061394006f,   -0.002201647f,
    0.00012558326f,   0.0009765625f,    0.00072218763f,   0.00037710374f,
    0.000673716f,     -0.00056439394f,  -0.00027717394f,  0.00023619906f,
    -0.00045731684f,  0.0010594853f,    -0.0005888598f,   -0.00029658238f,
    0.000852441f,     0.0013599888f,    -0.00015138449f,  0.0011892274f,
    -0.0009940434f,   -0.0003757643f,   -0.00010083215f,  -0.00023670538f,
    -0.0008980531f,   -0.0014064303f,   -0.0002910085f,   0.0014966631f,
    0.0010810299f,    0.00021364732f,   0.0009359431f,    -0.00016503943f,
    0.0002626733f,    -0.00010171475f,  0.00024299903f,   -0.0008212048f,
    0.0006338569f,    -0.0016348923f,   -0.0010945485f,   0.00059888774f,
    -1.6025058e-05f,  -5.4157434e-05f,  -0.0014824575f,   -0.00087155413f,
    0.0011129375f,    -0.0001318279f,   -0.0022961404f,   0.17284061f,
    -0.14111409f,     0.10063678f,      0.005746697f,     0.050703805f,
    0.22103581f,      -0.14720203f,     -0.048427064f,    0.020132324f,
    -0.120046794f,    -0.07423013f,     -0.05826103f,     0.09929983f,
    -0.17802651f,     -0.11883419f,     -0.028431613f,    0.21510491f,
    0.027911613f,     -0.14689165f,     -0.020232772f,    0.09402516f,
    -0.0012694154f,   -0.18498756f,     -0.060966127f,    -0.058673155f,
    0.016928399f,     -0.12904839f,     0.35038602f,      -0.28308266f,
    0.2224613f,       0.13651203f,      0.119351365f,     0.30600193f,
    0.06760019f,      0.033336148f,     -0.009527867f,    0.13321164f,
    -0.7260084f,      0.08535729f,      0.4763099f,       -0.19916561f,
    -0.2749486f,      -0.13200206f,     0.106780574f,     -0.0722149f,
    0.006099053f,     -0.4555383f,      0.15451014f,      0.70706964f,
    -0.13663916f,     -0.26515767f,     0.06781401f,      0.24228606f,
    -0.11982967f,     0.09466011f,      -0.30056587f,     -0.08268624f,
    0.19890904f,      -0.07848904f,     0.07587721f,      -0.019523399f,
    0.050590873f,     0.09709588f,      0.43917468f,      -0.21970849f,
    -0.11905573f,     -0.08539357f,     -0.052984446f,    0.27209178f,
    -0.1229623f,      -0.07974753f,     -0.1120076f,      -0.2193615f,
    -0.04386668f,     0.1371178f,       0.2160587f,       -0.05168035f,
    -0.1149747f,      -0.08998538f,     0.14204952f,      0.044915218f,
    0.084755935f,     -0.12500525f,     0.08189563f,      0.06346095f,
    -0.083759084f,    0.023403086f,     0.33247668f,      -0.2539295f,
    -0.1086104f,      -0.07820148f,     0.09686487f,      0.04988621f,
    -0.16384856f,     -0.021932026f,    -0.20120397f,     -0.21865527f,
    0.46495748f,      0.064028755f,     -0.10432115f,     -0.13829052f,
    0.100322396f,     0.08574326f,      0.3527279f,       0.1566157f,
    -0.40212327f,     -0.04044492f,     0.06077651f,      0.17599198f,
    0.1082115f,       -0.05979683f,     -0.21598543f,     -0.020273715f,
    0.24804269f,      0.25499243f,      -0.4772828f,      0.025928197f,
    -0.15391652f,     0.10168276f,      0.029319692f,     -0.41325128f,
    -0.22017992f,     0.10987939f,      0.59368396f,      -0.2848367f,
    -0.04882739f,     -0.04071445f,     -0.016553922f,    0.45058045f,
    -0.07227533f,     -0.21291672f,     -0.38256332f,     0.20127401f,
    0.20242591f,      -0.009533259f,    -0.044821106f,    -0.35479757f,
    0.15691492f,      0.22150286f,      0.14318228f,      -0.25783208f,
    -0.06082449f,     0.11715212f,      0.036427327f,     0.34801593f,
    -0.006918621f,    -0.25939646f,     -0.22054295f,     0.090651184f,
    0.27326873f,      0.029627498f,     -0.28665096f,     -0.010202423f,
    -0.21084306f,     0.09641015f,      0.18107344f,      0.02776976f,
    -0.12536992f,     -0.09545121f,     0.12936692f,      -0.012780216f,
    0.06353791f,      0.05025121f,      -0.09270342f,     0.11697095f,
    -0.013291548f,    -0.052602444f,    0.1347111f,       0.13054533f,
    0.018617941f,     0.024347544f,     0.037256174f,     -0.16716598f,
    0.12981644f,      0.018519836f,     0.02865925f,      0.005449098f,
    -0.19637792f,     -0.16908143f,     -0.03218362f,     0.027015902f,
    -0.088726155f,    0.15607257f,      -0.14616114f,     -0.16309647f,
    -0.068849266f,    -0.07366568f,     0.20055847f,      -0.012123277f,
    -0.16513278f,     0.038115397f,     0.23738748f,      -0.079417326f,
    -0.022930026f,    0.10594611f,      0.023792312f,     0.19175145f,
    -0.00592863f,     0.058532137f,     0.040732272f,     0.07557129f,
    -0.1285637f,      0.096567236f,     0.18393745f,      -0.15239327f,
    -0.13476403f,     0.009446197f,     0.15141915f,      -0.031781506f,
    -0.02144387f,     -0.11567531f,     0.09248095f,      0.0960231f,
    -0.3186569f,      -0.15197483f,     0.06484188f,      -0.12134963f,
    -0.04354689f,     -0.09549347f,     -0.140347f,       -0.038959637f,
    0.03225155f,      -0.10894597f,     0.21686305f,      0.022316417f,
    -0.1602473f,      0.21239288f,      0.042298432f,     -0.026489027f,
    -0.0070512597f,   0.10272929f,      0.050375037f,     0.18771143f,
    -0.21782026f,     -0.01221637f,     0.15662712f,      -0.0536395f,
    -0.001359604f,    -0.010922325f,    0.038110156f,     -0.074286245f,
    -0.03700941f,     0.020875974f,     -1.3220476e-05f,  -0.00023514272f,
    -0.0003017345f,   0.0011701176f,    0.000521959f,     -0.00017714938f,
    -0.000829501f,    0.002614617f,     -0.00091740745f,  0.0005582848f,
    0.00024704964f,   -0.00028314895f,  0.0004936242f,    -0.0015356694f,
    -0.00012244866f,  -0.00040164185f,  0.00031529582f,   0.0011554387f,
    0.0010136263f,    -0.00061005994f,  0.0010524715f,    -0.001444125f,
    -0.0004013892f,   0.00031088918f,   -0.0016401805f,   -0.0019646992f,
    -0.0018860558f,   -0.0013858845f,   -0.0004839716f,   0.0017164674f,
    0.00014805095f,   -0.00081432774f,  0.00060422387f,   0.00029738623f,
    0.0011475378f,    -0.0008238252f,   -0.001087642f,    0.0007561985f,
    -0.0026614815f,   0.0001397157f,    -0.0014026494f,   -0.0015810645f,
    0.0011933013f,    0.00094971794f,   -0.0010351398f,   -0.0015486933f,
    -0.0015997741f,   0.0005479167f,    -0.0018494618f,   -0.0014196262f,
    0.00034412014f,   -0.00011232276f,  0.0006711058f,    -0.000771926f,
    0.00012746225f,   -9.498669e-05f,   0.001740365f,     -0.00044524655f,
    -0.0008572018f,   0.00015534928f,   -7.2743096e-05f,  -0.0012182463f,
    -0.00019183973f,  5.0201993e-06f,   0.0013708925f,    -0.0012655328f,
    -0.0012379608f,   -0.0020387997f,   0.0009246763f,    0.0006563513f,
    -0.0014400535f,   -0.0009926535f,   -0.00058996526f,  -0.00068704615f,
    0.00044658003f,   0.00010915541f,   8.5059844e-05f,   0.0009823465f,
    -0.0011803756f,   0.00051836227f,   0.0018982961f,    0.06675631f,
    0.10011045f,      -0.13682027f,     -0.20919879f,     0.078355655f,
    0.26173344f,      0.14700978f,      -0.10170216f,     -0.015684163f,
    -0.101550885f,    0.20361637f,      0.07913092f,      -0.1828982f,
    -0.069508165f,    -0.21272519f,     -0.21261212f,     0.006008986f,
    0.09304044f,      -0.23017691f,     0.098252214f,     0.09731166f,
    -0.26144886f,     -0.050176438f,    0.014347924f,     0.08888933f,
    0.14839166f,      -0.04708436f,     0.047671877f,     0.22523108f,
    0.15061307f,      -0.051010914f,    0.008852497f,     0.028482968f,
    0.050583925f,     -0.23154245f,     -0.01981642f,     -0.114851244f,
    0.040154893f,     0.1623273f,       0.08625653f,      0.15995583f,
    -0.03382885f,     0.07821765f,      0.021595515f,     -0.0025906158f,
    -0.047754977f,    -0.23395178f,     0.07294105f,      -0.112362325f,
    -0.048968635f,    -0.30034152f,     -0.04912468f,     0.3725927f,
    -0.17659034f,     0.011824085f,     -0.021366604f,    0.076598346f,
    0.099143974f,     0.045059048f,     -0.15567145f,     -0.05769199f,
    0.12508819f,      -0.006354268f,    0.085477896f,     0.093055904f,
    -0.22157891f,     0.06795856f,      0.032484133f,     0.14592226f,
    0.1100743f,       -0.17674658f,     0.017361315f,     -0.16058786f,
    0.08126338f,      0.1725364f,       -0.04854919f,     -0.11558539f,
    -0.010670696f,    -0.11523113f,     0.1372087f,       -0.0009926815f,
    -0.0941326f,      0.10116744f,      0.07690485f,      0.029048292f,
    -0.042451575f,    -0.057869837f,    -0.015472943f,    0.013779924f,
    0.06166149f,      -0.047353655f,    0.046854954f,     -0.03657822f,
    -0.04329189f,     -0.05082251f,     -0.0125404475f,   0.003572805f,
    -0.027613502f,    -0.048680108f,    -0.006214f,       0.06741014f,
    -0.026016843f,    -0.040222958f,    -0.085795574f,    -0.038291216f,
    0.018852936f,     0.024483532f,     -0.04164252f,     -0.08545179f,
    0.05634567f,      0.01995072f,      0.03231946f,      -0.0340785f,
    -0.038872875f,    0.015596751f,     0.06087766f,      -0.055688784f,
    -0.10009366f,     -0.00752487f,     -0.058457606f,    0.04034822f,
    0.07022579f,      0.03150506f,      0.009345186f,     0.041655015f,
    -0.03276045f,     -0.012106893f,    -0.012162123f,    -0.08978218f,
    0.05960567f,      0.13298154f,      0.0895561f,       7.7725235e-05f,
    -0.01998912f,     0.0056618396f,    -0.0031503867f,   0.017818868f,
    0.026964385f,     0.15826462f,      0.112909496f,     0.018960712f,
    -0.03772603f,     -0.025289025f,    0.039477095f,     -0.01312961f,
    -0.043903742f,    -0.005181447f,    0.10662807f,      -0.051380433f,
    -0.14400133f,     -0.07620744f,     -0.0017911434f,   0.04636541f,
    0.09102503f,      -0.08506592f,     -0.10052367f,     0.08344101f,
    0.0051590335f,    -0.029293766f,    0.036694296f,     -0.018124782f,
    -0.053898882f,    0.04917023f,      -0.033770755f,    0.029063474f,
    -0.02834765f,     0.15198529f,      -0.060725253f,    -0.15768304f,
    -0.08117579f,     0.20282413f,      0.16407679f,      -0.108491525f,
    -0.02085395f,     0.021501943f,     0.059487946f,     0.0715865f,
    0.13787654f,      0.06762357f,      -0.17588139f,     -0.13236074f,
    -0.06981934f,     -0.15008943f,     -0.056206796f,    0.13636053f,
    0.033482444f,     0.014524091f,     -0.083056495f,    -0.05323179f,
    -0.08940479f,     -0.030837258f,    -0.17281045f,     -0.13944931f,
    0.38791552f,      0.04977804f,      -0.069708936f,    -0.16060182f,
    0.052770957f,     0.21168642f,      -0.0026608843f,   0.0546751f,
    0.3558389f,       0.90801334f,      0.30998683f,      0.09166785f,
    0.007900922f,     0.16260871f,      -0.05938251f,     -0.062445562f,
    -0.07217842f,     0.01174236f,      0.30000117f,      -0.22053759f,
    -0.07178082f,     0.07816497f,      -0.1341458f,      -0.15025713f,
    0.039412666f,     0.04994024f,      0.11276823f,      0.26087385f,
    -0.17119522f,     -0.04244593f,     0.087949306f,     -0.075009264f,
    0.07495569f,      -0.0511641f,      0.062479217f,     0.156664f,
    0.09825385f,      -0.109064974f,    -0.00261372f,     -0.079715125f,
    0.11946517f,      0.032414228f,     -0.12026178f,     -0.106278904f,
    -0.1720374f,      0.026307546f,     0.01923708f,      0.092776306f,
    -0.095377095f,    -0.029367762f,    -0.043397404f,    -0.12510566f,
    0.15651321f,      -0.11961606f,     -0.03783477f,     -0.111579746f,
    0.10787243f,      0.16347243f,      0.028084397f,     0.13742678f,
    -0.0330539f,      -0.010310225f,    -0.075867794f,    0.21541397f,
    0.014253621f,     -0.2847873f,      -0.11460008f,     -0.06586463f,
    0.116923094f,     0.0028135753f,    0.15132381f,      -0.08193405f,
    0.08263156f,      -0.15104698f,     -0.0871004f,      0.32538134f,
    0.0727059f,       -0.11571937f,     -0.3155166f,      0.19886458f,
    -0.099829644f,    0.11134532f,      -0.42221326f,     0.056584317f,
    0.4441995f,       -0.32801667f,     0.029110972f,     0.015313865f,
    0.23972286f,      -0.2372417f,      0.31092858f,      -0.23003371f,
    0.0898668f,       0.40762937f,      0.07154352f,      -0.0030942124f,
    0.16851002f,      0.03923128f,      -0.5238041f,      0.05280075f,
    -0.072765455f,    -0.013563654f,    -0.16536972f,     -0.13748594f,
    -0.0029227473f,   0.08835767f,      0.101547435f,     -0.14176765f,
    0.15699007f,      0.0733286f,       0.10024779f,      0.12034514f,
    0.1820336f,       -0.19103037f,     -0.11690598f,     0.014915727f,
    -0.052643526f,    0.09419392f,      -0.12761492f,     -0.14883056f,
    0.14345036f,      -0.13031536f,     0.050570417f,     0.13296524f,
    0.010911412f,     -0.11275138f,     0.06476784f,      -0.040463537f,
    -0.020888565f,    0.16713917f,      -0.07143936f,     -0.074913405f,
    -0.060479842f,    0.07323461f,      0.12826684f,      -0.04328522f,
    -0.033571716f,    -0.09970749f,     -0.05523057f,     0.06289239f,
    0.21901138f,      -0.0358493f,      -0.0865003f,      -0.018982043f,
    0.06957813f,      0.41450012f,      -0.02720955f,     -0.0040385784f,
    0.06541972f,      0.12227084f,      -0.10731895f,     -0.084195584f,
    -0.15702803f,     -0.7429219f,      -0.04395434f,     -0.011260251f,
    0.10814431f,      -0.28268299f,     -0.12526658f,     -0.026223645f,
    0.08096181f,      0.68022597f,      0.13561013f,      0.0861837f,
    -0.050139893f,    0.35771114f,      -0.041319262f,    0.27181852f,
    -0.23890242f,     -0.53879493f,     0.21392858f,      0.07953314f,
    0.019276025f,     -0.5713126f,      -0.03759198f,     0.15653582f,
    0.15565476f,      0.0046008104f,    -0.04562863f,     0.10213345f,
    0.1765729f,       0.681407f,        -0.13053438f,     -0.06998789f,
    0.0038847167f,    -0.4426046f,      0.288027f,        0.25035673f,
    -0.3661724f,      -0.61181664f,     0.0528831f,       -0.00991241f,
    -0.022988223f,    0.010322964f,     -0.021636782f,    0.051467694f,
    0.119539924f,     0.31518963f,      -0.035797425f,    -0.17633334f,
    0.014319991f,     -0.0969675f,      0.19342084f,      0.08160614f,
    -0.08066563f,     -0.14648367f,     -0.13353409f,     0.15164322f,
    0.051955324f,     0.095058136f,     -0.026735751f,    -0.0889308f,
    0.08918214f,      0.086579025f,     0.005215317f,     -0.0064735063f,
    0.042601116f,     0.016859546f,     -0.013135831f,    -0.05732235f,
    -0.068414494f,    -0.089087464f,    -0.015611837f,    -0.061792485f,
    -0.07461176f,     -0.0376739f,      -0.068133585f,    0.00884918f,
    0.034659937f,     -0.11153176f,     -0.018928146f,    0.12819843f,
    0.03857558f,      0.011053381f,     0.08118842f,      -0.020579038f,
    -0.01668494f,     -0.01098568f,     0.035327934f,     0.068221286f,
    0.11152953f,      0.013529916f,     -0.016081996f,    0.1880506f,
    0.092608f,        0.03232222f,      -0.07684377f,     -0.0065249307f,
    0.018553032f,     0.022786446f,     0.026319757f,     0.05849914f,
    0.2068486f,       0.085097134f,     0.09237775f,      0.036499076f,
    0.066245906f,     -0.0815784f,      0.02879628f,      -0.0228671f,
    -0.040788565f,    0.02724577f,      -0.13525973f,     0.0033017346f,
    0.036037248f,     -0.0018032446f,   -0.021063758f,    0.09868304f,
    -0.0046157865f,   0.061550014f,     0.17048986f,      -0.009244422f,
    0.04022917f,      0.008439408f,     0.017657066f,     1.8606753e-06f,
    0.022133613f,     -0.020205494f,    0.076139875f,     0.07413829f,
    -0.038555f,       0.006358421f,     -0.039605357f,    0.0059501906f,
    -0.08430261f,     0.0006188382f,    -0.0024410242f,   0.088485524f,
    0.068978414f,     -0.037363596f,    0.049159456f,     0.082492985f,
    0.036969624f,     -0.0024945019f,   -0.076098084f,    0.11199635f,
    -0.101375006f,    0.120855f,        0.020787042f,     -0.0802099f,
    -0.07437736f,     -0.016652707f,    0.17020068f,      -0.088481344f,
    0.04040154f,      0.043663975f,     -0.04981915f,     -0.10109865f,
    0.18095623f,      0.076355174f,     0.16501443f,      0.047640767f,
    -0.2998961f,      -0.10478614f,     -0.11883907f,     0.023615226f,
    -0.15416087f,     0.048735574f,     0.04563599f,      -0.35214776f,
    0.24584366f,      -0.1094f,         0.23839618f,      0.12754512f,
    0.2034725f,       -0.093577564f,    0.014412291f,     0.26167035f,
    0.059435118f,     0.056774087f,     -0.03670964f,     0.07175207f,
    -0.13131326f,     -0.1811451f,      -0.24757788f,     0.055344015f,
    -0.113494106f,    -0.14848204f,     -0.18046406f,     0.12988998f,
    0.104764394f,     -0.10053604f,     0.012329879f,     0.2511423f,
    0.31517178f,      -0.15847275f,     0.31263584f,      -0.26691273f,
    -0.010338036f,    0.19291931f,      -0.09310273f,     -0.038397115f,
    0.05802667f,      -0.14982627f,     -0.32015845f,     0.24430843f,
    0.24325047f,      0.055703018f,     0.040475592f,     -0.11337616f,
    0.030283513f,     -0.17187597f,     -0.074785024f,    -0.058253467f,
    0.04569388f,      -0.12651756f,     0.002959852f,     -0.074624695f,
    0.044306315f,     0.1583168f,       -0.062992565f,    0.20761298f,
    -0.18382752f,     0.047950935f,     0.03453255f,      0.08143798f,
    -0.078274615f,    -0.008095887f,    0.09633332f,      -0.032731134f,
    0.038960367f,     0.07796624f,      -0.09800061f,     -0.17390114f,
    0.013836467f,     -0.09556531f,     -0.0648973f,      -0.06499231f,
    -0.12440793f,     0.07461446f,      0.16298135f,      -0.14313312f,
    -0.026221916f,    0.17264506f,      0.018620806f,     0.04115425f,
    0.05707464f,      -0.06986493f,     -0.011844003f,    0.03608856f,
    0.0047275014f,    0.054055534f,     0.06472594f,      -0.07746946f,
    -0.04556572f,     0.13835749f,      0.0064782444f,    -0.032842744f,
    -0.10053439f,     -0.030013109f,    0.081073165f,     0.053378932f,
    0.016869627f,     0.12709975f,      0.25404435f,      0.09076769f,
    0.075498745f,     -0.013449956f,    0.051617667f,     -0.049904004f,
    0.11237816f,      -0.00494395f,     0.03591571f,      0.05699838f,
    -0.14426246f,     -0.014709394f,    -0.04324658f,     -0.09033934f,
    -0.0068686805f,   0.1764322f,       -0.012225644f,    0.07162804f,
    0.15758166f,      -0.031030888f,    0.05114923f,      0.046882357f,
    0.0042722025f,    0.045018625f,     0.09796738f,      -0.054886423f,
    -0.004248838f,    0.025244704f,     -0.06603638f,     0.02673505f,
    0.06231155f,      0.04527175f,      -0.03167263f,     0.13647105f,
    -0.0009657645f,   0.018488562f,     0.04139011f,      -0.10096877f,
    -0.009352818f,    0.07455057f,      0.028824145f,     -0.13360934f,
    -0.03819652f,     0.0011510518f,    0.01929035f,      0.0471425f,
    0.031506382f,     0.06336957f,      0.032302894f,     0.0062813507f,
    -0.03740053f,     0.050428763f,     0.081019014f,     0.072321765f,
    0.011834716f,     -0.047916785f,    -0.019763002f,    -0.0067713372f,
    0.027429305f,     -0.0053185252f,   0.034787714f,     0.0071661286f,
    -0.008718438f,    -0.012047641f,    -0.060003273f,    -0.10047217f,
    -0.09047075f,     0.006131005f,     -0.018347835f,    0.03032604f,
    -0.009940189f,    -0.02614416f,     0.071653835f,     0.038436446f,
    -0.03604809f,     -0.023668608f,    -0.015906483f,    0.038312346f,
    0.078073286f,     0.08553636f,      0.098843835f,     0.12573788f,
    0.04602298f,      0.004538015f,     0.0716674f,       0.010145497f,
    0.057948783f,     0.026583666f,     0.03696319f,      0.0743974f,
    0.07202591f,      -0.0015225838f,   0.017082151f,     0.08737485f,
    -0.005794626f,    0.0263321f,       -0.05538743f,     -0.10465178f,
    -0.06276884f,     0.02771578f,      0.017957618f,     -0.0010449642f,
    0.013926752f,     -0.026691137f,    -0.022419702f,    -0.045605116f,
    -0.090646945f,    -0.0631274f,      0.03606821f,      0.06525776f,
    0.019389935f,     0.0060567847f,    0.002610739f,     -0.075330645f,
    -0.0042645973f,   -0.059406202f,    -0.045317203f,    0.017715793f,
    0.010738059f,     0.025802054f,     0.061774906f,     0.049093276f,
    0.06254594f,      -0.08440929f,     -0.05960291f,     -0.21179302f,
    -0.03749246f,     0.1320459f,       0.022253683f,     -0.20560919f,
    0.09833672f,      -0.010864592f,    0.13121127f,      0.272931f,
    0.28527832f,      0.036214154f,     -0.17419104f,     0.106054515f,
    0.11146654f,      -0.053124692f,    -0.034706f,       -0.40110114f,
    -0.17413057f,     -0.002180313f,    -0.02328964f,     -0.014259927f,
    -0.04321161f,     -0.10158819f,     -0.0019524768f,   0.25281256f,
    0.18883528f,      0.21823047f,      -0.07753388f,     -0.1263069f,
    0.20391452f,      0.17332755f,      -0.055732556f,    0.08542721f,
    -0.27624428f,     -0.093995094f,    -0.34804076f,     -0.18735792f,
    -0.32889035f,     -0.2496407f,      0.0230525f,       -0.0032602132f,
    -0.09734014f,     0.24850279f,      0.4498616f,       0.23925053f,
    0.7578791f,       0.4650758f,       -0.09640157f,     0.030361129f,
    0.13835502f,      0.034524493f,     -0.49186295f,     -0.33270922f,
    -0.115898f,       0.08189888f,      0.14717336f,      0.09036838f,
    -0.19144672f,     -0.1619413f,      0.07546339f,      0.47785786f,
    0.033417262f,     -0.22002956f,     -0.65589154f,     -0.49498725f,
    0.26522022f,      0.30143416f,      -0.004251369f,    -0.01142047f,
    -0.17787316f,     0.030584835f,     0.15715107f,      0.23354243f,
    0.017105157f,     -0.19644701f,     0.014484168f,     -0.17201601f,
    0.075689025f,     0.028962446f,     -0.06878254f,     0.05019853f,
    0.05476096f,      -0.047709458f,    -0.13678539f,     -0.16251084f,
    -0.056205764f,    0.09791768f,      0.16366638f,      -0.12979919f,
    0.0027292583f,    0.034145705f,     0.068608135f,     0.06334712f,
    0.048673455f,     0.07738835f,      -0.0031245176f,   -0.07452564f,
    -0.20245549f,     0.027065815f,     -0.0021526585f,   0.0511242f,
    0.15502298f,      0.14651485f,      0.07588487f,      -0.10572951f,
    -0.067488134f,    -0.19962423f,     0.047433898f,     -0.011952215f,
    -0.02098195f,     0.16966638f,      0.14325915f,      0.026020855f,
    -0.00033336115f,  0.06684103f,      -0.117987f,       0.089755684f,
    0.027904972f,     0.075243816f,     0.2602479f,       0.16163015f,
    0.0055607497f,    0.018227512f,     0.029731913f,     -0.07488886f,
    0.10381207f,      0.0014797549f,    0.052478183f,     0.19516547f,
    0.05121067f,      -0.07954861f,     -0.055953328f,    -0.10098253f,
    -0.04282565f,     0.12107566f,      0.015420042f,     -0.026093034f,
    0.099772f,        0.065438636f,     -0.058609657f,    -0.046216577f,
    -0.024240786f,    0.0035749027f,    0.09980471f,      0.041678235f,
    -0.047122665f,    0.012449634f,     0.024942646f,     -0.039778136f,
    0.087724134f,     0.12657014f,      -0.076152004f,    -0.05819194f,
    -0.09207551f,     -0.050248478f,    0.0848444f,       0.011602652f,
    -0.066368654f,    0.07597232f,      0.034712225f,     0.11924102f,
    -0.099075526f,    0.0718425f,       -0.11197687f,     0.07318371f,
    0.11031657f,      -0.46884447f,     0.09414266f,      -0.14163429f,
    0.1516352f,       -0.1341206f,      0.11831797f,      0.087420516f,
    0.015127726f,     0.028304087f,     0.2779788f,       0.042133782f,
    -0.11278912f,     -0.019549938f,    -0.11386155f,     -0.0007093752f,
    -0.13948888f,     0.1762304f,       0.2762475f,       -0.24564396f,
    -0.16273943f,     0.19988434f,      0.029753732f,     0.11769874f,
    -0.09476194f,     -0.35952422f,     0.08280224f,      0.14039701f,
    -0.5054993f,      0.3230602f,       -0.09488756f,     0.18297875f,
    0.021063626f,     -0.10248441f,     0.31057218f,      0.49288955f,
    -0.06318224f,     -0.53251696f,     0.016925616f,     -0.23778969f,
    0.22520708f,      -0.28116438f,     -0.25012317f,     0.045585666f,
    0.21047309f,      0.13688251f,      -0.010493906f,    0.18622957f,
    -0.06745559f,     0.059422202f,     0.07465879f,      0.1760069f,
    -0.2439128f,      -0.13952732f,     -0.14145756f,     -0.22604354f,
    0.040418845f,     0.2511401f,       -0.041464362f,    0.068661585f,
    0.09363836f,      -0.17196894f,     0.35007256f,      0.14665903f,
    -0.11697539f,     -0.0873394f,      -0.11872331f,     0.06795469f,
    -0.19596466f,     0.09043551f,      -0.07781104f,     0.06362947f,
    -0.04456654f,     -0.1382808f,      0.14513893f,      0.002784174f,
    0.013198261f,     0.03299566f,      -0.009061453f,    -0.03782085f,
    0.059055243f,     0.036658123f,     -0.032938365f,    0.007655598f,
    -0.02654659f,     -0.051362813f,    -0.019685762f,    -0.04363386f,
    -0.03368953f,     -0.040151592f,    -0.030751372f,    -0.022468425f,
    0.018601812f,     0.01215805f,      0.015349634f,     0.03493562f,
    -0.01330295f,     0.0379455f,       -0.0038268114f,   -0.04438376f,
    -0.076136634f,    0.0149799315f,    0.04360961f,      0.0688512f,
    0.098810025f,     0.03130221f,      0.12420085f,      0.15065008f,
    0.079781555f,     -0.027734771f,    -0.053833693f,    -0.06780279f,
    0.0021823857f,    0.13103488f,      0.056097902f,     0.056191355f,
    0.0813432f,       0.109182745f,     0.103016764f,     -0.0237583f,
    -0.08856121f,     -0.030784028f,    0.087375164f,     0.013652729f,
    0.011638834f,     -0.0060421485f,   0.056429435f,     0.10691829f,
    0.041128937f,     -0.043404203f,    -0.0025073688f,   0.012957162f,
    0.01234017f,      0.11861598f,      0.09244049f,      0.03474449f,
    -0.02489581f,     0.035870664f,     -0.04075868f,     0.013552304f,
    -0.009587781f,    0.01752828f,      0.07450903f,      0.06924415f,
    0.0011354148f,    -0.06966305f,     0.008092117f,     0.02915073f,
    0.043506045f,     -0.039757483f,    0.014310178f,     0.00084354123f,
    -0.013759381f,    0.026358005f,     0.088238746f,     0.082134426f
};

static const float conv1_biases[] = {
    -0.016606892f,    -0.011107335f,    -0.0048309686f,   -0.04867378f,
    -0.030040957f,    -0.07297248f,     -0.019458665f,    -0.009738028f,
    0.6951231f,       -0.07369442f,     -0.01354204f,     0.010336088f,
    -0.02956177f,     0.018691286f,     -0.021675158f,    0.0040888255f,
    -0.0803309f,      -0.02080248f,     -0.00025044166f,  0.015665635f,
    -0.024439847f,    -0.00014609392f,  -5.0048184e-05f,  -0.001185404f,
    -8.3538194e-05f,  0.0f,             -0.00037626884f,  0.02971581f,
    -9.940329e-05f,   -0.020136558f,    -0.00029498152f,  0.019285819f,
    0.0055777165f,    -0.07003153f,     -0.024398552f,    -1.772693e-05f,
    0.0050997124f,    -0.011211924f,    0.004536128f,     -0.024612177f,
    -0.022535782f,    -0.00016232267f,  -0.00017362963f,  -1.552602e-05f,
    -0.06559696f,     -0.0065806108f,   6.6839266e-06f,   0.025228953f,
    -0.0013730666f,   0.03035182f,      0.0f,             0.003285622f,
    0.0055278814f,    0.020766519f,     -0.008490622f,    0.026332268f,
    -0.046789873f,    0.010329567f,     -0.02364932f,     0.027851572f,
    0.054407462f,     -0.08068252f,     -0.009446503f,    -0.04663234f
};

static const float conv2_kernel[] = {
    -0.24004751f,     0.1037138f,       0.11173403f,      0.04352092f,
    -0.23728481f,     0.12153747f,      -0.23676059f,     -0.28548065f,
    -0.612738f,       -0.12218937f,     -0.06005159f,     0.1850652f,
    0.16014674f,      0.13922939f,      0.21359426f,      0.10787945f,
    -0.26999104f,     -0.14241326f,     -0.0013871012f,   -0.004951588f,
    0.34021696f,      0.00055816956f,   4.7351106e-05f,   0.0037513396f,
    0.0011569702f,    0.0016541762f,    -0.0011876022f,   0.049887992f,
    -7.20162e-05f,    -0.17735492f,     0.0011244657f,    -0.22381487f,
    0.0035836962f,    -0.32106942f,     -0.16167264f,     -0.00079228356f,
    0.05056063f,      0.21074672f,      0.07716238f,      -0.33156216f,
    0.06265881f,      0.00025428506f,   -0.0012989661f,   0.00044869471f,
    -0.41594547f,     -0.019950004f,    0.0002566903f,    0.17913155f,
    -0.59505045f,     0.32598367f,      0.0013792524f,    -0.0893171f,
    -0.13066787f,     0.21108511f,      -0.05854454f,     -0.11937838f,
    0.08559372f,      -0.11413643f,     0.28384048f,      -0.011619674f,
    0.3210233f,       -0.20085232f,     -0.3413438f,      -0.029155191f,
    -0.15286806f,     -0.4510034f,      -0.07077684f,     0.1440866f,
    0.05953074f,      -0.036571715f,    0.38701403f,      -0.12762508f,
    0.059950776f,     0.005409028f,     0.16427578f,      -0.042501528f,
    0.03296236f,      -0.19972457f,     -0.2558594f,      -0.054797124f,
    -0.13352458f,     0.05193127f,      -0.0005906696f,   0.14123854f,
    -0.0659517f,      0.00025938704f,   0.0004935732f,    0.0018757024f,
    -0.00041573317f,  0.000612862f,     -0.00082537025f,  0.008750236f,
    0.00031561358f,   -0.031592708f,    -0.0011055622f,   0.53974074f,
    0.16837794f,      0.10016078f,      -0.04458074f,     -0.00082082127f,
    0.14558496f,      0.053703558f,     0.39986718f,      0.36513358f,
    -6.220485e-05f,   -0.0015507897f,   0.00019759317f,   0.0014775719f,
    0.1719912f,       0.20428549f,      0.00071692816f,   -0.1558909f,
    0.13173038f,      0.04302276f,      0.00053589704f,   -0.14488573f,
    -0.056273844f,    0.040606596f,     0.123271205f,     -0.068726316f,
    0.11684817f,      0.20592213f,      -0.07642778f,     -0.105910346f,
    -0.2585832f,      -0.23417398f,     0.12040833f,      -0.09154299f,
    0.17292786f,      0.12093151f,      0.121731065f,     -0.17765464f,
    -0.0384256f,      0.13790965f,      -0.018014584f,    -0.0035332667f,
    0.05237539f,      -0.0137136085f,   -0.023778876f,    0.08754374f,
    0.009544277f,     0.002218335f,     0.0054768333f,    0.1433599f,
    -0.3052151f,      -0.027671313f,    0.0002961017f,    -0.090877056f,
    0.080019295f,     0.0002891663f,    8.4476655e-05f,   0.003273378f,
    -0.0009773651f,   0.0009694154f,    0.0023891174f,    0.15905638f,
    0.0006923403f,    -0.23975392f,     0.00035524007f,   -0.1527745f,
    0.09689001f,      -0.13403186f,     -0.108304426f,    -0.0011496501f,
    -0.07912725f,     -0.045485526f,    0.07143749f,      -0.119538695f,
    0.06519464f,      0.00047708154f,   -0.0012068728f,   0.00023571185f,
    -0.021851776f,    -0.109725535f,    -0.0004428154f,   -0.061998375f,
    -0.021858238f,    0.13159609f,      0.0011464811f,    -0.12141252f,
    -0.06273758f,     0.25536647f,      0.10020979f,      0.13120368f,
    0.16516227f,      -0.14927655f,     0.14413974f,      0.039363794f,
    0.19443943f,      -0.016147649f,    -0.08761862f,     0.08571985f,
    -0.034732215f,    0.08880915f,      0.11532351f,      -0.25091994f,
    -0.18177348f,     0.111709945f,     -0.06447608f,     -0.04730312f,
    -0.13159128f,     0.01896033f,      -0.29692683f,     0.3151368f,
    0.016690407f,     0.08558145f,      0.016950725f,     0.13607958f,
    -0.008597756f,    -0.15839215f,     -0.00063565f,     0.1460453f,
    0.0293913f,       -0.002123718f,    -0.0021662426f,   0.0011421579f,
    0.0003198187f,    -0.0003188809f,   -0.0013892676f,   0.4037178f,
    0.0010367054f,    -0.08923333f,     0.0017262235f,    0.049378145f,
    0.03052855f,      -0.109949686f,    0.041772034f,     -0.00035096507f,
    -0.091725476f,    -0.11212402f,     0.018248942f,     -0.103211425f,
    0.036560368f,     -0.00085344445f,  0.0005108113f,    0.001955348f,
    -0.17280978f,     -0.15745719f,     0.0016406632f,    0.102957435f,
    -0.056333065f,    0.12174493f,      -0.00029968395f,  -0.046295736f,
    -0.05203623f,     0.17915867f,      0.17138906f,      0.20149875f,
    0.14662422f,      -0.064990275f,    0.086431846f,     0.02657508f,
    -0.26568517f,     -0.10079118f,     -0.20195039f,     0.072891355f,
    0.20596844f,      0.14842734f,      0.11689981f,      -0.29243934f,
    0.020928182f,     0.14047745f,      -0.032774657f,    0.013994991f,
    0.04893072f,      -0.08560179f,     0.07281562f,      0.069943145f,
    -0.006538145f,    0.08474164f,      0.013837414f,     0.104377925f,
    -0.32318544f,     -0.03346193f,     -0.0006234076f,   -0.25232646f,
    0.08134998f,      -0.0012573038f,   -0.00025874845f,  0.0021640486f,
    0.0007048257f,    0.00086261076f,   -0.00049946277f,  0.18027796f,
    0.0005355332f,    -0.38501582f,     -0.0006607559f,   -0.15524353f,
    0.07703849f,      -0.19909449f,     -0.040597178f,    0.00019839265f,
    -0.089541435f,    -0.17451768f,     0.193429f,        -0.039949242f,
    -0.053514555f,    0.0010188281f,    0.0012863715f,    -4.6992354e-05f,
    0.046476908f,     -0.15381487f,     -0.0009432004f,   0.068324186f,
    -0.07473438f,     0.19692156f,      -0.00023191162f,  -0.07189867f,
    -0.08010463f,     0.2258111f,       0.11592476f,      0.17914976f,
    0.13195598f,      -0.11106629f,     0.12462127f,      0.006350248f,
    0.09321404f,      0.03279733f,      0.040620834f,     0.07625015f,
    0.26654643f,      0.006987583f,     0.056940462f,     -0.21681315f,
    0.077801876f,     0.055067755f,     -0.07760556f,     0.03872932f,
    -0.79303557f,     -0.110598356f,    0.11750592f,      0.13262804f,
    -0.06422358f,     0.021544294f,     0.106549375f,     0.05221962f,
    -0.48878804f,     -0.2284007f,      0.0011379553f,    0.1531422f,
    0.07926333f,      0.00038042318f,   0.0017872434f,    0.0007042611f,
    0.00024585766f,   -0.0015021149f,   0.00033512182f,   0.17980112f,
    -0.00030350624f,  -0.09183649f,     -0.0003179727f,   -0.17676876f,
    0.053549517f,     -0.301563f,       0.019367442f,     -0.000101853504f,
    -0.03712425f,     -0.077965915f,    -0.16881329f,     -0.5796423f,
    0.15654868f,      -0.0013217079f,   -0.0010914453f,   0.0011883607f,
    0.106605545f,     -0.12484317f,     0.0004226503f,    0.09296495f,
    -0.38826272f,     0.29945183f,      0.000777706f,     -0.28242147f,
    -0.09771982f,     0.30562764f,      0.21152276f,      0.07008504f,
    0.08235849f,      -0.00946117f,     0.14994532f,      0.025700504f,
    0.22086006f,      0.01654313f,      -0.040672258f,    0.012883936f,
    0.0061779623f,    -0.013291561f,    0.19166854f,      -0.017105795f,
    -0.07506847f,     0.18045776f,      -0.30787674f,     0.048325602f,
    0.059621293f,     0.12610446f,      -0.24595498f,     0.123657905f,
    0.028636903f,     -0.006177237f,    -0.0489142f,      0.16809219f,
    -0.10486529f,     -0.10494883f,     -0.0004520705f,   0.2357923f,
    0.050763234f,     -0.0011827169f,   -0.00010527009f,  0.001825628f,
    0.0008991276f,    -0.0015281035f,   -0.000533636f,    0.1632358f,
    0.0020393324f,    0.015845003f,     0.0016316768f,    -0.06386037f,
    0.054093625f,     -0.14962895f,     -0.014346977f,    0.0012925119f,
    -0.12354017f,     0.016353896f,     -0.2519243f,      -0.04281126f,
    0.19090451f,      -0.00022991616f,  0.001894351f,     -0.00054305035f,
    -0.11097119f,     -0.050557557f,    -0.0011444872f,   -0.0023186142f,
    -0.11912521f,     -0.022436127f,    0.0001445022f,    -0.13724817f,
    -0.024185471f,    0.24273016f,      0.13877408f,      0.13629928f,
    0.15725626f,      -0.15798466f,     0.10887137f,      0.077191934f,
    0.09739567f,      -0.09165967f,     -0.20622979f,     0.11893536f,
    -0.09508168f,     -0.075439416f,    0.27062836f,      0.08787128f,
    0.101400554f,     0.26852965f,      -0.59093076f,     0.19821987f,
    0.08937512f,      0.055678036f,     -0.116133705f,    0.039116386f,
    0.06315727f,      0.107821845f,     -0.019807387f,    0.14512414f,
    -0.060943954f,    -0.07014007f,     0.00016978045f,   0.17468223f,
    0.06063257f,      -7.286974e-05f,   0.0005939672f,    0.0018404772f,
    0.0011290488f,    0.00019233255f,   0.0019600382f,    0.07629803f,
    0.00034283352f,   -0.0005339052f,   -0.00011325302f,  -0.0320187f,
    0.041795913f,     -0.31851268f,     0.08271041f,      0.0021725951f,
    -0.16681935f,     -0.031819552f,    -0.32887435f,     0.046451382f,
    0.1761192f,       0.00069008686f,   7.961439e-05f,    -0.00019473303f,
    -0.09694852f,     -0.033249408f,    -0.0008172128f,   0.22586535f,
    -0.22233704f,     -0.05459794f,     -9.828665e-05f,   -0.14924103f,
    -0.03904952f,     0.20695034f,      0.07704979f,      0.16610599f,
    0.14414144f,      -0.23807625f,     0.102441765f,     0.09765428f,
    0.08840623f,      -0.024117084f,    0.0006691144f,    0.17866156f,
    0.116677806f,     0.10861541f,      0.11338425f,      -0.23225266f,
    -0.054111186f,    0.12930895f,      -0.03074416f,     -0.023599973f,
    -0.023976676f,    -0.022300292f,    -0.10048258f,     0.16049188f,
    -0.004780249f,    0.040883638f,     0.0047388203f,    0.12917048f,
    -0.21303014f,     -0.07274896f,     0.0002620874f,    -0.03659924f,
    0.059079926f,     0.0006437263f,    -0.00039178296f,  0.0010649684f,
    0.000993124f,     -0.001187135f,    -0.00032986602f,  0.24311808f,
    0.00091928797f,   -0.20850842f,     0.0003986647f,    -0.07371656f,
    0.06816515f,      -0.1429451f,      -0.029881343f,    -0.00082499237f,
    -0.09339576f,     -0.113954715f,    0.07046191f,      -0.113959014f,
    0.027631817f,     -0.001427791f,    -0.0007467217f,   0.00066865725f,
    -0.053210024f,    -0.14419393f,     -0.0019058359f,   0.036102716f,
    -0.045452252f,    0.13939077f,      0.00020870002f,   -0.09519005f,
    -0.06584737f,     0.22461855f,      0.12797733f,      0.17647593f,
    0.15183948f,      -0.12066972f,     0.12076414f,      0.023683056f,
    0.007647241f,     -0.04053516f,     -0.10980768f,     0.078161746f,
    0.06110008f,      0.11834854f,      0.104443826f,     -0.26339832f,
    -0.055349257f,    0.12657754f,      -0.0721799f,      -0.009455498f,
    -0.09344963f,     -0.080262676f,    -0.091957375f,    0.19737977f,
    0.0019429459f,    0.11292064f,      0.060309578f,     0.10732085f,
    -0.15051246f,     -0.076560535f,    0.0009079906f,    -0.046496335f,
    0.0484382f,       0.0002680256f,    5.6948204e-05f,   0.00083167513f,
    0.00028356427f,   0.0023435538f,    -0.0005214237f,   0.28922284f,
    0.00051808904f,   -0.24499384f,     -0.0007466925f,   -0.01638365f,
    0.058050945f,     -0.19633056f,     0.022773353f,     -0.0004780171f,
    -0.090633534f,    -0.14776254f,     0.119261585f,     -0.096436426f,
    -0.012329957f,    0.00029322653f,   -0.0010079204f,   0.00074612326f,
    -0.104321286f,    -0.17565423f,     -0.00054808555f,  0.14772059f,
    -0.045832f,       0.1693018f,       -0.0022354075f,   -0.07354242f,
    -0.0813528f,      0.18026239f,      0.11273178f,      0.2046148f,
    0.14012843f,      -0.123873696f,    0.105171315f,     0.010817605f,
    -0.11698091f,     -0.035467967f,    -0.051155165f,    0.07571343f,
    0.19351886f,      0.20593607f,      0.07896959f,      -0.33665136f,
    -0.329129f,       0.13116045f,      -0.12087905f,     -0.11019666f,
    -0.045861978f,    -0.058414202f,    -0.16083077f,     0.12795414f,
    -0.068883896f,    0.21972013f,      0.1430821f,       0.056867354f,
    -0.1541733f,      -0.09022871f,     -0.0011901074f,   0.095902f,
    0.04330393f,      -5.3807908e-05f,  0.0017777922f,    0.00068946765f,
    -0.00033517132f,  -0.0005324449f,   0.0007019898f,    0.25493136f,
    0.0005385745f,    -0.16342911f,     0.00023792995f,   -0.14627431f,
    -0.052893937f,    -0.026358943f,    -0.35610512f,     0.0010252121f,
    -0.07270371f,     0.088961594f,     0.36057523f,      -0.037234627f,
    0.17616756f,      -0.00036198323f,  0.00155309f,      -0.00037672193f,
    -0.071252204f,    -0.105038874f,    0.0010542567f,    -0.0016337716f,
    -0.3988117f,      0.13447013f,      0.00060679915f,   -0.033088233f,
    -0.045110956f,    0.11759932f,      0.15916945f,      0.18349163f,
    0.016952226f,     -0.12615448f,     0.03231247f,      -0.0702588f,
    0.14372708f,      0.024115205f,     -0.14781988f,     0.030958379f,
    0.018110374f,     0.0032062773f,    0.17049916f,      -0.06647304f,
    -0.011934345f,    0.17750558f,      -0.24867764f,     0.04478863f,
    -0.042074967f,    0.054483127f,     -0.19995055f,     0.15366168f,
    0.026441816f,     0.029334703f,     -0.012454435f,    0.14892687f,
    -0.10988327f,     -0.080876134f,    0.0001221925f,    0.15185034f,
    0.047081508f,     0.00018459935f,   0.00055384205f,   0.0015057924f,
    -0.00044093153f,  0.0009733336f,    -0.0017067187f,   0.20057406f,
    -0.0008939944f,   -0.05056224f,     -0.0015461782f,   -0.0059439135f,
    0.058647264f,     -0.17914726f,     0.056027584f,     -0.0010231141f,
    -0.11976835f,     -0.0479666f,      -0.18322475f,     -0.09234235f,
    0.12177314f,      -0.001073517f,    -0.00041024937f,  0.0027656294f,
    -0.10717014f,     -0.09432368f,     0.00089209434f,   0.09821601f,
    -0.093819425f,    0.0392756f,       0.00050283165f,   -0.13122919f,
    -0.049590714f,    0.22643135f,      0.114201166f,     0.1930941f,
    0.15799318f,      -0.15698558f,     0.11330552f,      0.05707332f,
    -0.01931407f,     -0.07615601f,     -0.190358f,       0.115689486f,
    0.29868147f,      0.26214716f,      0.073968075f,     -0.294898f,
    -0.24175784f,     0.17589416f,      -0.27745792f,     -0.10191231f,
    -0.089912556f,    -0.14531028f,     -0.037774514f,    0.054935392f,
    -0.08815384f,     0.30600286f,      0.021281539f,     0.11163488f,
    -0.2806904f,      -0.08377793f,     -0.0003373296f,   0.25698677f,
    -0.09372757f,     0.0003124472f,    -0.0016112584f,   0.0033618717f,
    -0.0012186f,      0.0002474503f,    0.0016050598f,    0.305441f,
    0.0014631703f,    -0.08110663f,     0.0004203331f,    -0.29626945f,
    -0.08452557f,     -0.2335229f,      -0.3915979f,      -0.003352527f,
    -0.26286593f,     -0.11437089f,     0.34702507f,      0.015164191f,
    0.27905312f,      -8.584331e-05f,   -0.001515812f,    -0.0014725646f,
    -0.22591262f,     -0.26071778f,     0.00015348721f,   0.25016809f,
    -0.25719815f,     0.33456498f,      -0.00021781925f,  -0.11384007f,
    -0.13193499f,     0.06937117f,      0.21919402f,      0.21284065f,
    0.06282125f,      0.010206482f,     -0.04854617f,     -0.06433265f,
    0.15780976f,      -0.08521135f,     -0.0552688f,      0.07648279f,
    -0.000105759915f, 0.046651427f,     -0.027792232f,    0.015003046f,
    0.041954067f,     0.031171903f,     0.010691694f,     0.027771823f,
    -0.12541679f,     -0.02871341f,     0.021159546f,     0.024870735f,
    -0.15170784f,     0.0052339653f,    0.10481468f,      -0.00015563161f,
    0.006126591f,     0.050319027f,     -0.0007278556f,   0.057768643f,
    -0.10945795f,     0.00015135139f,   -9.6681084e-05f,  -0.0012627975f,
    0.001964129f,     -0.0014381139f,   -0.00028544114f,  0.032275494f,
    -0.0009819171f,   0.011005658f,     0.0015968884f,    -0.02018439f,
    -0.07310269f,     -0.031698555f,    -0.06435974f,     0.00032200725f,
    -0.04301263f,     0.07116481f,      0.039700646f,     0.0003244304f,
    -0.047405045f,    -0.00078485504f,  0.00013456093f,   -0.0005822239f,
    -0.0017034434f,   -0.007983226f,    -0.00011821248f,  0.14862324f,
    -0.021435147f,    0.0069105006f,    0.0007702794f,    0.031719793f,
    -0.050225776f,    0.07218255f,      -0.090579495f,    0.073710114f,
    -0.053777803f,    0.06658837f,      -0.2124974f,      0.015977008f,
    -0.009416467f,    0.11146849f,      -0.00057584414f,  0.047275122f,
    0.7819755f,       0.37960657f,      0.032726932f,     -0.28089267f,
    0.22352634f,      -0.124012135f,    -0.4067042f,      -0.30481738f,
    -0.35138217f,     -0.23154616f,     -0.10113122f,     0.3372841f,
    -0.27024212f,     0.2749921f,       -0.09876541f,     0.13186601f,
    0.0729661f,       -0.19797584f,     0.0011230787f,    0.19600861f,
    0.16111374f,      0.0005952964f,    0.00046917095f,   0.0044456893f,
    0.00074046745f,   -0.00024113739f,  -0.0016018482f,   0.2107063f,
    0.0005836703f,    -0.1405683f,      -0.0016807341f,   -0.10318609f,
    0.12230227f,      0.053132042f,     -0.23962012f,     -0.0012194297f,
    0.02698646f,      -0.14691155f,     0.42727014f,      0.09681635f,
    -0.16737947f,     -0.00049130415f,  4.6706093e-05f,   0.0014882906f,
    -0.09899148f,     -0.025237521f,    0.0008506514f,    0.05678944f,
    -0.51851976f,     0.106662266f,     -0.00023312223f,  -0.007294082f,
    -0.13186568f,     0.23598932f,      0.20316912f,      0.56684756f,
    -0.07514189f,     -0.20775925f,     -0.11928929f,     0.2009487f,
    0.61646104f,      -0.049605228f,    -0.022526942f,    -0.028901607f,
    0.21188301f,      0.2405262f,       -0.07698339f,     -0.13883154f,
    -0.055531032f,    -0.23755586f,     0.28573525f,      0.039924134f,
    -0.92066514f,     -0.013998177f,    -0.12727387f,     0.39527923f,
    0.07067632f,      0.18060374f,      0.17610773f,      0.05328483f,
    -0.30852005f,     -0.38139275f,     0.00095413503f,   0.30039337f,
    0.1905554f,       -0.0005604877f,   0.0019473531f,    0.0032517503f,
    0.000105085295f,  -0.0014810745f,   0.0004614404f,    0.20663594f,
    0.0007600265f,    -0.12085086f,     -0.001049271f,    0.09087086f,
    0.05694037f,      -0.3447076f,      -0.094695434f,    0.00016782313f,
    -0.29503787f,     -0.36681268f,     0.2186472f,       -0.14170705f,
    0.48793033f,      0.0011960845f,    -6.0225444e-05f,  0.0005331284f,
    -0.16001727f,     0.037432104f,     -0.00021726727f,  0.3313267f,
    -0.30647025f,     0.27082065f,      9.696875e-05f,    -0.3078035f,
    -0.13088626f,     0.3703761f,       0.42197177f,      0.38427252f,
    0.046711482f,     -0.060444854f,    0.20956452f,      -0.027387593f,
    -0.0630872f,      -0.1215458f,      -0.52661675f,     -0.20935565f,
    0.024492472f,     -0.016881354f,    0.16144817f,      -0.08910459f,
    -0.0062574907f,   0.16621156f,      -0.24252848f,     0.019117627f,
    -0.11481769f,     0.09575249f,      -0.2489869f,      0.15461926f,
    0.008766686f,     0.03397709f,      -0.044533845f,    0.13077663f,
    -0.093519755f,    -0.13370542f,     -0.0009880499f,   0.16824177f,
    0.03804728f,      0.00013228359f,   -0.0006708246f,   -0.00074446324f,
    0.00062624254f,   -0.000888779f,    0.0017322112f,    0.29813492f,
    -0.0002525616f,   -0.074124694f,    -0.00070914155f,  0.06684922f,
    0.047701273f,     -0.1859139f,      0.18864714f,      -0.00014441999f,
    -0.13065147f,     -0.15519713f,     -0.24286537f,     -0.15781882f,
    0.07999241f,      0.000107657994f,  -0.00068279414f,  0.00197629f,
    -0.049114153f,    -0.14700195f,     0.00040130405f,   0.1592251f,
    -0.07373872f,     0.06720582f,      0.00010335832f,   -0.10612066f,
    -0.055031408f,    0.22272371f,      0.1434928f,       0.18940821f,
    0.14842473f,      -0.076275304f,    0.09673068f,      0.030849341f,
    -0.20372473f,     -0.09014026f,     -0.29433846f,     0.09902034f,
    -0.030464545f,    0.11649623f,      0.12869562f,      -0.20195954f,
    -0.19043362f,     0.16854297f,      -0.13012888f,     -0.019627841f,
    -0.28480238f,     -0.07435787f,     -0.16502301f,     0.19245888f,
    0.0041489615f,    0.09214485f,      0.15674093f,      0.09973851f,
    -0.16423099f,     -0.07790619f,     -6.373771e-05f,   0.16479565f,
    0.057664227f,     -0.00039432113f,  0.0013715369f,    0.00078244327f,
    0.00029224393f,   0.00017986198f,   -0.0003319592f,   0.24195845f,
    -7.136538e-05f,   -0.13562295f,     -0.0009330537f,   -0.07413395f,
    0.08342456f,      -0.1531793f,      -0.19517791f,     0.0014851436f,
    -0.029484965f,    0.0019428473f,    0.05708113f,      -0.22925201f,
    0.14619619f,      0.0012510264f,    0.00010126081f,   -0.00039054087f,
    -0.24597648f,     -0.16584426f,     0.0012137925f,    0.07583404f,
    -0.080799356f,    0.06291083f,      -0.0005715941f,   -0.15605198f,
    -0.079308845f,    0.22947453f,      0.1257745f,       0.10959081f,
    0.10915291f,      -0.24638739f,     0.09495566f,      0.018052334f,
    0.104932375f,     0.09752504f,      -0.033455282f,    0.091736406f,
    0.035121918f,     -0.012224042f,    0.22503045f,      0.061404042f,
    0.061417434f,     0.23071504f,      -0.3621861f,      0.13237453f,
    0.117269084f,     0.06162475f,      -0.09451764f,     0.048419945f,
    0.06916532f,      0.0053150714f,    -0.033620935f,    0.17620307f,
    -0.18929145f,     -0.002844624f,    -9.9965415e-05f,  0.09864692f,
    0.083141685f,     -0.00091813994f,  0.001027421f,     0.002598562f,
    -0.0007772475f,   -0.0005799527f,   -0.000345613f,    0.03559359f,
    1.3618232e-05f,   -0.030749649f,    0.00166383f,      -0.09849389f,
    0.084165625f,     -0.20742437f,     -0.039403766f,    -0.00036932822f,
    -0.13116321f,     0.048433453f,     -0.23493613f,     -0.019685412f,
    0.19204646f,      -0.0004987876f,   0.0011031931f,    0.0015117436f,
    -0.07586934f,     -0.011957115f,    -0.0009661896f,   0.014168324f,
    -0.1322504f,      -0.025543833f,    0.0007655066f,    -0.1791975f,
    -0.0354948f,      0.26307458f,      0.067958094f,     0.16245238f,
    0.17857556f,      -0.2487354f,      0.14598061f,      0.101946756f,
    0.2606762f,       -0.034242064f,    -0.085982434f,    0.15560189f,
    0.026411422f,     0.13713774f,      0.10322281f,      -0.28045142f,
    -0.13542414f,     0.1126471f,       -0.08351562f,     -0.021793375f,
    -0.069792636f,    -0.06193541f,     -0.1355032f,      0.23030072f,
    -0.008712008f,    0.1086681f,       0.049721364f,     0.11688141f,
    -0.12506393f,     -0.093063764f,    -0.00022386128f,  -0.0042830775f,
    0.041699823f,     0.00091184967f,   -0.0008109525f,   0.0007483593f,
    0.00063271314f,   0.00017271233f,   -0.0010361911f,   0.30264372f,
    0.0011931764f,    -0.21438636f,     -0.0009880414f,   -0.05016851f,
    0.046963703f,     -0.1658036f,      -0.054138843f,    -0.0019725554f,
    -0.082764916f,    -0.108746596f,    0.1445346f,       -0.04755063f,
    0.006570218f,     0.00064893806f,   -0.0020688786f,   -0.0007024708f,
    -0.13259014f,     -0.16289094f,     -0.00079884334f,  0.073627755f,
    -0.05793583f,     0.14488252f,      -0.00014863299f,  -0.051708512f,
    -0.065319195f,    0.17627119f,      0.13228054f,      0.18569076f,
    0.13333867f,      -0.117186874f,    0.0960516f,       0.016215788f,
    -0.07810702f,     -0.046588793f,    -0.029425072f,    0.07355302f,
    0.07738787f,      0.2557216f,       -0.047978766f,    -0.27457714f,
    -0.31406286f,     -0.0053909714f,   0.066081f,        -0.035749525f,
    -0.18250392f,     -0.026767071f,    -0.31639242f,     0.32746947f,
    0.028152136f,     0.084041044f,     0.16643167f,      0.14465159f,
    -0.15841088f,     -0.059944704f,    0.00037152212f,   0.21763429f,
    -0.02603681f,     0.00090665446f,   0.0020251533f,    0.0011215573f,
    -2.717433e-05f,   -0.00023491682f,  -0.00088734174f,  0.19854094f,
    -0.0005235429f,   -0.11500879f,     0.00032298933f,   -0.1693936f,
    0.068874806f,     -0.21195182f,     -0.34234402f,     0.0012092364f,
    -0.013734868f,    -0.065345876f,    0.15181543f,      -0.31960684f,
    0.041757192f,     -0.00014504469f,  -0.00021558063f,  0.0019134348f,
    -0.39524046f,     -0.22582144f,     0.00033609752f,   -0.04095302f,
    -0.31602067f,     0.116914034f,     0.0013048043f,    -0.08292253f,
    -0.113872424f,    -0.020365274f,    0.22901534f,      0.18764251f,
    0.1956499f,       -0.2626187f,      0.09850314f,      0.058685545f,
    0.31424367f,      -0.2335508f,      -0.2822797f,      0.05928327f,
    0.42205566f,      0.13853681f,      -0.07974079f,     -0.2832212f,
    -0.40077317f,     -0.09291479f,     0.063446194f,     0.015596908f,
    0.0844597f,       -0.35864076f,     -0.36622036f,     0.50972474f,
    0.2763414f,       -0.19642599f,     0.25680244f,      0.13327637f,
    0.280801f,        0.27867955f,      -4.9451723e-05f,  0.3051137f,
    0.2847779f,       0.0007782087f,    0.00044070376f,   0.0006270427f,
    0.0011128803f,    0.0015029643f,    -0.0013614559f,   0.030074375f,
    0.0002480896f,    -0.23818453f,     -0.0002574801f,   -0.6114384f,
    -0.17171215f,     -0.091531865f,    -0.61178076f,     -0.0009181718f,
    -0.09674144f,     -0.43262732f,     0.47611755f,      -0.21955332f,
    0.06679015f,      -0.00013488762f,  -0.0008521661f,   0.00013284964f,
    -0.059048936f,    -0.092284955f,    0.000729412f,     0.54624873f,
    0.14149892f,      -0.010856255f,    -0.00030784984f,  -0.21022716f,
    -0.02957234f,     -0.24736041f,     0.4032994f,       0.95253086f,
    0.09457507f,      -0.7544574f,      0.30124426f,      0.021452993f,
    0.4867626f,       -0.11234221f,     -0.3776169f,      -0.01842454f,
    0.07296044f,      0.059598666f,     0.15687276f,      -0.090129316f,
    -0.051758282f,    0.1581658f,       -0.18507338f,     0.032852154f,
    0.05787591f,      0.03077193f,      -0.11312295f,     0.11000684f,
    0.023252424f,     0.005411883f,     -0.001565964f,    0.15286717f,
    -0.20434852f,     -0.045124184f,    -0.0005631562f,   0.06380896f,
    0.06644926f,      0.0019462677f,    0.00090246636f,   -0.00042241448f,
    0.001145699f,     -0.00020297086f,  -0.00033927092f,  0.12988104f,
    0.0015715904f,    -0.11117145f,     -0.00038432778f,  -0.12948954f,
    0.07843687f,      -0.14989915f,     -0.09634396f,     -0.0008795724f,
    -0.100438334f,    0.017410642f,     -0.06870434f,     -0.041504737f,
    0.12913594f,      -0.00044070717f,  -0.0014618066f,   0.00065926235f,
    -0.09094303f,     -0.073152445f,    0.0005479884f,    -0.02734993f,
    -0.084711656f,    0.05207296f,      0.0007967038f,    -0.12827653f,
    -0.043845862f,    0.23764999f,      0.1066041f,       0.14838819f,
    0.1610168f,       -0.1802517f,      0.12617826f,      0.06321095f,
    0.19476289f,      -0.047945622f,    -0.0991064f,      0.10489463f,
    0.31174272f,      0.17876871f,      0.06711954f,      -0.30805537f,
    -0.09571441f,     0.10039818f,      0.07631451f,      -0.067563266f,
    -0.24513783f,     -0.15668078f,     0.056909736f,     0.02675003f,
    0.082459725f,     0.15251064f,      0.24399538f,      0.060841203f,
    -0.341181f,       0.07206688f,      0.00015646809f,   -0.09134007f,
    0.10626247f,      -0.0014722481f,   0.0016895095f,    0.0026997414f,
    -0.0013718642f,   -0.0026647174f,   -0.0008388283f,   0.21276696f,
    0.00016302348f,   -0.36459523f,     -0.0008157907f,   -0.22927396f,
    0.030674934f,     -0.14244416f,     -0.23961757f,     0.0004102089f,
    -0.018435743f,    0.02354291f,      0.15005605f,      -0.18100229f,
    0.1082989f,       0.00046877444f,   -0.0012580721f,   0.0012965286f,
    -0.03979327f,     -0.24586193f,     0.00038768878f,   -0.056720197f,
    0.0029552646f,    0.16940859f,      0.00054960867f,   -0.18932173f,
    -0.10476215f,     0.32681242f,      0.084162846f,     0.14470176f,
    0.053779535f,     -0.102481514f,    0.13140993f,      -0.03354692f,
    0.32360348f,      0.19320127f,      -0.024356121f,    0.0052966923f,
    0.40523493f,      0.4961438f,       0.13982563f,      -0.0073457737f,
    -0.46968096f,     0.14894502f,      -0.46269745f,     -0.35036552f,
    -0.10770597f,     -0.08109542f,     -0.6809037f,      0.20223145f,
    0.026866978f,     0.37773642f,      0.481438f,        0.104779094f,
    -0.135136f,       -0.08121235f,     0.0014552904f,    -0.063278526f,
    -0.028707743f,    0.00043295178f,   -0.0011517673f,   0.0015288516f,
    -0.0006172075f,   0.00083851983f,   0.0010456812f,    0.015699986f,
    -0.0006724034f,   -0.12893185f,     -0.0004979344f,   -0.32698557f,
    0.011288584f,     -0.23095176f,     -0.26603374f,     0.0017219866f,
    -0.17028666f,     -0.710411f,       0.46758682f,      -0.21591221f,
    0.27160272f,      0.0002814904f,    -0.0004901826f,   0.0005413975f,
    -0.3787354f,      -0.0050373203f,   -0.00043052144f,  0.3120307f,
    0.2226326f,       0.049312748f,     0.00134029f,      0.03945995f,
    -0.14459096f,     -0.12290306f,     0.1918625f,       0.48828527f,
    -0.057478f,       -0.23646961f,     -0.07343593f,     0.2716123f,
    0.6543835f,       -0.24275112f,     -0.4466551f,      0.16535279f,
    -0.24794684f,     0.06146467f,      0.1741455f,       0.016206011f,
    -0.58245933f,     0.05943577f,      -0.72296065f,     -0.025982741f,
    -0.048478547f,    0.08963077f,      0.06716503f,      -0.10923459f,
    -0.040528614f,    0.1097888f,       0.015184581f,     0.10107837f,
    -0.32443064f,     -0.21291958f,     8.499812e-07f,    -0.039312884f,
    0.14752653f,      -7.9339705e-05f,  -0.0018961631f,   0.0029354626f,
    0.00020818063f,   0.0016619798f,    -0.00058926124f,  -0.1210048f,
    0.0001596731f,    -0.28751472f,     0.00074896874f,   -0.47536534f,
    0.053027313f,     -0.1765512f,      -0.3640063f,      8.519853e-05f,
    -0.1330372f,      0.23279732f,      0.109615155f,     -0.042836286f,
    0.17726311f,      0.0026858815f,    -0.0006007497f,   -0.0013181655f,
    -0.29374623f,     -0.057609208f,    -0.00089213555f,  -0.019780876f,
    -0.6995654f,      0.12351426f,      0.001998336f,     -0.0545277f,
    -0.064403966f,    0.20872726f,      -0.14296092f,     -0.33345452f,
    0.07298847f,      0.09911219f,      0.09460208f,      0.044550173f,
    0.44307455f,      -0.16802725f,     0.022962427f,     0.00833525f,
    4.97077e-05f,     -0.0025146164f,   2.3117947e-05f,   1.5305355e-05f,
    0.0014284846f,    -0.00043277646f,  0.0002974285f,    0.00020736989f,
    -0.0009878314f,   -0.0017866966f,   0.00021069967f,   -0.0007617949f,
    0.00066416775f,   0.0011071039f,    0.0010781359f,    -0.0030748479f,
    -0.0006112805f,   0.00050828373f,   0.002579913f,     0.0011911138f,
    -0.0017789172f,   0.0015459605f,    -0.0004226936f,   0.00028610375f,
    -0.0009467246f,   -0.00051378185f,  0.00048906205f,   0.0006118919f,
    0.0008442935f,    -0.0006955137f,   0.00077861064f,   -0.0008063557f,
    -0.001883144f,    0.0027368502f,    0.00053875294f,   0.0017444468f,
    0.0010496001f,    0.00025057903f,   0.0010602751f,    0.0009044824f,
    -0.000902058f,    -0.0009210604f,   -0.0004078885f,   -0.0010924989f,
    0.0005280947f,    0.001131681f,     -0.00079595903f,  0.0010164365f,
    -6.4724394e-05f,  -0.001669948f,    -0.0007493608f,   -0.0006797113f,
    -0.00096428354f,  -0.0027087813f,   -0.0005998702f,   0.00010552174f,
    -0.0009133604f,   -0.0018779592f,   2.6404981e-05f,   -6.8630325e-05f,
    -0.00070410833f,  0.0013223381f,    -0.00032540818f,  -0.0013105972f,
    0.20083061f,      0.23285945f,      0.03252332f,      -0.36512387f,
    -0.46887743f,     -0.265068f,       -0.33263403f,     -0.06471677f,
    -0.7383082f,      -0.1875872f,      -0.20191927f,     0.28061122f,
    0.18357536f,      -0.0011513835f,   -0.2707649f,      0.20028293f,
    -0.28471005f,     -0.19433282f,     -0.0007925034f,   0.0050944756f,
    0.21328585f,      0.0005703604f,    -0.00047423824f,  0.001109711f,
    -0.00021286675f,  0.001028736f,     -0.00041788933f,  0.17428972f,
    4.756429e-05f,    -0.22718473f,     0.0015285582f,    -0.060056396f,
    -0.044657823f,    -0.08158594f,     0.15957323f,      -0.0010575406f,
    -0.2203644f,      -0.27886555f,     0.28295124f,      -0.023275787f,
    0.0360999f,       0.0005879832f,    0.0012141725f,    -0.0008610975f,
    -0.09079776f,     -0.092000864f,    9.190638e-05f,    0.11324893f,
    -0.2439542f,      0.20444489f,      -0.0013475574f,   0.004330551f,
    -0.016179958f,    0.50164914f,      0.52225506f,      0.11929946f,
    0.07638437f,      -0.12463428f,     0.16021802f,      0.1488709f,
    -0.06664828f,     -0.33419695f,     0.4498346f,       -0.16605113f,
    -0.28657612f,     0.10606736f,      0.19532411f,      -0.0186733f,
    -0.35253015f,     0.17785898f,      -0.69524735f,     -0.03807841f,
    -0.2794249f,      -0.085839406f,    0.009105074f,     -0.1147554f,
    0.043652132f,     0.23203202f,      0.14618064f,      0.031703696f,
    -0.11271949f,     -0.15111448f,     4.3559547e-05f,   0.052462835f,
    0.21248154f,      -0.00018582691f,  7.506563e-06f,    0.0030571287f,
    0.0004258465f,    -0.00036943474f,  0.0002402889f,    0.2340277f,
    0.0011033815f,    -0.31993142f,     0.001266017f,     -0.07348215f,
    0.0072665033f,    -0.3315318f,      -0.08673961f,     -0.0005167861f,
    -0.14679645f,     0.025496665f,     0.05632868f,      -0.20351659f,
    0.16413918f,      -0.0010637916f,   0.00091375865f,   -0.002721659f,
    -0.38258338f,     -0.10243466f,     6.492738e-05f,    0.14496568f,
    -0.5215506f,      0.19252887f,      0.0005748152f,    -0.021673772f,
    -0.110836215f,    0.21385463f,      0.03116424f,      -0.18227392f,
    0.03188356f,      -0.011020283f,    0.11781264f,      -0.0004974041f,
    -0.06301444f,     0.034830175f,     -0.052280452f,    0.045389324f,
    0.0005521098f,    0.01772917f,      -0.17225818f,     0.0037039423f,
    0.0015673604f,    -0.10055038f,     0.021108633f,     0.020772647f,
    0.14595065f,      -0.04253008f,     0.013751122f,     0.007689795f,
    0.041917972f,     0.016940184f,     0.002107906f,     -0.06683443f,
    0.020539016f,     0.029143851f,     -7.801321e-05f,   0.0004836811f,
    -0.017668154f,    -0.0005448151f,   0.0010524365f,    -0.0007671644f,
    -0.00012459021f,  0.0008768695f,    -0.00051357795f,  -0.0037997859f,
    0.0003861398f,    0.014108769f,     0.00069321576f,   -0.006722216f,
    -0.020900667f,    0.026551543f,     -0.0011496779f,   -0.00075074355f,
    0.028344141f,     0.009201196f,     0.0057718405f,    0.021699302f,
    -0.014502635f,    -3.4917146e-05f,  -0.00035786058f,  -0.0011784286f,
    0.060572445f,     0.020316433f,     -0.0011969139f,   -0.04873412f,
    0.023842258f,     -0.023542333f,    0.0017061911f,    0.021966225f,
    0.00033679532f,   -0.19098286f,     0.06507214f,      -0.025174895f,
    -0.045645624f,    0.03047322f,      -0.03555776f,     0.019031342f,
    0.025006592f,     0.002873845f,     0.013087436f,     -0.017678551f,
    0.57228166f,      0.44931725f,      0.033467986f,     -0.052152947f,
    -0.16510761f,     0.095149025f,     -0.25350976f,     -0.31727728f,
    0.020857004f,     0.01630847f,      -0.0931435f,      0.1957119f,
    -0.39591384f,     0.2692201f,       0.33176333f,      0.11175347f,
    -0.2671032f,      -0.056412164f,    -0.001511809f,    0.29373026f,
    0.17934428f,      -0.0010251943f,   0.0010095476f,    0.0035850229f,
    0.00065879535f,   0.00093925773f,   0.00033792327f,   0.34793642f,
    -0.00042587394f,  -0.08081586f,     0.00038307233f,   -0.011362356f,
    -0.0033058012f,   -0.08819704f,     -0.32478446f,     -0.0011537038f,
    -0.27391264f,     -0.11553899f,     0.17199908f,      -0.0041303267f,
    0.41343948f,      0.000357048f,     0.0014987858f,    0.0013575226f,
    -0.5571183f,      -0.2880887f,      -0.002448622f,    0.17940249f,
    -0.20062222f,     0.3171509f,       0.0008355412f,    -0.07066481f,
    -0.13722952f,     -0.10970398f,     0.058733325f,     0.24034949f,
    0.18251064f,      0.11015398f,      0.24339579f,      -0.041504826f,
    0.19960985f,      -0.15185966f,     -0.2734284f,      0.13767993f,
    0.22348885f,      -0.008877726f,    -0.17189537f,     -0.43331224f,
    0.2023295f,       0.04317003f,      -0.3600444f,      -0.0067409207f,
    0.18264559f,      -0.11805032f,     -0.07412461f,     0.03241709f,
    0.051556725f,     0.085615896f,     0.40916997f,      -0.07864307f,
    -0.22887087f,     -0.24392724f,     0.00014124371f,   0.6468839f,
    -0.036077045f,    -0.0014531002f,   -0.0011161002f,   0.003305897f,
    0.0017938324f,    -3.750653e-05f,   -0.0016759017f,   0.4013441f,
    -0.00073333486f,  -0.28097916f,     -0.0010191813f,   0.019602012f,
    0.09314859f,      -0.53062683f,     0.1758001f,       -1.5525151e-05f,
    -0.20916408f,     -0.66344565f,     -0.14848995f,     -0.065955415f,
    -0.034880806f,    -1.1966582e-06f,  0.00036120228f,   -0.0012568037f,
    -0.10609765f,     -0.58169466f,     -0.0006648826f,   0.44565904f,
    -0.5121707f,      0.24637467f,      0.0010917422f,    -0.23795755f,
    -0.2328576f,      -0.0765637f,      0.330303f,        0.27319f,
    0.094247416f,     -0.16981891f,     0.017022926f,     -0.10659436f,
    0.11089696f,      -0.08941251f,     -0.3529318f,      0.0654588f
};

static const float conv2_biases[] = {
    0.12326373f,      0.13270757f,      0.07082674f,      0.051456157f,
    0.058445618f,     0.13153197f,      0.0809729f,       0.10153213f,
    0.055915363f,     0.05228166f,      -0.11212896f,     0.07462141f,
    -0.10300769f,     0.10817513f,      0.15686865f,      0.1822583f,
    0.06780991f,      -0.027867194f,    0.10957543f,      0.034252886f,
    0.05988423f,      -0.0481856f,      0.074781254f,     -0.07338138f,
    -0.022100607f,    -0.049476217f,    0.0001618523f,    0.16787314f,
    -0.086404406f,    0.06046943f,      -0.1733751f,      0.2654999f
};

static const float conv3_kernel[] = {
    -0.01733648f,     0.01492609f,      0.019393086f,     -0.004445322f,
    0.026939709f,     0.00038831023f,   0.004221528f,     0.0050745453f,
    0.0129861f,       0.008007169f,     0.008950762f,     0.005279691f,
    0.015198747f,     -0.010862989f,    0.011825689f,     -0.019965801f,
    0.007991939f,     -0.004620696f,    0.011911056f,     0.0043943473f,
    -0.015274506f,    0.007058924f,     0.010290278f,     0.013065045f,
    -0.010343008f,    0.017746344f,     -4.6092932e-06f,  -0.0030044178f,
    0.004238005f,     0.011623516f,     0.0042921947f,    0.0036016756f,
    0.025046846f,     -0.012476416f,    -0.001889116f,    -0.014844696f,
    0.0037114194f,    0.0015292391f,    -0.019609794f,    -0.02383642f,
    -0.004658454f,    -0.0054208986f,   -0.011578674f,    -0.012782601f,
    -0.013413185f,    -0.002697888f,    -0.008449232f,    -0.001977387f,
    -0.009994492f,    -0.019018622f,    -0.014209286f,    -0.010814857f,
    -0.012635752f,    -0.025710505f,    -0.011209325f,    0.0061852434f,
    -0.028722698f,    -0.01599159f,     -7.26217e-06f,    0.0059218574f,
    -0.0127538005f,   0.004631822f,     -0.012866009f,    -0.015347815f,
    0.015386375f,     0.023364263f,     -0.008774849f,    0.00033160704f,
    -0.013394288f,    0.018397791f,     -0.0010600976f,   0.0013282642f,
    -0.0046541207f,   -0.0034810272f,   -0.038735237f,    0.0043200655f,
    -0.012688318f,    0.005344532f,     -0.029875176f,    0.009807407f,
    0.013965515f,     -0.0039542704f,   -0.0025950125f,   -0.010605341f,
    -0.02215936f,     -0.04049196f,     -0.0082667265f,   -0.01930975f,
    -0.0053983186f,   -0.027176432f,    -7.683407e-06f,   0.0058844145f,
    -0.002555462f,    0.0031520976f,    0.0077376286f,    -0.0016007262f,
    0.009788385f,     -0.00019503673f,  -0.01645315f,     -0.009283056f,
    -0.023557188f,    0.019991314f,     -0.0016918116f,   0.006789462f,
    -0.015027259f,    -0.013967355f,    -0.025483066f,    -0.0011143273f,
    -0.024852922f,    -0.0025222464f,   -0.0068101967f,   -0.0052228663f,
    0.003403729f,     -0.0057572993f,   3.0098856e-05f,   -0.016694108f,
    -0.026578246f,    -0.055858552f,    -0.01040826f,     -0.024491757f,
    -0.013739718f,    -0.0016934959f,   -6.9714324e-06f,  0.016726777f,
    0.0128034875f,    0.0015065578f,    -0.009287698f,    -0.026466f,
    0.011461019f,     0.012902507f,     0.0113832615f,    -0.014642437f,
    0.0025061562f,    -0.005041358f,    0.02081145f,      0.036239613f,
    4.436463e-05f,    -0.006089515f,    -0.004598781f,    0.013829105f,
    -0.009625029f,    -0.0024851824f,   0.011963721f,     0.005744088f,
    0.004409838f,     -0.0028752747f,   0.037273f,        -0.0079703685f,
    -0.023841897f,    -0.020694682f,    0.01830098f,      -0.0013982734f,
    -0.02932626f,     0.039605323f,     -4.9999985e-06f,  0.0021212643f,
    0.017022226f,     0.0030793506f,    0.0041403836f,    -0.024156462f,
    -0.0066918465f,   0.014618277f,     0.008809711f,     -0.0030973074f,
    0.0045377472f,    0.022115124f,     0.0010284728f,    -0.011907029f,
    0.0037738825f,    -0.0034918108f,   -0.0019704925f,   -0.0022535324f,
    -0.00088587066f,  -0.009839005f,    -0.011421483f,    0.021808833f,
    -0.0011487964f,   -0.0041014133f,   -0.00041377658f,  -0.0025395507f,
    -0.01745589f,     -0.01648567f,     0.0025676503f,    0.007391396f,
    -0.0498155f,      -0.008180997f,    -5.9783792e-06f,  0.017585661f,
    -0.0118313795f,   0.011075241f,     -0.018345809f,    -0.028922094f,
    -0.008543231f,    -0.02222561f,     0.0019820202f,    -0.017327564f,
    -0.0028896166f,   -0.016437765f,    -0.001989804f,    -0.0046544564f,
    -0.0056253797f,   -0.012663842f,    -0.0021303114f,   -0.0058640097f,
    -0.0205096f,      -0.004189838f,    -0.0015994223f,   -0.014543072f,
    -0.012980198f,    -0.0121102035f,   0.005697437f,     -0.011343842f,
    -0.0062731286f,   -0.020269396f,    0.0020659557f,    -0.006627211f,
    -0.036355212f,    -0.009883279f,    -6.2108943e-06f,  -0.026439881f,
    -0.028891966f,    -0.0013150872f,   -0.023601664f,    -0.010725725f,
    -0.021831911f,    0.039243896f,     0.02405675f,      0.016758442f,
    0.022510681f,     -0.01064172f,     0.018528724f,     0.018505385f,
    0.022858057f,     0.019767428f,     0.009467928f,     0.021334583f,
    0.0067010755f,    0.004998492f,     0.013553347f,     -0.01105016f,
    0.02129068f,      0.017781539f,     0.023486389f,     0.0162607f,
    0.024738412f,     0.065497056f,     0.020338254f,     0.01718703f,
    -0.005591356f,    -0.03028207f,     -3.964172e-06f,   -0.040100023f,
    -0.023673696f,    0.0031255803f,    0.0036818883f,    0.035654947f,
    -0.047790267f,    -0.011736183f,    -0.0069964877f,   -0.003726638f,
    -0.0044415067f,   -0.013957539f,    -0.014418042f,    -0.015041264f,
    -0.004064843f,    -0.0018137591f,   -0.01949818f,     -0.0090175895f,
    -0.022034407f,    -0.001782488f,    -0.022081478f,    -0.023862911f,
    -0.011861376f,    -0.00936943f,     -0.011684311f,    -0.0027838491f,
    0.0015959303f,    0.013797303f,     -0.009703001f,    -0.016293306f,
    -0.0022775405f,   -0.058384087f,    -5.6584126e-06f,  -0.010031882f,
    -0.051561147f,    -0.0016375213f,   -0.033828776f,    -0.0148600275f,
    0.010203641f,     -0.016776482f,    -0.008142655f,    -0.01547684f,
    -0.009880787f,    -0.009551424f,    0.005242979f,     0.025618557f,
    -0.011334289f,    -0.010230681f,    -0.0072891423f,   0.0014259676f,
    -0.0038161008f,   -9.1096605e-05f,  -0.010165611f,    0.01248974f,
    -0.0056803133f,   -0.010443034f,    0.01642791f,      -0.009935266f,
    -0.022226503f,    0.015649764f,     0.0014033179f,    -0.026624054f,
    -0.007203012f,    0.025398765f,     -6.032417e-06f,   0.022034394f,
    0.024220204f,     -0.00249235f,     -0.0025713376f,   -0.024256963f,
    0.028391067f,     -0.00868123f,     -0.0075459606f,   -0.0066171824f,
    -0.021044472f,    -0.01444006f,     -0.0069368226f,   -0.029412558f,
    -0.011166023f,    -0.018498935f,    -0.0005780625f,   -0.014950569f,
    -0.0052538686f,   -0.0052208332f,   -0.028963478f,    0.021637194f,
    -0.01934784f,     -0.011709429f,    -0.014264274f,    -0.011820941f,
    0.0029874442f,    -0.043465607f,    -0.008389515f,    -0.020286206f,
    0.018381242f,     0.009402076f,     -6.4926458e-06f,  0.023731612f,
    -0.012512443f,    0.0038244938f,    -0.009620792f,    -0.07217538f,
    -0.013373111f,    -0.03408812f,     0.018013516f,     0.031104652f,
    0.004108333f,     -0.031565364f,    0.02258793f,      0.0012497875f,
    0.018505631f,     0.015937509f,     0.03397117f,      0.018751027f,
    0.028309336f,     0.0013284454f,    -0.0034242184f,   -0.049040183f,
    0.017518098f,     0.029354956f,     0.012375129f,     0.021071019f,
    0.043245573f,     -0.0017072117f,   0.01917091f,      0.020050293f,
    0.044324838f,     0.0003568086f,    -3.782557e-06f,   -0.054970123f,
    0.00025986708f,   -0.0030980753f,   0.042019118f,     -0.014718047f,
    0.09136182f,      0.050251998f,     0.047536176f,     0.055385035f,
    0.043843225f,     0.09153757f,      0.055850364f,     0.057650816f,
    0.049471464f,     0.049772345f,     0.06513509f,      0.05598534f,
    0.07879935f,      0.041162334f,     0.116581365f,     0.116215944f,
    0.055703893f,     0.061708055f,     0.055691358f,     0.050106917f,
    0.05359711f,      0.118190065f,     0.051873844f,     0.05305469f,
    0.094883814f,     0.05972008f,      0.03125f,         0.09262255f,
    0.07122859f,      0.035595007f,     0.10132693f,      0.033046674f,
    0.008198932f,     0.00034837422f,   0.017919436f,     0.0019723712f,
    0.028092925f,     -0.033846084f,    -0.0029948805f,   0.007743469f,
    0.014146284f,     0.018825071f,     0.0144004915f,    0.0019946275f,
    0.02691827f,      0.0009523414f,    0.027027654f,     -0.05271302f,
    -0.008234074f,    0.01886295f,      0.009218212f,     0.018653536f,
    0.018532507f,     0.019083755f,     0.011865131f,     0.020338265f,
    0.04508337f,      0.023039978f,     -2.3969303e-06f,  -0.03341738f,
    0.0004288993f,    -0.00082805153f,  0.010723913f,     0.007715867f,
    0.006444959f,     -0.019155774f,    -5.477799e-05f,   -0.020788789f,
    0.00831597f,      0.010842232f,     -0.031902798f,    -0.026402516f,
    -0.006352604f,    -0.0014378208f,   0.009403265f,     -0.023530146f,
    0.03013893f,      0.00095609104f,   0.003455896f,     0.013105751f,
    -0.032454796f,    0.00014958641f,   -0.018464519f,    -0.004078385f,
    0.0037151799f,    -0.034191445f,    -0.012414877f,    0.020487262f,
    0.0046754936f,    -0.0017117449f,   -5.6997096e-06f,  -0.016188936f,
    0.00093793747f,   -0.004474718f,    0.015641531f,     -0.031059852f,
    0.017852167f,     -0.010946748f,    -0.012056041f,    -0.024213046f,
    -0.012465649f,    -0.0064642616f,   -0.0110341925f,   -0.008573409f,
    -0.016811594f,    -0.022378387f,    0.0030896366f,    -0.018295068f,
    -0.0002118988f,   -0.008802077f,    0.0041353963f,    -0.0019236483f,
    -0.02637782f,     -0.017801862f,    -0.0063813925f,   -0.018069087f,
    -0.0036655464f,   0.013736056f,     -0.00926528f,     -0.02779058f,
    -0.012576324f,    0.04333538f,      -7.0378364e-06f,  0.026426876f,
    0.0057986663f,    0.001365942f,     -0.014491761f,    -0.016380578f,
    -0.029815238f,    -0.032532256f,    -0.010090044f,    -0.0075939707f,
    -0.01841759f,     -0.02166566f,     0.0047074873f,    0.0044598053f,
    -0.011068891f,    -0.014538416f,    -0.0127471145f,   -4.54769e-05f,
    -0.018158771f,    -0.0016290377f,   -0.007845909f,    -0.024189549f,
    -0.0060073743f,   -0.013039188f,    0.0067027225f,    -0.012077617f,
    -0.0007322089f,   0.0034031253f,    -0.0008505431f,   -0.017894164f,
    0.027413402f,     -0.039492756f,    -7.2415805e-06f,  -0.01993335f,
    -0.053383633f,    -0.005462685f,    -0.009955281f,    -0.045894638f,
    -0.03423635f,     0.015809828f,     0.007976382f,     0.02872461f,
    0.011486088f,     -0.027824942f,    0.022402626f,     0.029602554f,
    0.01704397f,      0.022052698f,     -0.0047717188f,   0.026639657f,
    -0.011267848f,    0.0033830018f,    -0.015702372f,    -0.03458953f,
    0.03404305f,      0.009690975f,     0.018198043f,     0.018704038f,
    0.004133801f,     0.012773303f,     0.013342909f,     -0.010100413f,
    0.015592217f,     -0.031007571f,    -4.1644485e-06f,  -0.023360938f,
    -0.007369862f,    -0.0021892155f,   -0.0041580168f,   0.040366825f,
    -0.00950825f,     -0.015689341f,    -0.027411446f,    0.0045163934f,
    -0.021237882f,    -0.032169607f,    -0.008436287f,    0.007711113f,
    -0.015981104f,    -0.0058474587f,   -0.016302187f,    -0.0050288388f,
    -0.03451291f,     -0.005411964f,    -0.057007458f,    -0.009519844f,
    0.00060862664f,   -0.01581088f,     -0.013824393f,    -0.0050003896f,
    -0.02759697f,     -0.047302894f,    -0.017540261f,    -0.04141391f,
    -0.041247956f,    -0.012798106f,    -5.4396814e-06f,  -0.00861421f,
    0.0048933798f,    -0.0032665513f,   -0.04772411f,     -0.029737743f,
    -0.013271045f,    -0.009748851f,    0.007987075f,     -0.0041782823f,
    0.012320887f,     0.018136637f,     -0.0102896765f,   -0.012029962f,
    0.0039973888f,    0.0027769876f,    -0.0001612115f,   -0.0068504843f,
    0.00064985076f,   -0.0050650807f,   -0.0097356215f,   0.017527003f,
    -0.0060978164f,   -0.0072428463f,   -0.006019611f,    0.0008342362f,
    -0.023044562f,    -0.013992049f,    -0.002095994f,    0.01103424f,
    -0.024964068f,    -0.014639699f,    -5.8028945e-06f,  0.013127169f,
    -0.012662719f,    -0.0008862268f,   0.0016509607f,    -0.04512324f,
    -0.008125897f,    0.023091309f,     0.01334149f,      -0.0017570563f,
    0.011543835f,     0.0049884785f,    0.022472827f,     0.036539525f,
    0.0076837344f,    0.0037880358f,    0.007956953f,     0.015365968f,
    0.012251683f,     -0.011300079f,    0.01880794f,      -0.0016539369f,
    0.010704212f,     0.01161269f,      0.03027414f,      0.0045915823f,
    -0.02433038f,     -0.01409588f,     0.018684948f,     0.008858194f,
    -0.048040647f,    0.016877763f,     -5.198308e-06f,   0.007284262f,
    0.00596547f,      0.005185987f,     0.0015474685f,    0.0014243163f,
    0.014486665f,     -0.0007930672f,   -0.014664226f,    -0.016457712f,
    -0.017403796f,    0.012685011f,     -0.003883977f,    -2.3890505e-05f,
    -0.016086638f,    -0.019044006f,    0.0041567693f,    -0.0080705f,
    -0.0033578419f,   -0.00516103f,     0.014172151f,     0.0079172775f,
    -0.010331041f,    -0.00818306f,     -0.003031655f,    -0.018925121f,
    -0.025037287f,    -0.018173745f,    -0.008901157f,    -0.006475026f,
    -0.045409832f,    0.007166016f,     -7.5856356e-06f,  0.0012800301f,
    0.00069128914f,   0.005902952f,     -0.0043672016f,   -0.024956075f,
    0.022586409f,     0.03446779f,      -0.012960361f,    -0.0014372625f,
    -0.0144260535f,   0.017766414f,     -0.0053869165f,   -0.005508242f,
    -0.008251171f,    -0.006693737f,    -0.004248834f,    -0.0030098704f,
    0.0014789323f,    -8.2464976e-05f,  -0.012845524f,    0.025194582f,
    0.002518448f,     -0.0049616005f,   -0.010554589f,    -0.010357111f,
    0.005486671f,     -0.021662172f,    -0.011405641f,    -0.006805207f,
    -0.004323462f,    -0.007439297f,    -7.723759e-06f,   -0.021758737f,
    0.008226223f,     0.006653657f,     -0.008580118f,    0.034192834f,
    -0.0004065808f,   0.002096658f,     -0.007829351f,    0.010406952f,
    0.0047818823f,    0.005034751f,     -0.016704533f,    -0.016410556f,
    0.0011981578f,    0.009445486f,     -0.00585872f,     -0.0072120475f,
    -0.024534391f,    -0.0071554724f,   -0.014008383f,    0.0050018425f,
    0.00020401525f,   -0.008169618f,    -0.021851186f,    0.008030192f,
    -0.005056478f,    -0.024147807f,    -0.0136337085f,   0.006448823f,
    -0.029981539f,    -0.03735398f,     -6.9212547e-06f,  0.033992097f,
    -0.004451011f,    0.0042461813f,    -0.032517195f,    -0.010747091f,
    -0.0040616756f,   0.002528875f,     0.012356824f,     0.008285874f,
    0.027300466f,     -0.007290054f,    0.0016192659f,    0.0096740825f,
    0.014147036f,     0.015116107f,     0.011294763f,     0.0052219853f,
    0.013473306f,     -0.0070844297f,   0.017487682f,     -0.01886535f,
    0.0091585545f,    -0.011141966f,    0.0050981203f,    0.012889761f,
    -0.019689016f,    0.002859408f,     0.005369896f,     -0.004294142f,
    -0.014502201f,    0.014149459f,     -4.7262542e-06f,  0.0038339125f,
    0.012931146f,     0.0046948805f,    0.013098622f,     -0.015422701f
};

static const float conv3_biases[] = {
    0.05037664f
};

#endif
