//
// MessagePack for C++ static resolution routine
//
// Copyright (C) 2008-2016 FURUHASHI Sadayuki and KONDO Takatoshi
//
//    Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//    http://www.boost.org/LICENSE_1_0.txt)
//
#ifndef MSGPACK_V1_CPP03_MSGPACK_TUPLE_HPP
#define MSGPACK_V1_CPP03_MSGPACK_TUPLE_HPP

#include "msgpack/v1/adaptor/msgpack_tuple_decl.hpp"

namespace msgpack {

/// @cond
MSGPACK_API_VERSION_NAMESPACE(v1) {
/// @endcond

namespace type {

// FIXME operator==
// FIXME operator!=


template <typename T>
struct tuple_type {
    typedef T type;
    typedef T value_type;
    typedef T& reference;
    typedef const T& const_reference;
    typedef const T& transparent_reference;
};

template <typename T>
struct tuple_type<T&> {
    typedef T type;
    typedef T& value_type;
    typedef T& reference;
    typedef const T& const_reference;
    typedef T& transparent_reference;
};

template <typename T>
struct tuple_type<const T&> {
    typedef T type;
    typedef T& value_type;
    typedef T& reference;
    typedef const T& const_reference;
    typedef const T& transparent_reference;
};

/// @cond


template <typename A0>
struct tuple_element<tuple<A0>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};



template <typename A0, typename A1>
struct tuple_element<tuple<A0, A1>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1>
struct tuple_element<tuple<A0, A1>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};



template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 25> : tuple_type<A25> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 >& x) : m_x(x.a25) {}
    typename tuple_type<A25>::reference get() { return m_x; }
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 25> : tuple_type<A25> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a25) {}
    typename tuple_type<A25>::reference get() { return m_x; }
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 26> : tuple_type<A26> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 >& x) : m_x(x.a26) {}
    typename tuple_type<A26>::reference get() { return m_x; }
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 25> : tuple_type<A25> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a25) {}
    typename tuple_type<A25>::reference get() { return m_x; }
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 26> : tuple_type<A26> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a26) {}
    typename tuple_type<A26>::reference get() { return m_x; }
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 27> : tuple_type<A27> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 >& x) : m_x(x.a27) {}
    typename tuple_type<A27>::reference get() { return m_x; }
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 25> : tuple_type<A25> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a25) {}
    typename tuple_type<A25>::reference get() { return m_x; }
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 26> : tuple_type<A26> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a26) {}
    typename tuple_type<A26>::reference get() { return m_x; }
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 27> : tuple_type<A27> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a27) {}
    typename tuple_type<A27>::reference get() { return m_x; }
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 28> : tuple_type<A28> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 >& x) : m_x(x.a28) {}
    typename tuple_type<A28>::reference get() { return m_x; }
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 25> : tuple_type<A25> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a25) {}
    typename tuple_type<A25>::reference get() { return m_x; }
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 26> : tuple_type<A26> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a26) {}
    typename tuple_type<A26>::reference get() { return m_x; }
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 27> : tuple_type<A27> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a27) {}
    typename tuple_type<A27>::reference get() { return m_x; }
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 28> : tuple_type<A28> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a28) {}
    typename tuple_type<A28>::reference get() { return m_x; }
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 29> : tuple_type<A29> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 >& x) : m_x(x.a29) {}
    typename tuple_type<A29>::reference get() { return m_x; }
    typename tuple_type<A29>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A29>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 25> : tuple_type<A25> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a25) {}
    typename tuple_type<A25>::reference get() { return m_x; }
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 26> : tuple_type<A26> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a26) {}
    typename tuple_type<A26>::reference get() { return m_x; }
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 27> : tuple_type<A27> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a27) {}
    typename tuple_type<A27>::reference get() { return m_x; }
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 28> : tuple_type<A28> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a28) {}
    typename tuple_type<A28>::reference get() { return m_x; }
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 29> : tuple_type<A29> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a29) {}
    typename tuple_type<A29>::reference get() { return m_x; }
    typename tuple_type<A29>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A29>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 30> : tuple_type<A30> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 >& x) : m_x(x.a30) {}
    typename tuple_type<A30>::reference get() { return m_x; }
    typename tuple_type<A30>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A30>::reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 0> : tuple_type<A0> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a0) {}
    typename tuple_type<A0>::reference get() { return m_x; }
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 1> : tuple_type<A1> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a1) {}
    typename tuple_type<A1>::reference get() { return m_x; }
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 2> : tuple_type<A2> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a2) {}
    typename tuple_type<A2>::reference get() { return m_x; }
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 3> : tuple_type<A3> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a3) {}
    typename tuple_type<A3>::reference get() { return m_x; }
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 4> : tuple_type<A4> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a4) {}
    typename tuple_type<A4>::reference get() { return m_x; }
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 5> : tuple_type<A5> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a5) {}
    typename tuple_type<A5>::reference get() { return m_x; }
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 6> : tuple_type<A6> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a6) {}
    typename tuple_type<A6>::reference get() { return m_x; }
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 7> : tuple_type<A7> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a7) {}
    typename tuple_type<A7>::reference get() { return m_x; }
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 8> : tuple_type<A8> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a8) {}
    typename tuple_type<A8>::reference get() { return m_x; }
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 9> : tuple_type<A9> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a9) {}
    typename tuple_type<A9>::reference get() { return m_x; }
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 10> : tuple_type<A10> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a10) {}
    typename tuple_type<A10>::reference get() { return m_x; }
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 11> : tuple_type<A11> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a11) {}
    typename tuple_type<A11>::reference get() { return m_x; }
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 12> : tuple_type<A12> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a12) {}
    typename tuple_type<A12>::reference get() { return m_x; }
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 13> : tuple_type<A13> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a13) {}
    typename tuple_type<A13>::reference get() { return m_x; }
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 14> : tuple_type<A14> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a14) {}
    typename tuple_type<A14>::reference get() { return m_x; }
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 15> : tuple_type<A15> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a15) {}
    typename tuple_type<A15>::reference get() { return m_x; }
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 16> : tuple_type<A16> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a16) {}
    typename tuple_type<A16>::reference get() { return m_x; }
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 17> : tuple_type<A17> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a17) {}
    typename tuple_type<A17>::reference get() { return m_x; }
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 18> : tuple_type<A18> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a18) {}
    typename tuple_type<A18>::reference get() { return m_x; }
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 19> : tuple_type<A19> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a19) {}
    typename tuple_type<A19>::reference get() { return m_x; }
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 20> : tuple_type<A20> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a20) {}
    typename tuple_type<A20>::reference get() { return m_x; }
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 21> : tuple_type<A21> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a21) {}
    typename tuple_type<A21>::reference get() { return m_x; }
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 22> : tuple_type<A22> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a22) {}
    typename tuple_type<A22>::reference get() { return m_x; }
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 23> : tuple_type<A23> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a23) {}
    typename tuple_type<A23>::reference get() { return m_x; }
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 24> : tuple_type<A24> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a24) {}
    typename tuple_type<A24>::reference get() { return m_x; }
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 25> : tuple_type<A25> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a25) {}
    typename tuple_type<A25>::reference get() { return m_x; }
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 26> : tuple_type<A26> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a26) {}
    typename tuple_type<A26>::reference get() { return m_x; }
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 27> : tuple_type<A27> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a27) {}
    typename tuple_type<A27>::reference get() { return m_x; }
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 28> : tuple_type<A28> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a28) {}
    typename tuple_type<A28>::reference get() { return m_x; }
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 29> : tuple_type<A29> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a29) {}
    typename tuple_type<A29>::reference get() { return m_x; }
    typename tuple_type<A29>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A29>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 30> : tuple_type<A30> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a30) {}
    typename tuple_type<A30>::reference get() { return m_x; }
    typename tuple_type<A30>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A30>::reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 31> : tuple_type<A31> {
    tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 , A16 , A17 , A18 , A19 , A20 , A21 , A22 , A23 , A24 , A25 , A26 , A27 , A28 , A29 , A30 , A31 >& x) : m_x(x.a31) {}
    typename tuple_type<A31>::reference get() { return m_x; }
    typename tuple_type<A31>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A31>::reference m_x;
};





template <typename A0>
struct const_tuple_element<tuple<A0>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};



template <typename A0, typename A1>
struct const_tuple_element<tuple<A0, A1>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1>
struct const_tuple_element<tuple<A0, A1>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};



template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, 25> : tuple_type<A25> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& x) : m_x(x.a25) {}
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 25> : tuple_type<A25> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a25) {}
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, 26> : tuple_type<A26> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& x) : m_x(x.a26) {}
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 25> : tuple_type<A25> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a25) {}
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 26> : tuple_type<A26> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a26) {}
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, 27> : tuple_type<A27> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& x) : m_x(x.a27) {}
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 25> : tuple_type<A25> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a25) {}
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 26> : tuple_type<A26> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a26) {}
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 27> : tuple_type<A27> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a27) {}
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, 28> : tuple_type<A28> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& x) : m_x(x.a28) {}
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 25> : tuple_type<A25> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a25) {}
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 26> : tuple_type<A26> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a26) {}
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 27> : tuple_type<A27> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a27) {}
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 28> : tuple_type<A28> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a28) {}
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, 29> : tuple_type<A29> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& x) : m_x(x.a29) {}
    typename tuple_type<A29>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A29>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 25> : tuple_type<A25> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a25) {}
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 26> : tuple_type<A26> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a26) {}
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 27> : tuple_type<A27> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a27) {}
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 28> : tuple_type<A28> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a28) {}
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 29> : tuple_type<A29> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a29) {}
    typename tuple_type<A29>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A29>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, 30> : tuple_type<A30> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& x) : m_x(x.a30) {}
    typename tuple_type<A30>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A30>::const_reference m_x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 0> : tuple_type<A0> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a0) {}
    typename tuple_type<A0>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A0>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 1> : tuple_type<A1> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a1) {}
    typename tuple_type<A1>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A1>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 2> : tuple_type<A2> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a2) {}
    typename tuple_type<A2>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A2>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 3> : tuple_type<A3> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a3) {}
    typename tuple_type<A3>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A3>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 4> : tuple_type<A4> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a4) {}
    typename tuple_type<A4>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A4>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 5> : tuple_type<A5> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a5) {}
    typename tuple_type<A5>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A5>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 6> : tuple_type<A6> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a6) {}
    typename tuple_type<A6>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A6>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 7> : tuple_type<A7> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a7) {}
    typename tuple_type<A7>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A7>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 8> : tuple_type<A8> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a8) {}
    typename tuple_type<A8>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A8>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 9> : tuple_type<A9> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a9) {}
    typename tuple_type<A9>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A9>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 10> : tuple_type<A10> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a10) {}
    typename tuple_type<A10>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A10>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 11> : tuple_type<A11> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a11) {}
    typename tuple_type<A11>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A11>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 12> : tuple_type<A12> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a12) {}
    typename tuple_type<A12>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A12>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 13> : tuple_type<A13> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a13) {}
    typename tuple_type<A13>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A13>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 14> : tuple_type<A14> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a14) {}
    typename tuple_type<A14>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A14>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 15> : tuple_type<A15> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a15) {}
    typename tuple_type<A15>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A15>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 16> : tuple_type<A16> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a16) {}
    typename tuple_type<A16>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A16>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 17> : tuple_type<A17> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a17) {}
    typename tuple_type<A17>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A17>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 18> : tuple_type<A18> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a18) {}
    typename tuple_type<A18>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A18>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 19> : tuple_type<A19> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a19) {}
    typename tuple_type<A19>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A19>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 20> : tuple_type<A20> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a20) {}
    typename tuple_type<A20>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A20>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 21> : tuple_type<A21> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a21) {}
    typename tuple_type<A21>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A21>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 22> : tuple_type<A22> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a22) {}
    typename tuple_type<A22>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A22>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 23> : tuple_type<A23> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a23) {}
    typename tuple_type<A23>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A23>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 24> : tuple_type<A24> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a24) {}
    typename tuple_type<A24>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A24>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 25> : tuple_type<A25> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a25) {}
    typename tuple_type<A25>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A25>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 26> : tuple_type<A26> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a26) {}
    typename tuple_type<A26>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A26>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 27> : tuple_type<A27> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a27) {}
    typename tuple_type<A27>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A27>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 28> : tuple_type<A28> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a28) {}
    typename tuple_type<A28>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A28>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 29> : tuple_type<A29> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a29) {}
    typename tuple_type<A29>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A29>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 30> : tuple_type<A30> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a30) {}
    typename tuple_type<A30>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A30>::const_reference m_x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, 31> : tuple_type<A31> {
    const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& x) : m_x(x.a31) {}
    typename tuple_type<A31>::const_reference get() const { return m_x; }
private:
    typename tuple_type<A31>::const_reference m_x;
};


/// @endcond

template <>
struct tuple<> {
    tuple() {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    typedef tuple<> value_type;
    std::size_t size() const { return 0; }
};

/// @cond

template <typename A0>
struct tuple<A0> {
    typedef tuple<A0> value_type;
    std::size_t size() const { return 1; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0) :
        a0(_a0) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
};

template <int N, typename A0>
inline typename type::tuple_element<type::tuple<A0>, N>::reference get(type::tuple<A0>& t)
{ return t.template get<N>(); }
template <int N, typename A0>
inline typename type::const_tuple_element<type::tuple<A0>, N>::const_reference get(type::tuple<A0> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1>
struct tuple<A0, A1> {
    typedef tuple<A0, A1> value_type;
    std::size_t size() const { return 2; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1) :
        a0(_a0), a1(_a1) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
};

template <int N, typename A0, typename A1>
inline typename type::tuple_element<type::tuple<A0, A1>, N>::reference get(type::tuple<A0, A1>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1>
inline typename type::const_tuple_element<type::tuple<A0, A1>, N>::const_reference get(type::tuple<A0, A1> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2>
struct tuple<A0, A1, A2> {
    typedef tuple<A0, A1, A2> value_type;
    std::size_t size() const { return 3; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2) :
        a0(_a0), a1(_a1), a2(_a2) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
};

template <int N, typename A0, typename A1, typename A2>
inline typename type::tuple_element<type::tuple<A0, A1, A2>, N>::reference get(type::tuple<A0, A1, A2>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2>, N>::const_reference get(type::tuple<A0, A1, A2> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3>
struct tuple<A0, A1, A2, A3> {
    typedef tuple<A0, A1, A2, A3> value_type;
    std::size_t size() const { return 4; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
};

template <int N, typename A0, typename A1, typename A2, typename A3>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3>, N>::reference get(type::tuple<A0, A1, A2, A3>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3>, N>::const_reference get(type::tuple<A0, A1, A2, A3> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple<A0, A1, A2, A3, A4> {
    typedef tuple<A0, A1, A2, A3, A4> value_type;
    std::size_t size() const { return 5; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4>, N>::reference get(type::tuple<A0, A1, A2, A3, A4>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple<A0, A1, A2, A3, A4, A5> {
    typedef tuple<A0, A1, A2, A3, A4, A5> value_type;
    std::size_t size() const { return 6; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple<A0, A1, A2, A3, A4, A5, A6> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6> value_type;
    std::size_t size() const { return 7; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7> value_type;
    std::size_t size() const { return 8; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> value_type;
    std::size_t size() const { return 9; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> value_type;
    std::size_t size() const { return 10; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> value_type;
    std::size_t size() const { return 11; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> value_type;
    std::size_t size() const { return 12; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> value_type;
    std::size_t size() const { return 13; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> value_type;
    std::size_t size() const { return 14; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> value_type;
    std::size_t size() const { return 15; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> value_type;
    std::size_t size() const { return 16; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> value_type;
    std::size_t size() const { return 17; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> value_type;
    std::size_t size() const { return 18; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18> value_type;
    std::size_t size() const { return 19; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19> value_type;
    std::size_t size() const { return 20; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20> value_type;
    std::size_t size() const { return 21; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21> value_type;
    std::size_t size() const { return 22; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22> value_type;
    std::size_t size() const { return 23; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23> value_type;
    std::size_t size() const { return 24; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24> value_type;
    std::size_t size() const { return 25; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25> value_type;
    std::size_t size() const { return 26; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
    A25 a25;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26> value_type;
    std::size_t size() const { return 27; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
    A25 a25;
    A26 a26;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27> value_type;
    std::size_t size() const { return 28; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
    A25 a25;
    A26 a26;
    A27 a27;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28> value_type;
    std::size_t size() const { return 29; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
    A25 a25;
    A26 a26;
    A27 a27;
    A28 a28;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29> value_type;
    std::size_t size() const { return 30; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28, typename tuple_type<A29>::transparent_reference _a29) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28), a29(_a29) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
    A25 a25;
    A26 a26;
    A27 a27;
    A28 a28;
    A29 a29;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30> value_type;
    std::size_t size() const { return 31; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28, typename tuple_type<A29>::transparent_reference _a29, typename tuple_type<A30>::transparent_reference _a30) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28), a29(_a29), a30(_a30) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
    A25 a25;
    A26 a26;
    A27 a27;
    A28 a28;
    A29 a29;
    A30 a30;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30> const& t)
{ return t.template get<N>(); }

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31> {
    typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31> value_type;
    std::size_t size() const { return 32; }
    tuple() {}
    tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15, typename tuple_type<A16>::transparent_reference _a16, typename tuple_type<A17>::transparent_reference _a17, typename tuple_type<A18>::transparent_reference _a18, typename tuple_type<A19>::transparent_reference _a19, typename tuple_type<A20>::transparent_reference _a20, typename tuple_type<A21>::transparent_reference _a21, typename tuple_type<A22>::transparent_reference _a22, typename tuple_type<A23>::transparent_reference _a23, typename tuple_type<A24>::transparent_reference _a24, typename tuple_type<A25>::transparent_reference _a25, typename tuple_type<A26>::transparent_reference _a26, typename tuple_type<A27>::transparent_reference _a27, typename tuple_type<A28>::transparent_reference _a28, typename tuple_type<A29>::transparent_reference _a29, typename tuple_type<A30>::transparent_reference _a30, typename tuple_type<A31>::transparent_reference _a31) :
        a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15), a16(_a16), a17(_a17), a18(_a18), a19(_a19), a20(_a20), a21(_a21), a22(_a22), a23(_a23), a24(_a24), a25(_a25), a26(_a26), a27(_a27), a28(_a28), a29(_a29), a30(_a30), a31(_a31) {}
    tuple(msgpack::object const& o) { o.convert(*this); }
    template <int N> typename tuple_element<value_type, N>::reference get()
        { return tuple_element<value_type, N>(*this).get(); }
    template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
        { return const_tuple_element<value_type, N>(*this).get(); }
    
    A0 a0;
    A1 a1;
    A2 a2;
    A3 a3;
    A4 a4;
    A5 a5;
    A6 a6;
    A7 a7;
    A8 a8;
    A9 a9;
    A10 a10;
    A11 a11;
    A12 a12;
    A13 a13;
    A14 a14;
    A15 a15;
    A16 a16;
    A17 a17;
    A18 a18;
    A19 a19;
    A20 a20;
    A21 a21;
    A22 a22;
    A23 a23;
    A24 a24;
    A25 a25;
    A26 a26;
    A27 a27;
    A28 a28;
    A29 a29;
    A30 a30;
    A31 a31;
};

template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
inline typename type::tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, N>::reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>& t)
{ return t.template get<N>(); }
template <int N, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
inline typename type::const_tuple_element<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>, N>::const_reference get(type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31> const& t)
{ return t.template get<N>(); }

/// @endcond

inline tuple<> make_tuple()
{
    return tuple<>();
}

/// @cond

template <typename A0>
inline tuple<A0> make_tuple(typename tuple_type<A0>::transparent_reference a0)
{
    return tuple<A0>(a0);
}

template <typename A0, typename A1>
inline tuple<A0, A1> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1)
{
    return tuple<A0, A1>(a0, a1);
}

template <typename A0, typename A1, typename A2>
inline tuple<A0, A1, A2> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2)
{
    return tuple<A0, A1, A2>(a0, a1, a2);
}

template <typename A0, typename A1, typename A2, typename A3>
inline tuple<A0, A1, A2, A3> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3)
{
    return tuple<A0, A1, A2, A3>(a0, a1, a2, a3);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4>
inline tuple<A0, A1, A2, A3, A4> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4)
{
    return tuple<A0, A1, A2, A3, A4>(a0, a1, a2, a3, a4);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
inline tuple<A0, A1, A2, A3, A4, A5> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5)
{
    return tuple<A0, A1, A2, A3, A4, A5>(a0, a1, a2, a3, a4, a5);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
inline tuple<A0, A1, A2, A3, A4, A5, A6> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6>(a0, a1, a2, a3, a4, a5, a6);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7>(a0, a1, a2, a3, a4, a5, a6, a7);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>(a0, a1, a2, a3, a4, a5, a6, a7, a8);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28, typename tuple_type<A29>::transparent_reference a29)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28, typename tuple_type<A29>::transparent_reference a29, typename tuple_type<A30>::transparent_reference a30)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15, typename A16, typename A17, typename A18, typename A19, typename A20, typename A21, typename A22, typename A23, typename A24, typename A25, typename A26, typename A27, typename A28, typename A29, typename A30, typename A31>
inline tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15, typename tuple_type<A16>::transparent_reference a16, typename tuple_type<A17>::transparent_reference a17, typename tuple_type<A18>::transparent_reference a18, typename tuple_type<A19>::transparent_reference a19, typename tuple_type<A20>::transparent_reference a20, typename tuple_type<A21>::transparent_reference a21, typename tuple_type<A22>::transparent_reference a22, typename tuple_type<A23>::transparent_reference a23, typename tuple_type<A24>::transparent_reference a24, typename tuple_type<A25>::transparent_reference a25, typename tuple_type<A26>::transparent_reference a26, typename tuple_type<A27>::transparent_reference a27, typename tuple_type<A28>::transparent_reference a28, typename tuple_type<A29>::transparent_reference a29, typename tuple_type<A30>::transparent_reference a30, typename tuple_type<A31>::transparent_reference a31)
{
    return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, A23, A24, A25, A26, A27, A28, A29, A30, A31>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31);
}

/// @endcond

}  // namespace type

namespace adaptor {

template <>
struct convert<type::tuple<> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<>&) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        return o;
    }
};

/// @cond

template <typename A0>
struct convert<type::tuple<A0> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        return o;
    }
};

template <typename A0, typename A1>
struct convert<type::tuple<A0, A1> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        return o;
    }
};

template <typename A0, typename A1, typename A2>
struct convert<type::tuple<A0, A1, A2> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3>
struct convert<type::tuple<A0, A1, A2, A3> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct convert<type::tuple<A0, A1, A2, A3, A4> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 7)
            o.via.array.ptr[7].msgpack::object::convert<typename type::tuple_type<A7>::type>(v.template get<7>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 7)
            o.via.array.ptr[7].msgpack::object::convert<typename type::tuple_type<A7>::type>(v.template get<7>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 8)
            o.via.array.ptr[8].msgpack::object::convert<typename type::tuple_type<A8>::type>(v.template get<8>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 7)
            o.via.array.ptr[7].msgpack::object::convert<typename type::tuple_type<A7>::type>(v.template get<7>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 8)
            o.via.array.ptr[8].msgpack::object::convert<typename type::tuple_type<A8>::type>(v.template get<8>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 9)
            o.via.array.ptr[9].msgpack::object::convert<typename type::tuple_type<A9>::type>(v.template get<9>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 7)
            o.via.array.ptr[7].msgpack::object::convert<typename type::tuple_type<A7>::type>(v.template get<7>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 8)
            o.via.array.ptr[8].msgpack::object::convert<typename type::tuple_type<A8>::type>(v.template get<8>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 9)
            o.via.array.ptr[9].msgpack::object::convert<typename type::tuple_type<A9>::type>(v.template get<9>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 10)
            o.via.array.ptr[10].msgpack::object::convert<typename type::tuple_type<A10>::type>(v.template get<10>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 7)
            o.via.array.ptr[7].msgpack::object::convert<typename type::tuple_type<A7>::type>(v.template get<7>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 8)
            o.via.array.ptr[8].msgpack::object::convert<typename type::tuple_type<A8>::type>(v.template get<8>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 9)
            o.via.array.ptr[9].msgpack::object::convert<typename type::tuple_type<A9>::type>(v.template get<9>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 10)
            o.via.array.ptr[10].msgpack::object::convert<typename type::tuple_type<A10>::type>(v.template get<10>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 11)
            o.via.array.ptr[11].msgpack::object::convert<typename type::tuple_type<A11>::type>(v.template get<11>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 7)
            o.via.array.ptr[7].msgpack::object::convert<typename type::tuple_type<A7>::type>(v.template get<7>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 8)
            o.via.array.ptr[8].msgpack::object::convert<typename type::tuple_type<A8>::type>(v.template get<8>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 9)
            o.via.array.ptr[9].msgpack::object::convert<typename type::tuple_type<A9>::type>(v.template get<9>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 10)
            o.via.array.ptr[10].msgpack::object::convert<typename type::tuple_type<A10>::type>(v.template get<10>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 11)
            o.via.array.ptr[11].msgpack::object::convert<typename type::tuple_type<A11>::type>(v.template get<11>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 12)
            o.via.array.ptr[12].msgpack::object::convert<typename type::tuple_type<A12>::type>(v.template get<12>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& v) const {
        if(o.type != msgpack::type::ARRAY) { throw msgpack::type_error(); }
        
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 0)
            o.via.array.ptr[0].msgpack::object::convert<typename type::tuple_type<A0>::type>(v.template get<0>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 1)
            o.via.array.ptr[1].msgpack::object::convert<typename type::tuple_type<A1>::type>(v.template get<1>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 2)
            o.via.array.ptr[2].msgpack::object::convert<typename type::tuple_type<A2>::type>(v.template get<2>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 3)
            o.via.array.ptr[3].msgpack::object::convert<typename type::tuple_type<A3>::type>(v.template get<3>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 4)
            o.via.array.ptr[4].msgpack::object::convert<typename type::tuple_type<A4>::type>(v.template get<4>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 5)
            o.via.array.ptr[5].msgpack::object::convert<typename type::tuple_type<A5>::type>(v.template get<5>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 6)
            o.via.array.ptr[6].msgpack::object::convert<typename type::tuple_type<A6>::type>(v.template get<6>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 7)
            o.via.array.ptr[7].msgpack::object::convert<typename type::tuple_type<A7>::type>(v.template get<7>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 8)
            o.via.array.ptr[8].msgpack::object::convert<typename type::tuple_type<A8>::type>(v.template get<8>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 9)
            o.via.array.ptr[9].msgpack::object::convert<typename type::tuple_type<A9>::type>(v.template get<9>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 10)
            o.via.array.ptr[10].msgpack::object::convert<typename type::tuple_type<A10>::type>(v.template get<10>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 11)
            o.via.array.ptr[11].msgpack::object::convert<typename type::tuple_type<A11>::type>(v.template get<11>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 12)
            o.via.array.ptr[12].msgpack::object::convert<typename type::tuple_type<A12>::type>(v.template get<12>());
        // In order to avoid clang++'s invalid warning, msgpack::object:: has been added.
        if(o.via.array.size > 13)
            o.via.array.ptr[13].msgpack::object::convert<typename type::tuple_type<A13>::type>(v.template get<13>());
        return o;
    }
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct convert<type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> > {
    msgpack::object const& operator()(
        msgpack::object const& o,
        type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, 