/*
 *  Copyright (C) 2015-2019 Savoir-faire Linux Inc.
 *  Author: Stepan Salenikovich <stepan.salenikovich@savoirfairelinux.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.
 */

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <cstdlib>
#include "config.h"
#include "client.h"

int
main(int argc, char *argv[])
{
    setenv("GDK_BACKEND", "x11", true); // workaround for Wayland

    /* Internationalization; localization is done automatically by gtk during init */
    bindtextdomain(PACKAGE_NAME, LOCALEDIR);
    bind_textdomain_codeset(PACKAGE_NAME, "UTF-8");
    textdomain(PACKAGE_NAME);

    Client *client = client_new(argc, argv);
    g_set_application_name(JAMI_CLIENT_NAME);
    return g_application_run(G_APPLICATION(client), argc, argv);
}
